/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iottwinmaker.model.ComponentTypeSummariesCopier;
import software.amazon.awssdk.services.iottwinmaker.model.ComponentTypeSummary;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListComponentTypesResponse
extends IoTTwinMakerResponse
implements ToCopyableBuilder<Builder, ListComponentTypesResponse> {
    private static final SdkField<List<ComponentTypeSummary>> COMPONENT_TYPE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("componentTypeSummaries").getter(ListComponentTypesResponse.getter(ListComponentTypesResponse::componentTypeSummaries)).setter(ListComponentTypesResponse.setter(Builder::componentTypeSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentTypeSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentTypeSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListComponentTypesResponse.getter(ListComponentTypesResponse::maxResults)).setter(ListComponentTypesResponse.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListComponentTypesResponse.getter(ListComponentTypesResponse::nextToken)).setter(ListComponentTypesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(ListComponentTypesResponse.getter(ListComponentTypesResponse::workspaceId)).setter(ListComponentTypesResponse.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_TYPE_SUMMARIES_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, WORKSPACE_ID_FIELD));
    private final List<ComponentTypeSummary> componentTypeSummaries;
    private final Integer maxResults;
    private final String nextToken;
    private final String workspaceId;

    private ListComponentTypesResponse(BuilderImpl builder) {
        super(builder);
        this.componentTypeSummaries = builder.componentTypeSummaries;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.workspaceId = builder.workspaceId;
    }

    public final boolean hasComponentTypeSummaries() {
        return this.componentTypeSummaries != null && !(this.componentTypeSummaries instanceof SdkAutoConstructList);
    }

    public final List<ComponentTypeSummary> componentTypeSummaries() {
        return this.componentTypeSummaries;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComponentTypeSummaries() ? this.componentTypeSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComponentTypesResponse)) {
            return false;
        }
        ListComponentTypesResponse other = (ListComponentTypesResponse)((Object)obj);
        return this.hasComponentTypeSummaries() == other.hasComponentTypeSummaries() && Objects.equals(this.componentTypeSummaries(), other.componentTypeSummaries()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.workspaceId(), other.workspaceId());
    }

    public final String toString() {
        return ToString.builder((String)"ListComponentTypesResponse").add("ComponentTypeSummaries", this.hasComponentTypeSummaries() ? this.componentTypeSummaries() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("WorkspaceId", (Object)this.workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "componentTypeSummaries": {
                return Optional.ofNullable(clazz.cast(this.componentTypeSummaries()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListComponentTypesResponse, T> g) {
        return obj -> g.apply((ListComponentTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerResponse.BuilderImpl
    implements Builder {
        private List<ComponentTypeSummary> componentTypeSummaries = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;
        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComponentTypesResponse model) {
            super(model);
            this.componentTypeSummaries(model.componentTypeSummaries);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.workspaceId(model.workspaceId);
        }

        public final List<ComponentTypeSummary.Builder> getComponentTypeSummaries() {
            List<ComponentTypeSummary.Builder> result = ComponentTypeSummariesCopier.copyToBuilder(this.componentTypeSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComponentTypeSummaries(Collection<ComponentTypeSummary.BuilderImpl> componentTypeSummaries) {
            this.componentTypeSummaries = ComponentTypeSummariesCopier.copyFromBuilder(componentTypeSummaries);
        }

        @Override
        @Transient
        public final Builder componentTypeSummaries(Collection<ComponentTypeSummary> componentTypeSummaries) {
            this.componentTypeSummaries = ComponentTypeSummariesCopier.copy(componentTypeSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder componentTypeSummaries(ComponentTypeSummary ... componentTypeSummaries) {
            this.componentTypeSummaries(Arrays.asList(componentTypeSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder componentTypeSummaries(Consumer<ComponentTypeSummary.Builder> ... componentTypeSummaries) {
            this.componentTypeSummaries(Stream.of(componentTypeSummaries).map(c -> (ComponentTypeSummary)((ComponentTypeSummary.Builder)ComponentTypeSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        @Transient
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public ListComponentTypesResponse build() {
            return new ListComponentTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTTwinMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListComponentTypesResponse> {
        public Builder componentTypeSummaries(Collection<ComponentTypeSummary> var1);

        public Builder componentTypeSummaries(ComponentTypeSummary ... var1);

        public Builder componentTypeSummaries(Consumer<ComponentTypeSummary.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder workspaceId(String var1);
    }
}

