/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SceneSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SceneSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(SceneSummary.getter(SceneSummary::arn)).setter(SceneSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CONTENT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentLocation").getter(SceneSummary.getter(SceneSummary::contentLocation)).setter(SceneSummary.setter(Builder::contentLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentLocation").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(SceneSummary.getter(SceneSummary::creationDateTime)).setter(SceneSummary.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(SceneSummary.getter(SceneSummary::description)).setter(SceneSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> SCENE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sceneId").getter(SceneSummary.getter(SceneSummary::sceneId)).setter(SceneSummary.setter(Builder::sceneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sceneId").build()}).build();
    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateDateTime").getter(SceneSummary.getter(SceneSummary::updateDateTime)).setter(SceneSummary.setter(Builder::updateDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CONTENT_LOCATION_FIELD, CREATION_DATE_TIME_FIELD, DESCRIPTION_FIELD, SCENE_ID_FIELD, UPDATE_DATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String contentLocation;
    private final Instant creationDateTime;
    private final String description;
    private final String sceneId;
    private final Instant updateDateTime;

    private SceneSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.contentLocation = builder.contentLocation;
        this.creationDateTime = builder.creationDateTime;
        this.description = builder.description;
        this.sceneId = builder.sceneId;
        this.updateDateTime = builder.updateDateTime;
    }

    public final String arn() {
        return this.arn;
    }

    public final String contentLocation() {
        return this.contentLocation;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final String description() {
        return this.description;
    }

    public final String sceneId() {
        return this.sceneId;
    }

    public final Instant updateDateTime() {
        return this.updateDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.sceneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SceneSummary)) {
            return false;
        }
        SceneSummary other = (SceneSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.contentLocation(), other.contentLocation()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.sceneId(), other.sceneId()) && Objects.equals(this.updateDateTime(), other.updateDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"SceneSummary").add("Arn", (Object)this.arn()).add("ContentLocation", (Object)this.contentLocation()).add("CreationDateTime", (Object)this.creationDateTime()).add("Description", (Object)this.description()).add("SceneId", (Object)this.sceneId()).add("UpdateDateTime", (Object)this.updateDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "contentLocation": {
                return Optional.ofNullable(clazz.cast(this.contentLocation()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "sceneId": {
                return Optional.ofNullable(clazz.cast(this.sceneId()));
            }
            case "updateDateTime": {
                return Optional.ofNullable(clazz.cast(this.updateDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SceneSummary, T> g) {
        return obj -> g.apply((SceneSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String contentLocation;
        private Instant creationDateTime;
        private String description;
        private String sceneId;
        private Instant updateDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SceneSummary model) {
            this.arn(model.arn);
            this.contentLocation(model.contentLocation);
            this.creationDateTime(model.creationDateTime);
            this.description(model.description);
            this.sceneId(model.sceneId);
            this.updateDateTime(model.updateDateTime);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getContentLocation() {
            return this.contentLocation;
        }

        public final void setContentLocation(String contentLocation) {
            this.contentLocation = contentLocation;
        }

        @Override
        @Transient
        public final Builder contentLocation(String contentLocation) {
            this.contentLocation = contentLocation;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        @Transient
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSceneId() {
            return this.sceneId;
        }

        public final void setSceneId(String sceneId) {
            this.sceneId = sceneId;
        }

        @Override
        @Transient
        public final Builder sceneId(String sceneId) {
            this.sceneId = sceneId;
            return this;
        }

        public final Instant getUpdateDateTime() {
            return this.updateDateTime;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        @Override
        @Transient
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        public SceneSummary build() {
            return new SceneSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SceneSummary> {
        public Builder arn(String var1);

        public Builder contentLocation(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder description(String var1);

        public Builder sceneId(String var1);

        public Builder updateDateTime(Instant var1);
    }
}

