/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Relationship
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Relationship> {
    private static final SdkField<String> RELATIONSHIP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relationshipType").getter(Relationship.getter(Relationship::relationshipType)).setter(Relationship.setter(Builder::relationshipType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationshipType").build()}).build();
    private static final SdkField<String> TARGET_COMPONENT_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetComponentTypeId").getter(Relationship.getter(Relationship::targetComponentTypeId)).setter(Relationship.setter(Builder::targetComponentTypeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetComponentTypeId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATIONSHIP_TYPE_FIELD, TARGET_COMPONENT_TYPE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String relationshipType;
    private final String targetComponentTypeId;

    private Relationship(BuilderImpl builder) {
        this.relationshipType = builder.relationshipType;
        this.targetComponentTypeId = builder.targetComponentTypeId;
    }

    public final String relationshipType() {
        return this.relationshipType;
    }

    public final String targetComponentTypeId() {
        return this.targetComponentTypeId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.relationshipType());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetComponentTypeId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Relationship)) {
            return false;
        }
        Relationship other = (Relationship)obj;
        return Objects.equals(this.relationshipType(), other.relationshipType()) && Objects.equals(this.targetComponentTypeId(), other.targetComponentTypeId());
    }

    public final String toString() {
        return ToString.builder((String)"Relationship").add("RelationshipType", (Object)this.relationshipType()).add("TargetComponentTypeId", (Object)this.targetComponentTypeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "relationshipType": {
                return Optional.ofNullable(clazz.cast(this.relationshipType()));
            }
            case "targetComponentTypeId": {
                return Optional.ofNullable(clazz.cast(this.targetComponentTypeId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Relationship, T> g) {
        return obj -> g.apply((Relationship)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String relationshipType;
        private String targetComponentTypeId;

        private BuilderImpl() {
        }

        private BuilderImpl(Relationship model) {
            this.relationshipType(model.relationshipType);
            this.targetComponentTypeId(model.targetComponentTypeId);
        }

        public final String getRelationshipType() {
            return this.relationshipType;
        }

        public final void setRelationshipType(String relationshipType) {
            this.relationshipType = relationshipType;
        }

        @Override
        @Transient
        public final Builder relationshipType(String relationshipType) {
            this.relationshipType = relationshipType;
            return this;
        }

        public final String getTargetComponentTypeId() {
            return this.targetComponentTypeId;
        }

        public final void setTargetComponentTypeId(String targetComponentTypeId) {
            this.targetComponentTypeId = targetComponentTypeId;
        }

        @Override
        @Transient
        public final Builder targetComponentTypeId(String targetComponentTypeId) {
            this.targetComponentTypeId = targetComponentTypeId;
            return this;
        }

        public Relationship build() {
            return new Relationship(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Relationship> {
        public Builder relationshipType(String var1);

        public Builder targetComponentTypeId(String var1);
    }
}

