/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorkspaceResponse
extends IoTTwinMakerResponse
implements ToCopyableBuilder<Builder, CreateWorkspaceResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(CreateWorkspaceResponse.getter(CreateWorkspaceResponse::arn)).setter(CreateWorkspaceResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(CreateWorkspaceResponse.getter(CreateWorkspaceResponse::creationDateTime)).setter(CreateWorkspaceResponse.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATION_DATE_TIME_FIELD));
    private final String arn;
    private final Instant creationDateTime;

    private CreateWorkspaceResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationDateTime = builder.creationDateTime;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkspaceResponse)) {
            return false;
        }
        CreateWorkspaceResponse other = (CreateWorkspaceResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationDateTime(), other.creationDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWorkspaceResponse").add("Arn", (Object)this.arn()).add("CreationDateTime", (Object)this.creationDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkspaceResponse, T> g) {
        return obj -> g.apply((CreateWorkspaceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerResponse.BuilderImpl
    implements Builder {
        private String arn;
        private Instant creationDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkspaceResponse model) {
            super(model);
            this.arn(model.arn);
            this.creationDateTime(model.creationDateTime);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        @Transient
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        @Override
        public CreateWorkspaceResponse build() {
            return new CreateWorkspaceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTTwinMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorkspaceResponse> {
        public Builder arn(String var1);

        public Builder creationDateTime(Instant var1);
    }
}

