/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iottwinmaker.IoTTwinMakerClient;
import software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesResponse;

public class ListComponentTypesIterable
implements SdkIterable<ListComponentTypesResponse> {
    private final IoTTwinMakerClient client;
    private final ListComponentTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListComponentTypesIterable(IoTTwinMakerClient client, ListComponentTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListComponentTypesResponseFetcher();
    }

    public Iterator<ListComponentTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListComponentTypesResponseFetcher
    implements SyncPageFetcher<ListComponentTypesResponse> {
        private ListComponentTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListComponentTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListComponentTypesResponse nextPage(ListComponentTypesResponse previousPage) {
            if (previousPage == null) {
                return ListComponentTypesIterable.this.client.listComponentTypes(ListComponentTypesIterable.this.firstRequest);
            }
            return ListComponentTypesIterable.this.client.listComponentTypes((ListComponentTypesRequest)((Object)ListComponentTypesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

