/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iottwinmaker.model.ConfigurationCopier;
import software.amazon.awssdk.services.iottwinmaker.model.DataType;
import software.amazon.awssdk.services.iottwinmaker.model.DataValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PropertyDefinitionResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PropertyDefinitionResponse> {
    private static final SdkField<Map<String, String>> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("configuration").getter(PropertyDefinitionResponse.getter(PropertyDefinitionResponse::configuration)).setter(PropertyDefinitionResponse.setter(Builder::configuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<DataType> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataType").getter(PropertyDefinitionResponse.getter(PropertyDefinitionResponse::dataType)).setter(PropertyDefinitionResponse.setter(Builder::dataType)).constructor(DataType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()}).build();
    private static final SdkField<DataValue> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("defaultValue").getter(PropertyDefinitionResponse.getter(PropertyDefinitionResponse::defaultValue)).setter(PropertyDefinitionResponse.setter(Builder::defaultValue)).constructor(DataValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()}).build();
    private static final SdkField<Boolean> IS_EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isExternalId").getter(PropertyDefinitionResponse.getter(PropertyDefinitionResponse::isExternalId)).setter(PropertyDefinitionResponse.setter(Builder::isExternalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isExternalId").build()}).build();
    private static final SdkField<Boolean> IS_FINAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isFinal").getter(PropertyDefinitionResponse.getter(PropertyDefinitionResponse::isFinal)).setter(PropertyDefinitionResponse.setter(Builder::isFinal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isFinal").build()}).build();
    private static final SdkField<Boolean> IS_IMPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isImported").getter(PropertyDefinitionResponse.getter(PropertyDefinitionResponse::isImported)).setter(PropertyDefinitionResponse.setter(Builder::isImported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isImported").build()}).build();
    private static final SdkField<Boolean> IS_INHERITED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isInherited").getter(PropertyDefinitionResponse.getter(PropertyDefinitionResponse::isInherited)).setter(PropertyDefinitionResponse.setter(Builder::isInherited)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isInherited").build()}).build();
    private static final SdkField<Boolean> IS_REQUIRED_IN_ENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isRequiredInEntity").getter(PropertyDefinitionResponse.getter(PropertyDefinitionResponse::isRequiredInEntity)).setter(PropertyDefinitionResponse.setter(Builder::isRequiredInEntity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isRequiredInEntity").build()}).build();
    private static final SdkField<Boolean> IS_STORED_EXTERNALLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isStoredExternally").getter(PropertyDefinitionResponse.getter(PropertyDefinitionResponse::isStoredExternally)).setter(PropertyDefinitionResponse.setter(Builder::isStoredExternally)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isStoredExternally").build()}).build();
    private static final SdkField<Boolean> IS_TIME_SERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isTimeSeries").getter(PropertyDefinitionResponse.getter(PropertyDefinitionResponse::isTimeSeries)).setter(PropertyDefinitionResponse.setter(Builder::isTimeSeries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isTimeSeries").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD, DATA_TYPE_FIELD, DEFAULT_VALUE_FIELD, IS_EXTERNAL_ID_FIELD, IS_FINAL_FIELD, IS_IMPORTED_FIELD, IS_INHERITED_FIELD, IS_REQUIRED_IN_ENTITY_FIELD, IS_STORED_EXTERNALLY_FIELD, IS_TIME_SERIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, String> configuration;
    private final DataType dataType;
    private final DataValue defaultValue;
    private final Boolean isExternalId;
    private final Boolean isFinal;
    private final Boolean isImported;
    private final Boolean isInherited;
    private final Boolean isRequiredInEntity;
    private final Boolean isStoredExternally;
    private final Boolean isTimeSeries;

    private PropertyDefinitionResponse(BuilderImpl builder) {
        this.configuration = builder.configuration;
        this.dataType = builder.dataType;
        this.defaultValue = builder.defaultValue;
        this.isExternalId = builder.isExternalId;
        this.isFinal = builder.isFinal;
        this.isImported = builder.isImported;
        this.isInherited = builder.isInherited;
        this.isRequiredInEntity = builder.isRequiredInEntity;
        this.isStoredExternally = builder.isStoredExternally;
        this.isTimeSeries = builder.isTimeSeries;
    }

    public final boolean hasConfiguration() {
        return this.configuration != null && !(this.configuration instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> configuration() {
        return this.configuration;
    }

    public final DataType dataType() {
        return this.dataType;
    }

    public final DataValue defaultValue() {
        return this.defaultValue;
    }

    public final Boolean isExternalId() {
        return this.isExternalId;
    }

    public final Boolean isFinal() {
        return this.isFinal;
    }

    public final Boolean isImported() {
        return this.isImported;
    }

    public final Boolean isInherited() {
        return this.isInherited;
    }

    public final Boolean isRequiredInEntity() {
        return this.isRequiredInEntity;
    }

    public final Boolean isStoredExternally() {
        return this.isStoredExternally;
    }

    public final Boolean isTimeSeries() {
        return this.isTimeSeries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfiguration() ? this.configuration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataType());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.isExternalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isFinal());
        hashCode = 31 * hashCode + Objects.hashCode(this.isImported());
        hashCode = 31 * hashCode + Objects.hashCode(this.isInherited());
        hashCode = 31 * hashCode + Objects.hashCode(this.isRequiredInEntity());
        hashCode = 31 * hashCode + Objects.hashCode(this.isStoredExternally());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTimeSeries());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyDefinitionResponse)) {
            return false;
        }
        PropertyDefinitionResponse other = (PropertyDefinitionResponse)obj;
        return this.hasConfiguration() == other.hasConfiguration() && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.dataType(), other.dataType()) && Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.isExternalId(), other.isExternalId()) && Objects.equals(this.isFinal(), other.isFinal()) && Objects.equals(this.isImported(), other.isImported()) && Objects.equals(this.isInherited(), other.isInherited()) && Objects.equals(this.isRequiredInEntity(), other.isRequiredInEntity()) && Objects.equals(this.isStoredExternally(), other.isStoredExternally()) && Objects.equals(this.isTimeSeries(), other.isTimeSeries());
    }

    public final String toString() {
        return ToString.builder((String)"PropertyDefinitionResponse").add("Configuration", this.hasConfiguration() ? this.configuration() : null).add("DataType", (Object)this.dataType()).add("DefaultValue", (Object)this.defaultValue()).add("IsExternalId", (Object)this.isExternalId()).add("IsFinal", (Object)this.isFinal()).add("IsImported", (Object)this.isImported()).add("IsInherited", (Object)this.isInherited()).add("IsRequiredInEntity", (Object)this.isRequiredInEntity()).add("IsStoredExternally", (Object)this.isStoredExternally()).add("IsTimeSeries", (Object)this.isTimeSeries()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "dataType": {
                return Optional.ofNullable(clazz.cast(this.dataType()));
            }
            case "defaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "isExternalId": {
                return Optional.ofNullable(clazz.cast(this.isExternalId()));
            }
            case "isFinal": {
                return Optional.ofNullable(clazz.cast(this.isFinal()));
            }
            case "isImported": {
                return Optional.ofNullable(clazz.cast(this.isImported()));
            }
            case "isInherited": {
                return Optional.ofNullable(clazz.cast(this.isInherited()));
            }
            case "isRequiredInEntity": {
                return Optional.ofNullable(clazz.cast(this.isRequiredInEntity()));
            }
            case "isStoredExternally": {
                return Optional.ofNullable(clazz.cast(this.isStoredExternally()));
            }
            case "isTimeSeries": {
                return Optional.ofNullable(clazz.cast(this.isTimeSeries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PropertyDefinitionResponse, T> g) {
        return obj -> g.apply((PropertyDefinitionResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> configuration = DefaultSdkAutoConstructMap.getInstance();
        private DataType dataType;
        private DataValue defaultValue;
        private Boolean isExternalId;
        private Boolean isFinal;
        private Boolean isImported;
        private Boolean isInherited;
        private Boolean isRequiredInEntity;
        private Boolean isStoredExternally;
        private Boolean isTimeSeries;

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyDefinitionResponse model) {
            this.configuration(model.configuration);
            this.dataType(model.dataType);
            this.defaultValue(model.defaultValue);
            this.isExternalId(model.isExternalId);
            this.isFinal(model.isFinal);
            this.isImported(model.isImported);
            this.isInherited(model.isInherited);
            this.isRequiredInEntity(model.isRequiredInEntity);
            this.isStoredExternally(model.isStoredExternally);
            this.isTimeSeries(model.isTimeSeries);
        }

        public final Map<String, String> getConfiguration() {
            if (this.configuration instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.configuration;
        }

        public final void setConfiguration(Map<String, String> configuration) {
            this.configuration = ConfigurationCopier.copy(configuration);
        }

        @Override
        @Transient
        public final Builder configuration(Map<String, String> configuration) {
            this.configuration = ConfigurationCopier.copy(configuration);
            return this;
        }

        public final DataType.Builder getDataType() {
            return this.dataType != null ? this.dataType.toBuilder() : null;
        }

        public final void setDataType(DataType.BuilderImpl dataType) {
            this.dataType = dataType != null ? dataType.build() : null;
        }

        @Override
        @Transient
        public final Builder dataType(DataType dataType) {
            this.dataType = dataType;
            return this;
        }

        public final DataValue.Builder getDefaultValue() {
            return this.defaultValue != null ? this.defaultValue.toBuilder() : null;
        }

        public final void setDefaultValue(DataValue.BuilderImpl defaultValue) {
            this.defaultValue = defaultValue != null ? defaultValue.build() : null;
        }

        @Override
        @Transient
        public final Builder defaultValue(DataValue defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final Boolean getIsExternalId() {
            return this.isExternalId;
        }

        public final void setIsExternalId(Boolean isExternalId) {
            this.isExternalId = isExternalId;
        }

        @Override
        @Transient
        public final Builder isExternalId(Boolean isExternalId) {
            this.isExternalId = isExternalId;
            return this;
        }

        public final Boolean getIsFinal() {
            return this.isFinal;
        }

        public final void setIsFinal(Boolean isFinal) {
            this.isFinal = isFinal;
        }

        @Override
        @Transient
        public final Builder isFinal(Boolean isFinal) {
            this.isFinal = isFinal;
            return this;
        }

        public final Boolean getIsImported() {
            return this.isImported;
        }

        public final void setIsImported(Boolean isImported) {
            this.isImported = isImported;
        }

        @Override
        @Transient
        public final Builder isImported(Boolean isImported) {
            this.isImported = isImported;
            return this;
        }

        public final Boolean getIsInherited() {
            return this.isInherited;
        }

        public final void setIsInherited(Boolean isInherited) {
            this.isInherited = isInherited;
        }

        @Override
        @Transient
        public final Builder isInherited(Boolean isInherited) {
            this.isInherited = isInherited;
            return this;
        }

        public final Boolean getIsRequiredInEntity() {
            return this.isRequiredInEntity;
        }

        public final void setIsRequiredInEntity(Boolean isRequiredInEntity) {
            this.isRequiredInEntity = isRequiredInEntity;
        }

        @Override
        @Transient
        public final Builder isRequiredInEntity(Boolean isRequiredInEntity) {
            this.isRequiredInEntity = isRequiredInEntity;
            return this;
        }

        public final Boolean getIsStoredExternally() {
            return this.isStoredExternally;
        }

        public final void setIsStoredExternally(Boolean isStoredExternally) {
            this.isStoredExternally = isStoredExternally;
        }

        @Override
        @Transient
        public final Builder isStoredExternally(Boolean isStoredExternally) {
            this.isStoredExternally = isStoredExternally;
            return this;
        }

        public final Boolean getIsTimeSeries() {
            return this.isTimeSeries;
        }

        public final void setIsTimeSeries(Boolean isTimeSeries) {
            this.isTimeSeries = isTimeSeries;
        }

        @Override
        @Transient
        public final Builder isTimeSeries(Boolean isTimeSeries) {
            this.isTimeSeries = isTimeSeries;
            return this;
        }

        public PropertyDefinitionResponse build() {
            return new PropertyDefinitionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PropertyDefinitionResponse> {
        public Builder configuration(Map<String, String> var1);

        public Builder dataType(DataType var1);

        default public Builder dataType(Consumer<DataType.Builder> dataType) {
            return this.dataType((DataType)((DataType.Builder)DataType.builder().applyMutation(dataType)).build());
        }

        public Builder defaultValue(DataValue var1);

        default public Builder defaultValue(Consumer<DataValue.Builder> defaultValue) {
            return this.defaultValue((DataValue)((DataValue.Builder)DataValue.builder().applyMutation(defaultValue)).build());
        }

        public Builder isExternalId(Boolean var1);

        public Builder isFinal(Boolean var1);

        public Builder isImported(Boolean var1);

        public Builder isInherited(Boolean var1);

        public Builder isRequiredInEntity(Boolean var1);

        public Builder isStoredExternally(Boolean var1);

        public Builder isTimeSeries(Boolean var1);
    }
}

