/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotthingsgraph.IoTThingsGraphAsyncClient;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SystemTemplateSummary;

public class GetSystemTemplateRevisionsPublisher
implements SdkPublisher<GetSystemTemplateRevisionsResponse> {
    private final IoTThingsGraphAsyncClient client;
    private final GetSystemTemplateRevisionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetSystemTemplateRevisionsPublisher(IoTThingsGraphAsyncClient client, GetSystemTemplateRevisionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetSystemTemplateRevisionsPublisher(IoTThingsGraphAsyncClient client, GetSystemTemplateRevisionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetSystemTemplateRevisionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetSystemTemplateRevisionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SystemTemplateSummary> summaries() {
        Function<GetSystemTemplateRevisionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetSystemTemplateRevisionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetSystemTemplateRevisionsResponseFetcher
    implements AsyncPageFetcher<GetSystemTemplateRevisionsResponse> {
        private GetSystemTemplateRevisionsResponseFetcher() {
        }

        public boolean hasNextPage(GetSystemTemplateRevisionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetSystemTemplateRevisionsResponse> nextPage(GetSystemTemplateRevisionsResponse previousPage) {
            if (previousPage == null) {
                return GetSystemTemplateRevisionsPublisher.this.client.getSystemTemplateRevisions(GetSystemTemplateRevisionsPublisher.this.firstRequest);
            }
            return GetSystemTemplateRevisionsPublisher.this.client.getSystemTemplateRevisions((GetSystemTemplateRevisionsRequest)((Object)GetSystemTemplateRevisionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

