/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iotthingsgraph.model.EntityFilterName;
import software.amazon.awssdk.services.iotthingsgraph.model.EntityFilterValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntityFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntityFilter> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EntityFilter.getter(EntityFilter::nameAsString)).setter(EntityFilter.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EntityFilter.getter(EntityFilter::value)).setter(EntityFilter.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> value;

    private EntityFilter(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
    }

    public EntityFilterName name() {
        return EntityFilterName.fromValue(this.name);
    }

    public String nameAsString() {
        return this.name;
    }

    public List<String> value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityFilter)) {
            return false;
        }
        EntityFilter other = (EntityFilter)obj;
        return Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.value(), other.value());
    }

    public String toString() {
        return ToString.builder((String)"EntityFilter").add("Name", (Object)this.nameAsString()).add("Value", this.value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityFilter, T> g) {
        return obj -> g.apply((EntityFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> value = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EntityFilter model) {
            this.name(model.name);
            this.value(model.value);
        }

        public final String getNameAsString() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(EntityFilterName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getValue() {
            return this.value;
        }

        @Override
        public final Builder value(Collection<String> value) {
            this.value = EntityFilterValuesCopier.copy(value);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder value(String ... value) {
            this.value(Arrays.asList(value));
            return this;
        }

        public final void setValue(Collection<String> value) {
            this.value = EntityFilterValuesCopier.copy(value);
        }

        public EntityFilter build() {
            return new EntityFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntityFilter> {
        public Builder name(String var1);

        public Builder name(EntityFilterName var1);

        public Builder value(Collection<String> var1);

        public Builder value(String ... var1);
    }
}

