/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotthingsgraph.IoTThingsGraphAsyncClient;
import software.amazon.awssdk.services.iotthingsgraph.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SystemTemplateSummary;

public class SearchSystemTemplatesPublisher
implements SdkPublisher<SearchSystemTemplatesResponse> {
    private final IoTThingsGraphAsyncClient client;
    private final SearchSystemTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchSystemTemplatesPublisher(IoTThingsGraphAsyncClient client, SearchSystemTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchSystemTemplatesPublisher(IoTThingsGraphAsyncClient client, SearchSystemTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchSystemTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchSystemTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SystemTemplateSummary> summaries() {
        Function<SearchSystemTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchSystemTemplatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchSystemTemplatesResponseFetcher
    implements AsyncPageFetcher<SearchSystemTemplatesResponse> {
        private SearchSystemTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(SearchSystemTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchSystemTemplatesResponse> nextPage(SearchSystemTemplatesResponse previousPage) {
            if (previousPage == null) {
                return SearchSystemTemplatesPublisher.this.client.searchSystemTemplates(SearchSystemTemplatesPublisher.this.firstRequest);
            }
            return SearchSystemTemplatesPublisher.this.client.searchSystemTemplates((SearchSystemTemplatesRequest)((Object)SearchSystemTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

