/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSystemInstanceResponse extends IoTThingsGraphResponse implements
        ToCopyableBuilder<GetSystemInstanceResponse.Builder, GetSystemInstanceResponse> {
    private static final SdkField<SystemInstanceDescription> DESCRIPTION_FIELD = SdkField
            .<SystemInstanceDescription> builder(MarshallingType.SDK_POJO).memberName("description")
            .getter(getter(GetSystemInstanceResponse::description)).setter(setter(Builder::description))
            .constructor(SystemInstanceDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD));

    private final SystemInstanceDescription description;

    private GetSystemInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
    }

    /**
     * <p>
     * An object that describes the system instance.
     * </p>
     * 
     * @return An object that describes the system instance.
     */
    public final SystemInstanceDescription description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSystemInstanceResponse)) {
            return false;
        }
        GetSystemInstanceResponse other = (GetSystemInstanceResponse) obj;
        return Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSystemInstanceResponse").add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSystemInstanceResponse, T> g) {
        return obj -> g.apply((GetSystemInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTThingsGraphResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSystemInstanceResponse> {
        /**
         * <p>
         * An object that describes the system instance.
         * </p>
         * 
         * @param description
         *        An object that describes the system instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(SystemInstanceDescription description);

        /**
         * <p>
         * An object that describes the system instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link SystemInstanceDescription.Builder}
         * avoiding the need to create one manually via {@link SystemInstanceDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SystemInstanceDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #description(SystemInstanceDescription)}.
         * 
         * @param description
         *        a consumer that will call methods on {@link SystemInstanceDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #description(SystemInstanceDescription)
         */
        default Builder description(Consumer<SystemInstanceDescription.Builder> description) {
            return description(SystemInstanceDescription.builder().applyMutation(description).build());
        }
    }

    static final class BuilderImpl extends IoTThingsGraphResponse.BuilderImpl implements Builder {
        private SystemInstanceDescription description;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSystemInstanceResponse model) {
            super(model);
            description(model.description);
        }

        public final SystemInstanceDescription.Builder getDescription() {
            return description != null ? description.toBuilder() : null;
        }

        public final void setDescription(SystemInstanceDescription.BuilderImpl description) {
            this.description = description != null ? description.build() : null;
        }

        @Override
        public final Builder description(SystemInstanceDescription description) {
            this.description = description;
            return this;
        }

        @Override
        public GetSystemInstanceResponse build() {
            return new GetSystemInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
