/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotthingsgraph.IoTThingsGraphAsyncClient;
import software.amazon.awssdk.services.iotthingsgraph.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceSummary;

public class SearchSystemInstancesPublisher
implements SdkPublisher<SearchSystemInstancesResponse> {
    private final IoTThingsGraphAsyncClient client;
    private final SearchSystemInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchSystemInstancesPublisher(IoTThingsGraphAsyncClient client, SearchSystemInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchSystemInstancesPublisher(IoTThingsGraphAsyncClient client, SearchSystemInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchSystemInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchSystemInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SystemInstanceSummary> summaries() {
        Function<SearchSystemInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchSystemInstancesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchSystemInstancesResponseFetcher
    implements AsyncPageFetcher<SearchSystemInstancesResponse> {
        private SearchSystemInstancesResponseFetcher() {
        }

        public boolean hasNextPage(SearchSystemInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchSystemInstancesResponse> nextPage(SearchSystemInstancesResponse previousPage) {
            if (previousPage == null) {
                return SearchSystemInstancesPublisher.this.client.searchSystemInstances(SearchSystemInstancesPublisher.this.firstRequest);
            }
            return SearchSystemInstancesPublisher.this.client.searchSystemInstances((SearchSystemInstancesRequest)((Object)SearchSystemInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

