/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotthingsgraph.IoTThingsGraphAsyncClient;
import software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionSummary;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsResponse;

public class SearchFlowExecutionsPublisher
implements SdkPublisher<SearchFlowExecutionsResponse> {
    private final IoTThingsGraphAsyncClient client;
    private final SearchFlowExecutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchFlowExecutionsPublisher(IoTThingsGraphAsyncClient client, SearchFlowExecutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchFlowExecutionsPublisher(IoTThingsGraphAsyncClient client, SearchFlowExecutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchFlowExecutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchFlowExecutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FlowExecutionSummary> summaries() {
        Function<SearchFlowExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchFlowExecutionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchFlowExecutionsResponseFetcher
    implements AsyncPageFetcher<SearchFlowExecutionsResponse> {
        private SearchFlowExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(SearchFlowExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchFlowExecutionsResponse> nextPage(SearchFlowExecutionsResponse previousPage) {
            if (previousPage == null) {
                return SearchFlowExecutionsPublisher.this.client.searchFlowExecutions(SearchFlowExecutionsPublisher.this.firstRequest);
            }
            return SearchFlowExecutionsPublisher.this.client.searchFlowExecutions((SearchFlowExecutionsRequest)((Object)SearchFlowExecutionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

