/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotthingsgraph.model.DefinitionDocument;
import software.amazon.awssdk.services.iotthingsgraph.model.DependencyRevision;
import software.amazon.awssdk.services.iotthingsgraph.model.DependencyRevisionsCopier;
import software.amazon.awssdk.services.iotthingsgraph.model.MetricsConfiguration;
import software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SystemInstanceDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SystemInstanceDescription> {
    private static final SdkField<SystemInstanceSummary> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("summary").getter(SystemInstanceDescription.getter(SystemInstanceDescription::summary)).setter(SystemInstanceDescription.setter(Builder::summary)).constructor(SystemInstanceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()}).build();
    private static final SdkField<DefinitionDocument> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("definition").getter(SystemInstanceDescription.getter(SystemInstanceDescription::definition)).setter(SystemInstanceDescription.setter(Builder::definition)).constructor(DefinitionDocument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3BucketName").getter(SystemInstanceDescription.getter(SystemInstanceDescription::s3BucketName)).setter(SystemInstanceDescription.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketName").build()}).build();
    private static final SdkField<MetricsConfiguration> METRICS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metricsConfiguration").getter(SystemInstanceDescription.getter(SystemInstanceDescription::metricsConfiguration)).setter(SystemInstanceDescription.setter(Builder::metricsConfiguration)).constructor(MetricsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsConfiguration").build()}).build();
    private static final SdkField<Long> VALIDATED_NAMESPACE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("validatedNamespaceVersion").getter(SystemInstanceDescription.getter(SystemInstanceDescription::validatedNamespaceVersion)).setter(SystemInstanceDescription.setter(Builder::validatedNamespaceVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validatedNamespaceVersion").build()}).build();
    private static final SdkField<List<DependencyRevision>> VALIDATED_DEPENDENCY_REVISIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("validatedDependencyRevisions").getter(SystemInstanceDescription.getter(SystemInstanceDescription::validatedDependencyRevisions)).setter(SystemInstanceDescription.setter(Builder::validatedDependencyRevisions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validatedDependencyRevisions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DependencyRevision::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FLOW_ACTIONS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowActionsRoleArn").getter(SystemInstanceDescription.getter(SystemInstanceDescription::flowActionsRoleArn)).setter(SystemInstanceDescription.setter(Builder::flowActionsRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowActionsRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARY_FIELD, DEFINITION_FIELD, S3_BUCKET_NAME_FIELD, METRICS_CONFIGURATION_FIELD, VALIDATED_NAMESPACE_VERSION_FIELD, VALIDATED_DEPENDENCY_REVISIONS_FIELD, FLOW_ACTIONS_ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final SystemInstanceSummary summary;
    private final DefinitionDocument definition;
    private final String s3BucketName;
    private final MetricsConfiguration metricsConfiguration;
    private final Long validatedNamespaceVersion;
    private final List<DependencyRevision> validatedDependencyRevisions;
    private final String flowActionsRoleArn;

    private SystemInstanceDescription(BuilderImpl builder) {
        this.summary = builder.summary;
        this.definition = builder.definition;
        this.s3BucketName = builder.s3BucketName;
        this.metricsConfiguration = builder.metricsConfiguration;
        this.validatedNamespaceVersion = builder.validatedNamespaceVersion;
        this.validatedDependencyRevisions = builder.validatedDependencyRevisions;
        this.flowActionsRoleArn = builder.flowActionsRoleArn;
    }

    public final SystemInstanceSummary summary() {
        return this.summary;
    }

    public final DefinitionDocument definition() {
        return this.definition;
    }

    public final String s3BucketName() {
        return this.s3BucketName;
    }

    public final MetricsConfiguration metricsConfiguration() {
        return this.metricsConfiguration;
    }

    public final Long validatedNamespaceVersion() {
        return this.validatedNamespaceVersion;
    }

    public final boolean hasValidatedDependencyRevisions() {
        return this.validatedDependencyRevisions != null && !(this.validatedDependencyRevisions instanceof SdkAutoConstructList);
    }

    public final List<DependencyRevision> validatedDependencyRevisions() {
        return this.validatedDependencyRevisions;
    }

    public final String flowActionsRoleArn() {
        return this.flowActionsRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.validatedNamespaceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidatedDependencyRevisions() ? this.validatedDependencyRevisions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.flowActionsRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SystemInstanceDescription)) {
            return false;
        }
        SystemInstanceDescription other = (SystemInstanceDescription)obj;
        return Objects.equals(this.summary(), other.summary()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.metricsConfiguration(), other.metricsConfiguration()) && Objects.equals(this.validatedNamespaceVersion(), other.validatedNamespaceVersion()) && this.hasValidatedDependencyRevisions() == other.hasValidatedDependencyRevisions() && Objects.equals(this.validatedDependencyRevisions(), other.validatedDependencyRevisions()) && Objects.equals(this.flowActionsRoleArn(), other.flowActionsRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"SystemInstanceDescription").add("Summary", (Object)this.summary()).add("Definition", (Object)this.definition()).add("S3BucketName", (Object)this.s3BucketName()).add("MetricsConfiguration", (Object)this.metricsConfiguration()).add("ValidatedNamespaceVersion", (Object)this.validatedNamespaceVersion()).add("ValidatedDependencyRevisions", this.hasValidatedDependencyRevisions() ? this.validatedDependencyRevisions() : null).add("FlowActionsRoleArn", (Object)this.flowActionsRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "s3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "metricsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.metricsConfiguration()));
            }
            case "validatedNamespaceVersion": {
                return Optional.ofNullable(clazz.cast(this.validatedNamespaceVersion()));
            }
            case "validatedDependencyRevisions": {
                return Optional.ofNullable(clazz.cast(this.validatedDependencyRevisions()));
            }
            case "flowActionsRoleArn": {
                return Optional.ofNullable(clazz.cast(this.flowActionsRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SystemInstanceDescription, T> g) {
        return obj -> g.apply((SystemInstanceDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SystemInstanceSummary summary;
        private DefinitionDocument definition;
        private String s3BucketName;
        private MetricsConfiguration metricsConfiguration;
        private Long validatedNamespaceVersion;
        private List<DependencyRevision> validatedDependencyRevisions = DefaultSdkAutoConstructList.getInstance();
        private String flowActionsRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SystemInstanceDescription model) {
            this.summary(model.summary);
            this.definition(model.definition);
            this.s3BucketName(model.s3BucketName);
            this.metricsConfiguration(model.metricsConfiguration);
            this.validatedNamespaceVersion(model.validatedNamespaceVersion);
            this.validatedDependencyRevisions(model.validatedDependencyRevisions);
            this.flowActionsRoleArn(model.flowActionsRoleArn);
        }

        public final SystemInstanceSummary.Builder getSummary() {
            return this.summary != null ? this.summary.toBuilder() : null;
        }

        @Override
        public final Builder summary(SystemInstanceSummary summary) {
            this.summary = summary;
            return this;
        }

        public final void setSummary(SystemInstanceSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        public final DefinitionDocument.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        @Override
        public final Builder definition(DefinitionDocument definition) {
            this.definition = definition;
            return this;
        }

        public final void setDefinition(DefinitionDocument.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        public final MetricsConfiguration.Builder getMetricsConfiguration() {
            return this.metricsConfiguration != null ? this.metricsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder metricsConfiguration(MetricsConfiguration metricsConfiguration) {
            this.metricsConfiguration = metricsConfiguration;
            return this;
        }

        public final void setMetricsConfiguration(MetricsConfiguration.BuilderImpl metricsConfiguration) {
            this.metricsConfiguration = metricsConfiguration != null ? metricsConfiguration.build() : null;
        }

        public final Long getValidatedNamespaceVersion() {
            return this.validatedNamespaceVersion;
        }

        @Override
        public final Builder validatedNamespaceVersion(Long validatedNamespaceVersion) {
            this.validatedNamespaceVersion = validatedNamespaceVersion;
            return this;
        }

        public final void setValidatedNamespaceVersion(Long validatedNamespaceVersion) {
            this.validatedNamespaceVersion = validatedNamespaceVersion;
        }

        public final Collection<DependencyRevision.Builder> getValidatedDependencyRevisions() {
            if (this.validatedDependencyRevisions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.validatedDependencyRevisions != null ? (Collection)this.validatedDependencyRevisions.stream().map(DependencyRevision::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validatedDependencyRevisions(Collection<DependencyRevision> validatedDependencyRevisions) {
            this.validatedDependencyRevisions = DependencyRevisionsCopier.copy(validatedDependencyRevisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validatedDependencyRevisions(DependencyRevision ... validatedDependencyRevisions) {
            this.validatedDependencyRevisions(Arrays.asList(validatedDependencyRevisions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validatedDependencyRevisions(Consumer<DependencyRevision.Builder> ... validatedDependencyRevisions) {
            this.validatedDependencyRevisions(Stream.of(validatedDependencyRevisions).map(c -> (DependencyRevision)((DependencyRevision.Builder)DependencyRevision.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setValidatedDependencyRevisions(Collection<DependencyRevision.BuilderImpl> validatedDependencyRevisions) {
            this.validatedDependencyRevisions = DependencyRevisionsCopier.copyFromBuilder(validatedDependencyRevisions);
        }

        public final String getFlowActionsRoleArn() {
            return this.flowActionsRoleArn;
        }

        @Override
        public final Builder flowActionsRoleArn(String flowActionsRoleArn) {
            this.flowActionsRoleArn = flowActionsRoleArn;
            return this;
        }

        public final void setFlowActionsRoleArn(String flowActionsRoleArn) {
            this.flowActionsRoleArn = flowActionsRoleArn;
        }

        public SystemInstanceDescription build() {
            return new SystemInstanceDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SystemInstanceDescription> {
        public Builder summary(SystemInstanceSummary var1);

        default public Builder summary(Consumer<SystemInstanceSummary.Builder> summary) {
            return this.summary((SystemInstanceSummary)((SystemInstanceSummary.Builder)SystemInstanceSummary.builder().applyMutation(summary)).build());
        }

        public Builder definition(DefinitionDocument var1);

        default public Builder definition(Consumer<DefinitionDocument.Builder> definition) {
            return this.definition((DefinitionDocument)((DefinitionDocument.Builder)DefinitionDocument.builder().applyMutation(definition)).build());
        }

        public Builder s3BucketName(String var1);

        public Builder metricsConfiguration(MetricsConfiguration var1);

        default public Builder metricsConfiguration(Consumer<MetricsConfiguration.Builder> metricsConfiguration) {
            return this.metricsConfiguration((MetricsConfiguration)((MetricsConfiguration.Builder)MetricsConfiguration.builder().applyMutation(metricsConfiguration)).build());
        }

        public Builder validatedNamespaceVersion(Long var1);

        public Builder validatedDependencyRevisions(Collection<DependencyRevision> var1);

        public Builder validatedDependencyRevisions(DependencyRevision ... var1);

        public Builder validatedDependencyRevisions(Consumer<DependencyRevision.Builder> ... var1);

        public Builder flowActionsRoleArn(String var1);
    }
}

