/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UntagResourceRequest extends IoTThingsGraphRequest implements
        ToCopyableBuilder<UntagResourceRequest.Builder, UntagResourceRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UntagResourceRequest::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<List<String>> TAG_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UntagResourceRequest::tagKeys))
            .setter(setter(Builder::tagKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            TAG_KEYS_FIELD));

    private final String resourceArn;

    private final List<String> tagKeys;

    private UntagResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.tagKeys = builder.tagKeys;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource whose tags are to be removed.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource whose tags are to be removed.
     */
    public String resourceArn() {
        return resourceArn;
    }

    /**
     * Returns true if the TagKeys property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTagKeys() {
        return tagKeys != null && !(tagKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tag key names to remove from the resource. You don't specify the value. Both the key and its associated
     * value are removed.
     * </p>
     * <p>
     * This parameter to the API requires a JSON text string argument. For information on how to format a JSON parameter
     * for the various command line tool environments, see <a
     * href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html#cli-using-param-json">Using JSON
     * for Parameters</a> in the <i>AWS CLI User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagKeys()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of tag key names to remove from the resource. You don't specify the value. Both the key and its
     *         associated value are removed. </p>
     *         <p>
     *         This parameter to the API requires a JSON text string argument. For information on how to format a JSON
     *         parameter for the various command line tool environments, see <a
     *         href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html#cli-using-param-json"
     *         >Using JSON for Parameters</a> in the <i>AWS CLI User Guide</i>.
     */
    public List<String> tagKeys() {
        return tagKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(tagKeys());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UntagResourceRequest)) {
            return false;
        }
        UntagResourceRequest other = (UntagResourceRequest) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(tagKeys(), other.tagKeys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UntagResourceRequest").add("ResourceArn", resourceArn()).add("TagKeys", tagKeys()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "tagKeys":
            return Optional.ofNullable(clazz.cast(tagKeys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UntagResourceRequest, T> g) {
        return obj -> g.apply((UntagResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTThingsGraphRequest.Builder, SdkPojo, CopyableBuilder<Builder, UntagResourceRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource whose tags are to be removed.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the resource whose tags are to be removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * A list of tag key names to remove from the resource. You don't specify the value. Both the key and its
         * associated value are removed.
         * </p>
         * <p>
         * This parameter to the API requires a JSON text string argument. For information on how to format a JSON
         * parameter for the various command line tool environments, see <a
         * href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html#cli-using-param-json">Using
         * JSON for Parameters</a> in the <i>AWS CLI User Guide</i>.
         * </p>
         * 
         * @param tagKeys
         *        A list of tag key names to remove from the resource. You don't specify the value. Both the key and its
         *        associated value are removed. </p>
         *        <p>
         *        This parameter to the API requires a JSON text string argument. For information on how to format a
         *        JSON parameter for the various command line tool environments, see <a href=
         *        "https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html#cli-using-param-json"
         *        >Using JSON for Parameters</a> in the <i>AWS CLI User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeys(Collection<String> tagKeys);

        /**
         * <p>
         * A list of tag key names to remove from the resource. You don't specify the value. Both the key and its
         * associated value are removed.
         * </p>
         * <p>
         * This parameter to the API requires a JSON text string argument. For information on how to format a JSON
         * parameter for the various command line tool environments, see <a
         * href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html#cli-using-param-json">Using
         * JSON for Parameters</a> in the <i>AWS CLI User Guide</i>.
         * </p>
         * 
         * @param tagKeys
         *        A list of tag key names to remove from the resource. You don't specify the value. Both the key and its
         *        associated value are removed. </p>
         *        <p>
         *        This parameter to the API requires a JSON text string argument. For information on how to format a
         *        JSON parameter for the various command line tool environments, see <a href=
         *        "https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html#cli-using-param-json"
         *        >Using JSON for Parameters</a> in the <i>AWS CLI User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeys(String... tagKeys);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTThingsGraphRequest.BuilderImpl implements Builder {
        private String resourceArn;

        private List<String> tagKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UntagResourceRequest model) {
            super(model);
            resourceArn(model.resourceArn);
            tagKeys(model.tagKeys);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final Collection<String> getTagKeys() {
            return tagKeys;
        }

        @Override
        public final Builder tagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListCopier.copy(tagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeys(String... tagKeys) {
            tagKeys(Arrays.asList(tagKeys));
            return this;
        }

        public final void setTagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListCopier.copy(tagKeys);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UntagResourceRequest build() {
            return new UntagResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
