/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSystemTemplateResponse extends IoTThingsGraphResponse implements
        ToCopyableBuilder<GetSystemTemplateResponse.Builder, GetSystemTemplateResponse> {
    private static final SdkField<SystemTemplateDescription> DESCRIPTION_FIELD = SdkField
            .<SystemTemplateDescription> builder(MarshallingType.SDK_POJO).getter(getter(GetSystemTemplateResponse::description))
            .setter(setter(Builder::description)).constructor(SystemTemplateDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD));

    private final SystemTemplateDescription description;

    private GetSystemTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
    }

    /**
     * <p>
     * An object that contains summary data about the system.
     * </p>
     * 
     * @return An object that contains summary data about the system.
     */
    public SystemTemplateDescription description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSystemTemplateResponse)) {
            return false;
        }
        GetSystemTemplateResponse other = (GetSystemTemplateResponse) obj;
        return Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetSystemTemplateResponse").add("Description", description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSystemTemplateResponse, T> g) {
        return obj -> g.apply((GetSystemTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTThingsGraphResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSystemTemplateResponse> {
        /**
         * <p>
         * An object that contains summary data about the system.
         * </p>
         * 
         * @param description
         *        An object that contains summary data about the system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(SystemTemplateDescription description);

        /**
         * <p>
         * An object that contains summary data about the system.
         * </p>
         * This is a convenience that creates an instance of the {@link SystemTemplateDescription.Builder} avoiding the
         * need to create one manually via {@link SystemTemplateDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link SystemTemplateDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #description(SystemTemplateDescription)}.
         * 
         * @param description
         *        a consumer that will call methods on {@link SystemTemplateDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #description(SystemTemplateDescription)
         */
        default Builder description(Consumer<SystemTemplateDescription.Builder> description) {
            return description(SystemTemplateDescription.builder().applyMutation(description).build());
        }
    }

    static final class BuilderImpl extends IoTThingsGraphResponse.BuilderImpl implements Builder {
        private SystemTemplateDescription description;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSystemTemplateResponse model) {
            super(model);
            description(model.description);
        }

        public final SystemTemplateDescription.Builder getDescription() {
            return description != null ? description.toBuilder() : null;
        }

        @Override
        public final Builder description(SystemTemplateDescription description) {
            this.description = description;
            return this;
        }

        public final void setDescription(SystemTemplateDescription.BuilderImpl description) {
            this.description = description != null ? description.build() : null;
        }

        @Override
        public GetSystemTemplateResponse build() {
            return new GetSystemTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
