/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotthingsgraph.model.EntityFilter;
import software.amazon.awssdk.services.iotthingsgraph.model.EntityFiltersCopier;
import software.amazon.awssdk.services.iotthingsgraph.model.EntityType;
import software.amazon.awssdk.services.iotthingsgraph.model.EntityTypesCopier;
import software.amazon.awssdk.services.iotthingsgraph.model.IoTThingsGraphRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchEntitiesRequest
extends IoTThingsGraphRequest
implements ToCopyableBuilder<Builder, SearchEntitiesRequest> {
    private static final SdkField<List<String>> ENTITY_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SearchEntitiesRequest.getter(SearchEntitiesRequest::entityTypesAsStrings)).setter(SearchEntitiesRequest.setter(Builder::entityTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EntityFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SearchEntitiesRequest.getter(SearchEntitiesRequest::filters)).setter(SearchEntitiesRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntityFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SearchEntitiesRequest.getter(SearchEntitiesRequest::nextToken)).setter(SearchEntitiesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SearchEntitiesRequest.getter(SearchEntitiesRequest::maxResults)).setter(SearchEntitiesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<Long> NAMESPACE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(SearchEntitiesRequest.getter(SearchEntitiesRequest::namespaceVersion)).setter(SearchEntitiesRequest.setter(Builder::namespaceVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_TYPES_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, NAMESPACE_VERSION_FIELD));
    private final List<String> entityTypes;
    private final List<EntityFilter> filters;
    private final String nextToken;
    private final Integer maxResults;
    private final Long namespaceVersion;

    private SearchEntitiesRequest(BuilderImpl builder) {
        super(builder);
        this.entityTypes = builder.entityTypes;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.namespaceVersion = builder.namespaceVersion;
    }

    public List<EntityType> entityTypes() {
        return EntityTypesCopier.copyStringToEnum(this.entityTypes);
    }

    public boolean hasEntityTypes() {
        return this.entityTypes != null && !(this.entityTypes instanceof SdkAutoConstructList);
    }

    public List<String> entityTypesAsStrings() {
        return this.entityTypes;
    }

    public boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public List<EntityFilter> filters() {
        return this.filters;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Long namespaceVersion() {
        return this.namespaceVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.entityTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchEntitiesRequest)) {
            return false;
        }
        SearchEntitiesRequest other = (SearchEntitiesRequest)((Object)obj);
        return Objects.equals(this.entityTypesAsStrings(), other.entityTypesAsStrings()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.namespaceVersion(), other.namespaceVersion());
    }

    public String toString() {
        return ToString.builder((String)"SearchEntitiesRequest").add("EntityTypes", this.entityTypesAsStrings()).add("Filters", this.filters()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("NamespaceVersion", (Object)this.namespaceVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entityTypes": {
                return Optional.ofNullable(clazz.cast(this.entityTypesAsStrings()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "namespaceVersion": {
                return Optional.ofNullable(clazz.cast(this.namespaceVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchEntitiesRequest, T> g) {
        return obj -> g.apply((SearchEntitiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTThingsGraphRequest.BuilderImpl
    implements Builder {
        private List<String> entityTypes = DefaultSdkAutoConstructList.getInstance();
        private List<EntityFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;
        private Long namespaceVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchEntitiesRequest model) {
            super(model);
            this.entityTypesWithStrings(model.entityTypes);
            this.filters(model.filters);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.namespaceVersion(model.namespaceVersion);
        }

        public final Collection<String> getEntityTypesAsStrings() {
            return this.entityTypes;
        }

        @Override
        public final Builder entityTypesWithStrings(Collection<String> entityTypes) {
            this.entityTypes = EntityTypesCopier.copy(entityTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityTypesWithStrings(String ... entityTypes) {
            this.entityTypesWithStrings(Arrays.asList(entityTypes));
            return this;
        }

        @Override
        public final Builder entityTypes(Collection<EntityType> entityTypes) {
            this.entityTypes = EntityTypesCopier.copyEnumToString(entityTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityTypes(EntityType ... entityTypes) {
            this.entityTypes(Arrays.asList(entityTypes));
            return this;
        }

        public final void setEntityTypesWithStrings(Collection<String> entityTypes) {
            this.entityTypes = EntityTypesCopier.copy(entityTypes);
        }

        public final Collection<EntityFilter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(EntityFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<EntityFilter> filters) {
            this.filters = EntityFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(EntityFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<EntityFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (EntityFilter)((EntityFilter.Builder)EntityFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<EntityFilter.BuilderImpl> filters) {
            this.filters = EntityFiltersCopier.copyFromBuilder(filters);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Long getNamespaceVersion() {
            return this.namespaceVersion;
        }

        @Override
        public final Builder namespaceVersion(Long namespaceVersion) {
            this.namespaceVersion = namespaceVersion;
            return this;
        }

        public final void setNamespaceVersion(Long namespaceVersion) {
            this.namespaceVersion = namespaceVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchEntitiesRequest build() {
            return new SearchEntitiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTThingsGraphRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchEntitiesRequest> {
        public Builder entityTypesWithStrings(Collection<String> var1);

        public Builder entityTypesWithStrings(String ... var1);

        public Builder entityTypes(Collection<EntityType> var1);

        public Builder entityTypes(EntityType ... var1);

        public Builder filters(Collection<EntityFilter> var1);

        public Builder filters(EntityFilter ... var1);

        public Builder filters(Consumer<EntityFilter.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder namespaceVersion(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

