/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a tumbling window, which is a repeating fixed-sized, non-overlapping, and contiguous time window. You can
 * use this window in metrics to aggregate data from properties and other assets.
 * </p>
 * <p>
 * You can use <code>m</code>, <code>h</code>, <code>d</code>, and <code>w</code> when you specify an interval or
 * offset. Note that <code>m</code> represents minutes, <code>h</code> represents hours, <code>d</code> represents days,
 * and <code>w</code> represents weeks. You can also use <code>s</code> to represent seconds in <code>offset</code>.
 * </p>
 * <p>
 * The <code>interval</code> and <code>offset</code> parameters support the <a
 * href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601 format</a>. For example, <code>PT5S</code> represents 5
 * seconds, <code>PT5M</code> represents 5 minutes, and <code>PT5H</code> represents 5 hours.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TumblingWindow implements SdkPojo, Serializable, ToCopyableBuilder<TumblingWindow.Builder, TumblingWindow> {
    private static final SdkField<String> INTERVAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("interval").getter(getter(TumblingWindow::interval)).setter(setter(Builder::interval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interval").build()).build();

    private static final SdkField<String> OFFSET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("offset")
            .getter(getter(TumblingWindow::offset)).setter(setter(Builder::offset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offset").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERVAL_FIELD, OFFSET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String interval;

    private final String offset;

    private TumblingWindow(BuilderImpl builder) {
        this.interval = builder.interval;
        this.offset = builder.offset;
    }

    /**
     * <p>
     * The time interval for the tumbling window. The interval time must be between 1 minute and 1 week.
     * </p>
     * <p>
     * IoT SiteWise computes the <code>1w</code> interval the end of Sunday at midnight each week (UTC), the
     * <code>1d</code> interval at the end of each day at midnight (UTC), the <code>1h</code> interval at the end of
     * each hour, and so on.
     * </p>
     * <p>
     * When IoT SiteWise aggregates data points for metric computations, the start of each interval is exclusive and the
     * end of each interval is inclusive. IoT SiteWise places the computed data point at the end of the interval.
     * </p>
     * 
     * @return The time interval for the tumbling window. The interval time must be between 1 minute and 1 week.</p>
     *         <p>
     *         IoT SiteWise computes the <code>1w</code> interval the end of Sunday at midnight each week (UTC), the
     *         <code>1d</code> interval at the end of each day at midnight (UTC), the <code>1h</code> interval at the
     *         end of each hour, and so on.
     *         </p>
     *         <p>
     *         When IoT SiteWise aggregates data points for metric computations, the start of each interval is exclusive
     *         and the end of each interval is inclusive. IoT SiteWise places the computed data point at the end of the
     *         interval.
     */
    public final String interval() {
        return interval;
    }

    /**
     * <p>
     * The offset for the tumbling window. The <code>offset</code> parameter accepts the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The offset time.
     * </p>
     * <p>
     * For example, if you specify <code>18h</code> for <code>offset</code> and <code>1d</code> for
     * <code>interval</code>, IoT SiteWise aggregates data in one of the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you create the metric before or at 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) on the day
     * when you create the metric.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you create the metric after 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) the next day.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * The ISO 8601 format.
     * </p>
     * <p>
     * For example, if you specify <code>PT18H</code> for <code>offset</code> and <code>1d</code> for
     * <code>interval</code>, IoT SiteWise aggregates data in one of the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you create the metric before or at 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) on the day
     * when you create the metric.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you create the metric after 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) the next day.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * The 24-hour clock.
     * </p>
     * <p>
     * For example, if you specify <code>00:03:00</code> for <code>offset</code>, <code>5m</code> for
     * <code>interval</code>, and you create the metric at 2 PM (UTC), you get the first aggregation result at 2:03 PM
     * (UTC). You get the second aggregation result at 2:08 PM (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * The offset time zone.
     * </p>
     * <p>
     * For example, if you specify <code>2021-07-23T18:00-08</code> for <code>offset</code> and <code>1d</code> for
     * <code>interval</code>, IoT SiteWise aggregates data in one of the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you create the metric before or at 6 PM (PST), you get the first aggregation result at 6 PM (PST) on the day
     * when you create the metric.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you create the metric after 6 PM (PST), you get the first aggregation result at 6 PM (PST) the next day.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @return The offset for the tumbling window. The <code>offset</code> parameter accepts the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The offset time.
     *         </p>
     *         <p>
     *         For example, if you specify <code>18h</code> for <code>offset</code> and <code>1d</code> for
     *         <code>interval</code>, IoT SiteWise aggregates data in one of the following ways:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you create the metric before or at 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) on
     *         the day when you create the metric.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you create the metric after 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) the next
     *         day.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         The ISO 8601 format.
     *         </p>
     *         <p>
     *         For example, if you specify <code>PT18H</code> for <code>offset</code> and <code>1d</code> for
     *         <code>interval</code>, IoT SiteWise aggregates data in one of the following ways:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you create the metric before or at 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) on
     *         the day when you create the metric.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you create the metric after 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) the next
     *         day.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         The 24-hour clock.
     *         </p>
     *         <p>
     *         For example, if you specify <code>00:03:00</code> for <code>offset</code>, <code>5m</code> for
     *         <code>interval</code>, and you create the metric at 2 PM (UTC), you get the first aggregation result at
     *         2:03 PM (UTC). You get the second aggregation result at 2:08 PM (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The offset time zone.
     *         </p>
     *         <p>
     *         For example, if you specify <code>2021-07-23T18:00-08</code> for <code>offset</code> and <code>1d</code>
     *         for <code>interval</code>, IoT SiteWise aggregates data in one of the following ways:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you create the metric before or at 6 PM (PST), you get the first aggregation result at 6 PM (PST) on
     *         the day when you create the metric.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you create the metric after 6 PM (PST), you get the first aggregation result at 6 PM (PST) the next
     *         day.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final String offset() {
        return offset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(interval());
        hashCode = 31 * hashCode + Objects.hashCode(offset());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TumblingWindow)) {
            return false;
        }
        TumblingWindow other = (TumblingWindow) obj;
        return Objects.equals(interval(), other.interval()) && Objects.equals(offset(), other.offset());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TumblingWindow").add("Interval", interval()).add("Offset", offset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "interval":
            return Optional.ofNullable(clazz.cast(interval()));
        case "offset":
            return Optional.ofNullable(clazz.cast(offset()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("interval", INTERVAL_FIELD);
        map.put("offset", OFFSET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TumblingWindow, T> g) {
        return obj -> g.apply((TumblingWindow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TumblingWindow> {
        /**
         * <p>
         * The time interval for the tumbling window. The interval time must be between 1 minute and 1 week.
         * </p>
         * <p>
         * IoT SiteWise computes the <code>1w</code> interval the end of Sunday at midnight each week (UTC), the
         * <code>1d</code> interval at the end of each day at midnight (UTC), the <code>1h</code> interval at the end of
         * each hour, and so on.
         * </p>
         * <p>
         * When IoT SiteWise aggregates data points for metric computations, the start of each interval is exclusive and
         * the end of each interval is inclusive. IoT SiteWise places the computed data point at the end of the
         * interval.
         * </p>
         * 
         * @param interval
         *        The time interval for the tumbling window. The interval time must be between 1 minute and 1 week.</p>
         *        <p>
         *        IoT SiteWise computes the <code>1w</code> interval the end of Sunday at midnight each week (UTC), the
         *        <code>1d</code> interval at the end of each day at midnight (UTC), the <code>1h</code> interval at the
         *        end of each hour, and so on.
         *        </p>
         *        <p>
         *        When IoT SiteWise aggregates data points for metric computations, the start of each interval is
         *        exclusive and the end of each interval is inclusive. IoT SiteWise places the computed data point at
         *        the end of the interval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interval(String interval);

        /**
         * <p>
         * The offset for the tumbling window. The <code>offset</code> parameter accepts the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The offset time.
         * </p>
         * <p>
         * For example, if you specify <code>18h</code> for <code>offset</code> and <code>1d</code> for
         * <code>interval</code>, IoT SiteWise aggregates data in one of the following ways:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you create the metric before or at 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) on the
         * day when you create the metric.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you create the metric after 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) the next day.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * The ISO 8601 format.
         * </p>
         * <p>
         * For example, if you specify <code>PT18H</code> for <code>offset</code> and <code>1d</code> for
         * <code>interval</code>, IoT SiteWise aggregates data in one of the following ways:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you create the metric before or at 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) on the
         * day when you create the metric.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you create the metric after 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) the next day.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * The 24-hour clock.
         * </p>
         * <p>
         * For example, if you specify <code>00:03:00</code> for <code>offset</code>, <code>5m</code> for
         * <code>interval</code>, and you create the metric at 2 PM (UTC), you get the first aggregation result at 2:03
         * PM (UTC). You get the second aggregation result at 2:08 PM (UTC).
         * </p>
         * </li>
         * <li>
         * <p>
         * The offset time zone.
         * </p>
         * <p>
         * For example, if you specify <code>2021-07-23T18:00-08</code> for <code>offset</code> and <code>1d</code> for
         * <code>interval</code>, IoT SiteWise aggregates data in one of the following ways:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you create the metric before or at 6 PM (PST), you get the first aggregation result at 6 PM (PST) on the
         * day when you create the metric.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you create the metric after 6 PM (PST), you get the first aggregation result at 6 PM (PST) the next day.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param offset
         *        The offset for the tumbling window. The <code>offset</code> parameter accepts the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The offset time.
         *        </p>
         *        <p>
         *        For example, if you specify <code>18h</code> for <code>offset</code> and <code>1d</code> for
         *        <code>interval</code>, IoT SiteWise aggregates data in one of the following ways:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you create the metric before or at 6 PM (UTC), you get the first aggregation result at 6 PM (UTC)
         *        on the day when you create the metric.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you create the metric after 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) the next
         *        day.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        The ISO 8601 format.
         *        </p>
         *        <p>
         *        For example, if you specify <code>PT18H</code> for <code>offset</code> and <code>1d</code> for
         *        <code>interval</code>, IoT SiteWise aggregates data in one of the following ways:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you create the metric before or at 6 PM (UTC), you get the first aggregation result at 6 PM (UTC)
         *        on the day when you create the metric.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you create the metric after 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) the next
         *        day.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        The 24-hour clock.
         *        </p>
         *        <p>
         *        For example, if you specify <code>00:03:00</code> for <code>offset</code>, <code>5m</code> for
         *        <code>interval</code>, and you create the metric at 2 PM (UTC), you get the first aggregation result
         *        at 2:03 PM (UTC). You get the second aggregation result at 2:08 PM (UTC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The offset time zone.
         *        </p>
         *        <p>
         *        For example, if you specify <code>2021-07-23T18:00-08</code> for <code>offset</code> and
         *        <code>1d</code> for <code>interval</code>, IoT SiteWise aggregates data in one of the following ways:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you create the metric before or at 6 PM (PST), you get the first aggregation result at 6 PM (PST)
         *        on the day when you create the metric.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you create the metric after 6 PM (PST), you get the first aggregation result at 6 PM (PST) the next
         *        day.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offset(String offset);
    }

    static final class BuilderImpl implements Builder {
        private String interval;

        private String offset;

        private BuilderImpl() {
        }

        private BuilderImpl(TumblingWindow model) {
            interval(model.interval);
            offset(model.offset);
        }

        public final String getInterval() {
            return interval;
        }

        public final void setInterval(String interval) {
            this.interval = interval;
        }

        @Override
        public final Builder interval(String interval) {
            this.interval = interval;
            return this;
        }

        public final String getOffset() {
            return offset;
        }

        public final void setOffset(String offset) {
            this.offset = offset;
        }

        @Override
        public final Builder offset(String offset) {
            this.offset = offset;
            return this;
        }

        @Override
        public TumblingWindow build() {
            return new TumblingWindow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
