/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAssetModelInterfaceRelationshipRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<PutAssetModelInterfaceRelationshipRequest.Builder, PutAssetModelInterfaceRelationshipRequest> {
    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelId").getter(getter(PutAssetModelInterfaceRelationshipRequest::assetModelId))
            .setter(setter(Builder::assetModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assetModelId").build()).build();

    private static final SdkField<String> INTERFACE_ASSET_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("interfaceAssetModelId").getter(getter(PutAssetModelInterfaceRelationshipRequest::interfaceAssetModelId))
            .setter(setter(Builder::interfaceAssetModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("interfaceAssetModelId").build())
            .build();

    private static final SdkField<PropertyMappingConfiguration> PROPERTY_MAPPING_CONFIGURATION_FIELD = SdkField
            .<PropertyMappingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("propertyMappingConfiguration")
            .getter(getter(PutAssetModelInterfaceRelationshipRequest::propertyMappingConfiguration))
            .setter(setter(Builder::propertyMappingConfiguration))
            .constructor(PropertyMappingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyMappingConfiguration")
                    .build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(PutAssetModelInterfaceRelationshipRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_ID_FIELD,
            INTERFACE_ASSET_MODEL_ID_FIELD, PROPERTY_MAPPING_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String assetModelId;

    private final String interfaceAssetModelId;

    private final PropertyMappingConfiguration propertyMappingConfiguration;

    private final String clientToken;

    private PutAssetModelInterfaceRelationshipRequest(BuilderImpl builder) {
        super(builder);
        this.assetModelId = builder.assetModelId;
        this.interfaceAssetModelId = builder.interfaceAssetModelId;
        this.propertyMappingConfiguration = builder.propertyMappingConfiguration;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the asset model. This can be either the actual ID in UUID format, or else externalId: followed by the
     * external ID.
     * </p>
     * 
     * @return The ID of the asset model. This can be either the actual ID in UUID format, or else externalId: followed
     *         by the external ID.
     */
    public final String assetModelId() {
        return assetModelId;
    }

    /**
     * <p>
     * The ID of the interface asset model. This can be either the actual ID in UUID format, or else externalId:
     * followed by the external ID.
     * </p>
     * 
     * @return The ID of the interface asset model. This can be either the actual ID in UUID format, or else externalId:
     *         followed by the external ID.
     */
    public final String interfaceAssetModelId() {
        return interfaceAssetModelId;
    }

    /**
     * <p>
     * The configuration for mapping properties from the interface asset model to the asset model where the interface is
     * applied. This configuration controls how properties are matched and created during the interface application
     * process.
     * </p>
     * 
     * @return The configuration for mapping properties from the interface asset model to the asset model where the
     *         interface is applied. This configuration controls how properties are matched and created during the
     *         interface application process.
     */
    public final PropertyMappingConfiguration propertyMappingConfiguration() {
        return propertyMappingConfiguration;
    }

    /**
     * <p>
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
     * this client token if a new idempotent request is required.
     * </p>
     * 
     * @return A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't
     *         reuse this client token if a new idempotent request is required.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(interfaceAssetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(propertyMappingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAssetModelInterfaceRelationshipRequest)) {
            return false;
        }
        PutAssetModelInterfaceRelationshipRequest other = (PutAssetModelInterfaceRelationshipRequest) obj;
        return Objects.equals(assetModelId(), other.assetModelId())
                && Objects.equals(interfaceAssetModelId(), other.interfaceAssetModelId())
                && Objects.equals(propertyMappingConfiguration(), other.propertyMappingConfiguration())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutAssetModelInterfaceRelationshipRequest").add("AssetModelId", assetModelId())
                .add("InterfaceAssetModelId", interfaceAssetModelId())
                .add("PropertyMappingConfiguration", propertyMappingConfiguration()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetModelId":
            return Optional.ofNullable(clazz.cast(assetModelId()));
        case "interfaceAssetModelId":
            return Optional.ofNullable(clazz.cast(interfaceAssetModelId()));
        case "propertyMappingConfiguration":
            return Optional.ofNullable(clazz.cast(propertyMappingConfiguration()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assetModelId", ASSET_MODEL_ID_FIELD);
        map.put("interfaceAssetModelId", INTERFACE_ASSET_MODEL_ID_FIELD);
        map.put("propertyMappingConfiguration", PROPERTY_MAPPING_CONFIGURATION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutAssetModelInterfaceRelationshipRequest, T> g) {
        return obj -> g.apply((PutAssetModelInterfaceRelationshipRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutAssetModelInterfaceRelationshipRequest> {
        /**
         * <p>
         * The ID of the asset model. This can be either the actual ID in UUID format, or else externalId: followed by
         * the external ID.
         * </p>
         * 
         * @param assetModelId
         *        The ID of the asset model. This can be either the actual ID in UUID format, or else externalId:
         *        followed by the external ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelId(String assetModelId);

        /**
         * <p>
         * The ID of the interface asset model. This can be either the actual ID in UUID format, or else externalId:
         * followed by the external ID.
         * </p>
         * 
         * @param interfaceAssetModelId
         *        The ID of the interface asset model. This can be either the actual ID in UUID format, or else
         *        externalId: followed by the external ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceAssetModelId(String interfaceAssetModelId);

        /**
         * <p>
         * The configuration for mapping properties from the interface asset model to the asset model where the
         * interface is applied. This configuration controls how properties are matched and created during the interface
         * application process.
         * </p>
         * 
         * @param propertyMappingConfiguration
         *        The configuration for mapping properties from the interface asset model to the asset model where the
         *        interface is applied. This configuration controls how properties are matched and created during the
         *        interface application process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyMappingConfiguration(PropertyMappingConfiguration propertyMappingConfiguration);

        /**
         * <p>
         * The configuration for mapping properties from the interface asset model to the asset model where the
         * interface is applied. This configuration controls how properties are matched and created during the interface
         * application process.
         * </p>
         * This is a convenience method that creates an instance of the {@link PropertyMappingConfiguration.Builder}
         * avoiding the need to create one manually via {@link PropertyMappingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PropertyMappingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #propertyMappingConfiguration(PropertyMappingConfiguration)}.
         * 
         * @param propertyMappingConfiguration
         *        a consumer that will call methods on {@link PropertyMappingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #propertyMappingConfiguration(PropertyMappingConfiguration)
         */
        default Builder propertyMappingConfiguration(Consumer<PropertyMappingConfiguration.Builder> propertyMappingConfiguration) {
            return propertyMappingConfiguration(PropertyMappingConfiguration.builder()
                    .applyMutation(propertyMappingConfiguration).build());
        }

        /**
         * <p>
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
         * this client token if a new idempotent request is required.
         * </p>
         * 
         * @param clientToken
         *        A unique case-sensitive identifier that you can provide to ensure the idempotency of the request.
         *        Don't reuse this client token if a new idempotent request is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String assetModelId;

        private String interfaceAssetModelId;

        private PropertyMappingConfiguration propertyMappingConfiguration;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAssetModelInterfaceRelationshipRequest model) {
            super(model);
            assetModelId(model.assetModelId);
            interfaceAssetModelId(model.interfaceAssetModelId);
            propertyMappingConfiguration(model.propertyMappingConfiguration);
            clientToken(model.clientToken);
        }

        public final String getAssetModelId() {
            return assetModelId;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final String getInterfaceAssetModelId() {
            return interfaceAssetModelId;
        }

        public final void setInterfaceAssetModelId(String interfaceAssetModelId) {
            this.interfaceAssetModelId = interfaceAssetModelId;
        }

        @Override
        public final Builder interfaceAssetModelId(String interfaceAssetModelId) {
            this.interfaceAssetModelId = interfaceAssetModelId;
            return this;
        }

        public final PropertyMappingConfiguration.Builder getPropertyMappingConfiguration() {
            return propertyMappingConfiguration != null ? propertyMappingConfiguration.toBuilder() : null;
        }

        public final void setPropertyMappingConfiguration(PropertyMappingConfiguration.BuilderImpl propertyMappingConfiguration) {
            this.propertyMappingConfiguration = propertyMappingConfiguration != null ? propertyMappingConfiguration.build()
                    : null;
        }

        @Override
        public final Builder propertyMappingConfiguration(PropertyMappingConfiguration propertyMappingConfiguration) {
            this.propertyMappingConfiguration = propertyMappingConfiguration;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAssetModelInterfaceRelationshipRequest build() {
            return new PutAssetModelInterfaceRelationshipRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
