/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a property type, which can be one of <code>attribute</code>, <code>measurement</code>, <code>metric</code>,
 * or <code>transform</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PropertyType implements SdkPojo, Serializable, ToCopyableBuilder<PropertyType.Builder, PropertyType> {
    private static final SdkField<Attribute> ATTRIBUTE_FIELD = SdkField.<Attribute> builder(MarshallingType.SDK_POJO)
            .memberName("attribute").getter(getter(PropertyType::attribute)).setter(setter(Builder::attribute))
            .constructor(Attribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attribute").build()).build();

    private static final SdkField<Measurement> MEASUREMENT_FIELD = SdkField.<Measurement> builder(MarshallingType.SDK_POJO)
            .memberName("measurement").getter(getter(PropertyType::measurement)).setter(setter(Builder::measurement))
            .constructor(Measurement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("measurement").build()).build();

    private static final SdkField<Transform> TRANSFORM_FIELD = SdkField.<Transform> builder(MarshallingType.SDK_POJO)
            .memberName("transform").getter(getter(PropertyType::transform)).setter(setter(Builder::transform))
            .constructor(Transform::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transform").build()).build();

    private static final SdkField<Metric> METRIC_FIELD = SdkField.<Metric> builder(MarshallingType.SDK_POJO).memberName("metric")
            .getter(getter(PropertyType::metric)).setter(setter(Builder::metric)).constructor(Metric::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metric").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD,
            MEASUREMENT_FIELD, TRANSFORM_FIELD, METRIC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Attribute attribute;

    private final Measurement measurement;

    private final Transform transform;

    private final Metric metric;

    private PropertyType(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.measurement = builder.measurement;
        this.transform = builder.transform;
        this.metric = builder.metric;
    }

    /**
     * <p>
     * Specifies an asset attribute property. An attribute generally contains static information, such as the serial
     * number of an <a href="https://en.wikipedia.org/wiki/Internet_of_things#Industrial_applications">IIoT</a> wind
     * turbine.
     * </p>
     * 
     * @return Specifies an asset attribute property. An attribute generally contains static information, such as the
     *         serial number of an <a
     *         href="https://en.wikipedia.org/wiki/Internet_of_things#Industrial_applications">IIoT</a> wind turbine.
     */
    public final Attribute attribute() {
        return attribute;
    }

    /**
     * <p>
     * Specifies an asset measurement property. A measurement represents a device's raw sensor data stream, such as
     * timestamped temperature values or timestamped power values.
     * </p>
     * 
     * @return Specifies an asset measurement property. A measurement represents a device's raw sensor data stream, such
     *         as timestamped temperature values or timestamped power values.
     */
    public final Measurement measurement() {
        return measurement;
    }

    /**
     * <p>
     * Specifies an asset transform property. A transform contains a mathematical expression that maps a property's data
     * points from one form to another, such as a unit conversion from Celsius to Fahrenheit.
     * </p>
     * 
     * @return Specifies an asset transform property. A transform contains a mathematical expression that maps a
     *         property's data points from one form to another, such as a unit conversion from Celsius to Fahrenheit.
     */
    public final Transform transform() {
        return transform;
    }

    /**
     * <p>
     * Specifies an asset metric property. A metric contains a mathematical expression that uses aggregate functions to
     * process all input data points over a time interval and output a single data point, such as to calculate the
     * average hourly temperature.
     * </p>
     * 
     * @return Specifies an asset metric property. A metric contains a mathematical expression that uses aggregate
     *         functions to process all input data points over a time interval and output a single data point, such as
     *         to calculate the average hourly temperature.
     */
    public final Metric metric() {
        return metric;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attribute());
        hashCode = 31 * hashCode + Objects.hashCode(measurement());
        hashCode = 31 * hashCode + Objects.hashCode(transform());
        hashCode = 31 * hashCode + Objects.hashCode(metric());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyType)) {
            return false;
        }
        PropertyType other = (PropertyType) obj;
        return Objects.equals(attribute(), other.attribute()) && Objects.equals(measurement(), other.measurement())
                && Objects.equals(transform(), other.transform()) && Objects.equals(metric(), other.metric());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PropertyType").add("Attribute", attribute()).add("Measurement", measurement())
                .add("Transform", transform()).add("Metric", metric()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attribute":
            return Optional.ofNullable(clazz.cast(attribute()));
        case "measurement":
            return Optional.ofNullable(clazz.cast(measurement()));
        case "transform":
            return Optional.ofNullable(clazz.cast(transform()));
        case "metric":
            return Optional.ofNullable(clazz.cast(metric()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("attribute", ATTRIBUTE_FIELD);
        map.put("measurement", MEASUREMENT_FIELD);
        map.put("transform", TRANSFORM_FIELD);
        map.put("metric", METRIC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PropertyType, T> g) {
        return obj -> g.apply((PropertyType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PropertyType> {
        /**
         * <p>
         * Specifies an asset attribute property. An attribute generally contains static information, such as the serial
         * number of an <a href="https://en.wikipedia.org/wiki/Internet_of_things#Industrial_applications">IIoT</a> wind
         * turbine.
         * </p>
         * 
         * @param attribute
         *        Specifies an asset attribute property. An attribute generally contains static information, such as the
         *        serial number of an <a
         *        href="https://en.wikipedia.org/wiki/Internet_of_things#Industrial_applications">IIoT</a> wind turbine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attribute(Attribute attribute);

        /**
         * <p>
         * Specifies an asset attribute property. An attribute generally contains static information, such as the serial
         * number of an <a href="https://en.wikipedia.org/wiki/Internet_of_things#Industrial_applications">IIoT</a> wind
         * turbine.
         * </p>
         * This is a convenience method that creates an instance of the {@link Attribute.Builder} avoiding the need to
         * create one manually via {@link Attribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Attribute.Builder#build()} is called immediately and its result
         * is passed to {@link #attribute(Attribute)}.
         * 
         * @param attribute
         *        a consumer that will call methods on {@link Attribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attribute(Attribute)
         */
        default Builder attribute(Consumer<Attribute.Builder> attribute) {
            return attribute(Attribute.builder().applyMutation(attribute).build());
        }

        /**
         * <p>
         * Specifies an asset measurement property. A measurement represents a device's raw sensor data stream, such as
         * timestamped temperature values or timestamped power values.
         * </p>
         * 
         * @param measurement
         *        Specifies an asset measurement property. A measurement represents a device's raw sensor data stream,
         *        such as timestamped temperature values or timestamped power values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder measurement(Measurement measurement);

        /**
         * <p>
         * Specifies an asset measurement property. A measurement represents a device's raw sensor data stream, such as
         * timestamped temperature values or timestamped power values.
         * </p>
         * This is a convenience method that creates an instance of the {@link Measurement.Builder} avoiding the need to
         * create one manually via {@link Measurement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Measurement.Builder#build()} is called immediately and its result
         * is passed to {@link #measurement(Measurement)}.
         * 
         * @param measurement
         *        a consumer that will call methods on {@link Measurement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #measurement(Measurement)
         */
        default Builder measurement(Consumer<Measurement.Builder> measurement) {
            return measurement(Measurement.builder().applyMutation(measurement).build());
        }

        /**
         * <p>
         * Specifies an asset transform property. A transform contains a mathematical expression that maps a property's
         * data points from one form to another, such as a unit conversion from Celsius to Fahrenheit.
         * </p>
         * 
         * @param transform
         *        Specifies an asset transform property. A transform contains a mathematical expression that maps a
         *        property's data points from one form to another, such as a unit conversion from Celsius to Fahrenheit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transform(Transform transform);

        /**
         * <p>
         * Specifies an asset transform property. A transform contains a mathematical expression that maps a property's
         * data points from one form to another, such as a unit conversion from Celsius to Fahrenheit.
         * </p>
         * This is a convenience method that creates an instance of the {@link Transform.Builder} avoiding the need to
         * create one manually via {@link Transform#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Transform.Builder#build()} is called immediately and its result
         * is passed to {@link #transform(Transform)}.
         * 
         * @param transform
         *        a consumer that will call methods on {@link Transform.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transform(Transform)
         */
        default Builder transform(Consumer<Transform.Builder> transform) {
            return transform(Transform.builder().applyMutation(transform).build());
        }

        /**
         * <p>
         * Specifies an asset metric property. A metric contains a mathematical expression that uses aggregate functions
         * to process all input data points over a time interval and output a single data point, such as to calculate
         * the average hourly temperature.
         * </p>
         * 
         * @param metric
         *        Specifies an asset metric property. A metric contains a mathematical expression that uses aggregate
         *        functions to process all input data points over a time interval and output a single data point, such
         *        as to calculate the average hourly temperature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metric(Metric metric);

        /**
         * <p>
         * Specifies an asset metric property. A metric contains a mathematical expression that uses aggregate functions
         * to process all input data points over a time interval and output a single data point, such as to calculate
         * the average hourly temperature.
         * </p>
         * This is a convenience method that creates an instance of the {@link Metric.Builder} avoiding the need to
         * create one manually via {@link Metric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Metric.Builder#build()} is called immediately and its result is
         * passed to {@link #metric(Metric)}.
         * 
         * @param metric
         *        a consumer that will call methods on {@link Metric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metric(Metric)
         */
        default Builder metric(Consumer<Metric.Builder> metric) {
            return metric(Metric.builder().applyMutation(metric).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Attribute attribute;

        private Measurement measurement;

        private Transform transform;

        private Metric metric;

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyType model) {
            attribute(model.attribute);
            measurement(model.measurement);
            transform(model.transform);
            metric(model.metric);
        }

        public final Attribute.Builder getAttribute() {
            return attribute != null ? attribute.toBuilder() : null;
        }

        public final void setAttribute(Attribute.BuilderImpl attribute) {
            this.attribute = attribute != null ? attribute.build() : null;
        }

        @Override
        public final Builder attribute(Attribute attribute) {
            this.attribute = attribute;
            return this;
        }

        public final Measurement.Builder getMeasurement() {
            return measurement != null ? measurement.toBuilder() : null;
        }

        public final void setMeasurement(Measurement.BuilderImpl measurement) {
            this.measurement = measurement != null ? measurement.build() : null;
        }

        @Override
        public final Builder measurement(Measurement measurement) {
            this.measurement = measurement;
            return this;
        }

        public final Transform.Builder getTransform() {
            return transform != null ? transform.toBuilder() : null;
        }

        public final void setTransform(Transform.BuilderImpl transform) {
            this.transform = transform != null ? transform.build() : null;
        }

        @Override
        public final Builder transform(Transform transform) {
            this.transform = transform;
            return this;
        }

        public final Metric.Builder getMetric() {
            return metric != null ? metric.toBuilder() : null;
        }

        public final void setMetric(Metric.BuilderImpl metric) {
            this.metric = metric != null ? metric.build() : null;
        }

        @Override
        public final Builder metric(Metric metric) {
            this.metric = metric;
            return this;
        }

        @Override
        public PropertyType build() {
            return new PropertyType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
