/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration entry associated with the specific portal type. The <code>portalTypeConfiguration</code> is a map
 * of the <code>portalTypeKey</code> to the <code>PortalTypeEntry</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PortalTypeEntry implements SdkPojo, Serializable, ToCopyableBuilder<PortalTypeEntry.Builder, PortalTypeEntry> {
    private static final SdkField<List<String>> PORTAL_TOOLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("portalTools")
            .getter(getter(PortalTypeEntry::portalTools))
            .setter(setter(Builder::portalTools))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalTools").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTAL_TOOLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> portalTools;

    private PortalTypeEntry(BuilderImpl builder) {
        this.portalTools = builder.portalTools;
    }

    /**
     * For responses, this returns true if the service returned a value for the PortalTools property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPortalTools() {
        return portalTools != null && !(portalTools instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of tools associated with the specified portal type. The possible values are <code>ASSISTANT</code> and
     * <code>DASHBOARD</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPortalTools} method.
     * </p>
     * 
     * @return The array of tools associated with the specified portal type. The possible values are
     *         <code>ASSISTANT</code> and <code>DASHBOARD</code>.
     */
    public final List<String> portalTools() {
        return portalTools;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPortalTools() ? portalTools() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortalTypeEntry)) {
            return false;
        }
        PortalTypeEntry other = (PortalTypeEntry) obj;
        return hasPortalTools() == other.hasPortalTools() && Objects.equals(portalTools(), other.portalTools());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PortalTypeEntry").add("PortalTools", hasPortalTools() ? portalTools() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "portalTools":
            return Optional.ofNullable(clazz.cast(portalTools()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("portalTools", PORTAL_TOOLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PortalTypeEntry, T> g) {
        return obj -> g.apply((PortalTypeEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PortalTypeEntry> {
        /**
         * <p>
         * The array of tools associated with the specified portal type. The possible values are <code>ASSISTANT</code>
         * and <code>DASHBOARD</code>.
         * </p>
         * 
         * @param portalTools
         *        The array of tools associated with the specified portal type. The possible values are
         *        <code>ASSISTANT</code> and <code>DASHBOARD</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalTools(Collection<String> portalTools);

        /**
         * <p>
         * The array of tools associated with the specified portal type. The possible values are <code>ASSISTANT</code>
         * and <code>DASHBOARD</code>.
         * </p>
         * 
         * @param portalTools
         *        The array of tools associated with the specified portal type. The possible values are
         *        <code>ASSISTANT</code> and <code>DASHBOARD</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalTools(String... portalTools);
    }

    static final class BuilderImpl implements Builder {
        private List<String> portalTools = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PortalTypeEntry model) {
            portalTools(model.portalTools);
        }

        public final Collection<String> getPortalTools() {
            if (portalTools instanceof SdkAutoConstructList) {
                return null;
            }
            return portalTools;
        }

        public final void setPortalTools(Collection<String> portalTools) {
            this.portalTools = PortalToolsCopier.copy(portalTools);
        }

        @Override
        public final Builder portalTools(Collection<String> portalTools) {
            this.portalTools = PortalToolsCopier.copy(portalTools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portalTools(String... portalTools) {
            portalTools(Arrays.asList(portalTools));
            return this;
        }

        @Override
        public PortalTypeEntry build() {
            return new PortalTypeEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
