/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a data binding that matches the specified filter criteria.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MatchedDataBinding implements SdkPojo, Serializable,
        ToCopyableBuilder<MatchedDataBinding.Builder, MatchedDataBinding> {
    private static final SdkField<DataBindingValue> VALUE_FIELD = SdkField.<DataBindingValue> builder(MarshallingType.SDK_POJO)
            .memberName("value").getter(getter(MatchedDataBinding::value)).setter(setter(Builder::value))
            .constructor(DataBindingValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DataBindingValue value;

    private MatchedDataBinding(BuilderImpl builder) {
        this.value = builder.value;
    }

    /**
     * <p>
     * The value of the matched data binding.
     * </p>
     * 
     * @return The value of the matched data binding.
     */
    public final DataBindingValue value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchedDataBinding)) {
            return false;
        }
        MatchedDataBinding other = (MatchedDataBinding) obj;
        return Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MatchedDataBinding").add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MatchedDataBinding, T> g) {
        return obj -> g.apply((MatchedDataBinding) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MatchedDataBinding> {
        /**
         * <p>
         * The value of the matched data binding.
         * </p>
         * 
         * @param value
         *        The value of the matched data binding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(DataBindingValue value);

        /**
         * <p>
         * The value of the matched data binding.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataBindingValue.Builder} avoiding the
         * need to create one manually via {@link DataBindingValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataBindingValue.Builder#build()} is called immediately and its
         * result is passed to {@link #value(DataBindingValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link DataBindingValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(DataBindingValue)
         */
        default Builder value(Consumer<DataBindingValue.Builder> value) {
            return value(DataBindingValue.builder().applyMutation(value).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DataBindingValue value;

        private BuilderImpl() {
        }

        private BuilderImpl(MatchedDataBinding model) {
            value(model.value);
        }

        public final DataBindingValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(DataBindingValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(DataBindingValue value) {
            this.value = value;
            return this;
        }

        @Override
        public MatchedDataBinding build() {
            return new MatchedDataBinding(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
