/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListComputationModelDataBindingUsagesResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<ListComputationModelDataBindingUsagesResponse.Builder, ListComputationModelDataBindingUsagesResponse> {
    private static final SdkField<List<ComputationModelDataBindingUsageSummary>> DATA_BINDING_USAGE_SUMMARIES_FIELD = SdkField
            .<List<ComputationModelDataBindingUsageSummary>> builder(MarshallingType.LIST)
            .memberName("dataBindingUsageSummaries")
            .getter(getter(ListComputationModelDataBindingUsagesResponse::dataBindingUsageSummaries))
            .setter(setter(Builder::dataBindingUsageSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataBindingUsageSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComputationModelDataBindingUsageSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComputationModelDataBindingUsageSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListComputationModelDataBindingUsagesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATA_BINDING_USAGE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ComputationModelDataBindingUsageSummary> dataBindingUsageSummaries;

    private final String nextToken;

    private ListComputationModelDataBindingUsagesResponse(BuilderImpl builder) {
        super(builder);
        this.dataBindingUsageSummaries = builder.dataBindingUsageSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataBindingUsageSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDataBindingUsageSummaries() {
        return dataBindingUsageSummaries != null && !(dataBindingUsageSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of summaries describing the data binding usages across computation models. Each summary includes the
     * computation model IDs and the matched data binding details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataBindingUsageSummaries} method.
     * </p>
     * 
     * @return A list of summaries describing the data binding usages across computation models. Each summary includes
     *         the computation model IDs and the matched data binding details.
     */
    public final List<ComputationModelDataBindingUsageSummary> dataBindingUsageSummaries() {
        return dataBindingUsageSummaries;
    }

    /**
     * <p>
     * The token for the next set of paginated results, or null if there are no additional results.
     * </p>
     * 
     * @return The token for the next set of paginated results, or null if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDataBindingUsageSummaries() ? dataBindingUsageSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComputationModelDataBindingUsagesResponse)) {
            return false;
        }
        ListComputationModelDataBindingUsagesResponse other = (ListComputationModelDataBindingUsagesResponse) obj;
        return hasDataBindingUsageSummaries() == other.hasDataBindingUsageSummaries()
                && Objects.equals(dataBindingUsageSummaries(), other.dataBindingUsageSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListComputationModelDataBindingUsagesResponse")
                .add("DataBindingUsageSummaries", hasDataBindingUsageSummaries() ? dataBindingUsageSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataBindingUsageSummaries":
            return Optional.ofNullable(clazz.cast(dataBindingUsageSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dataBindingUsageSummaries", DATA_BINDING_USAGE_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListComputationModelDataBindingUsagesResponse, T> g) {
        return obj -> g.apply((ListComputationModelDataBindingUsagesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListComputationModelDataBindingUsagesResponse> {
        /**
         * <p>
         * A list of summaries describing the data binding usages across computation models. Each summary includes the
         * computation model IDs and the matched data binding details.
         * </p>
         * 
         * @param dataBindingUsageSummaries
         *        A list of summaries describing the data binding usages across computation models. Each summary
         *        includes the computation model IDs and the matched data binding details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataBindingUsageSummaries(Collection<ComputationModelDataBindingUsageSummary> dataBindingUsageSummaries);

        /**
         * <p>
         * A list of summaries describing the data binding usages across computation models. Each summary includes the
         * computation model IDs and the matched data binding details.
         * </p>
         * 
         * @param dataBindingUsageSummaries
         *        A list of summaries describing the data binding usages across computation models. Each summary
         *        includes the computation model IDs and the matched data binding details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataBindingUsageSummaries(ComputationModelDataBindingUsageSummary... dataBindingUsageSummaries);

        /**
         * <p>
         * A list of summaries describing the data binding usages across computation models. Each summary includes the
         * computation model IDs and the matched data binding details.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.ComputationModelDataBindingUsageSummary.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.ComputationModelDataBindingUsageSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.ComputationModelDataBindingUsageSummary.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #dataBindingUsageSummaries(List<ComputationModelDataBindingUsageSummary>)}.
         * 
         * @param dataBindingUsageSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.ComputationModelDataBindingUsageSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataBindingUsageSummaries(java.util.Collection<ComputationModelDataBindingUsageSummary>)
         */
        Builder dataBindingUsageSummaries(Consumer<ComputationModelDataBindingUsageSummary.Builder>... dataBindingUsageSummaries);

        /**
         * <p>
         * The token for the next set of paginated results, or null if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of paginated results, or null if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private List<ComputationModelDataBindingUsageSummary> dataBindingUsageSummaries = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComputationModelDataBindingUsagesResponse model) {
            super(model);
            dataBindingUsageSummaries(model.dataBindingUsageSummaries);
            nextToken(model.nextToken);
        }

        public final List<ComputationModelDataBindingUsageSummary.Builder> getDataBindingUsageSummaries() {
            List<ComputationModelDataBindingUsageSummary.Builder> result = ComputationModelDataBindingUsageSummariesCopier
                    .copyToBuilder(this.dataBindingUsageSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataBindingUsageSummaries(
                Collection<ComputationModelDataBindingUsageSummary.BuilderImpl> dataBindingUsageSummaries) {
            this.dataBindingUsageSummaries = ComputationModelDataBindingUsageSummariesCopier
                    .copyFromBuilder(dataBindingUsageSummaries);
        }

        @Override
        public final Builder dataBindingUsageSummaries(
                Collection<ComputationModelDataBindingUsageSummary> dataBindingUsageSummaries) {
            this.dataBindingUsageSummaries = ComputationModelDataBindingUsageSummariesCopier.copy(dataBindingUsageSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataBindingUsageSummaries(ComputationModelDataBindingUsageSummary... dataBindingUsageSummaries) {
            dataBindingUsageSummaries(Arrays.asList(dataBindingUsageSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataBindingUsageSummaries(
                Consumer<ComputationModelDataBindingUsageSummary.Builder>... dataBindingUsageSummaries) {
            dataBindingUsageSummaries(Stream.of(dataBindingUsageSummaries)
                    .map(c -> ComputationModelDataBindingUsageSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListComputationModelDataBindingUsagesResponse build() {
            return new ListComputationModelDataBindingUsagesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
