/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Maps a hierarchy from an interface asset model to a hierarchy in the asset model where the interface is applied.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HierarchyMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<HierarchyMapping.Builder, HierarchyMapping> {
    private static final SdkField<String> ASSET_MODEL_HIERARCHY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelHierarchyId").getter(getter(HierarchyMapping::assetModelHierarchyId))
            .setter(setter(Builder::assetModelHierarchyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelHierarchyId").build())
            .build();

    private static final SdkField<String> INTERFACE_ASSET_MODEL_HIERARCHY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("interfaceAssetModelHierarchyId")
            .getter(getter(HierarchyMapping::interfaceAssetModelHierarchyId))
            .setter(setter(Builder::interfaceAssetModelHierarchyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interfaceAssetModelHierarchyId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ASSET_MODEL_HIERARCHY_ID_FIELD, INTERFACE_ASSET_MODEL_HIERARCHY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String assetModelHierarchyId;

    private final String interfaceAssetModelHierarchyId;

    private HierarchyMapping(BuilderImpl builder) {
        this.assetModelHierarchyId = builder.assetModelHierarchyId;
        this.interfaceAssetModelHierarchyId = builder.interfaceAssetModelHierarchyId;
    }

    /**
     * <p>
     * The ID of the hierarchy in the asset model where the interface is applied.
     * </p>
     * 
     * @return The ID of the hierarchy in the asset model where the interface is applied.
     */
    public final String assetModelHierarchyId() {
        return assetModelHierarchyId;
    }

    /**
     * <p>
     * The ID of the hierarchy in the interface asset model.
     * </p>
     * 
     * @return The ID of the hierarchy in the interface asset model.
     */
    public final String interfaceAssetModelHierarchyId() {
        return interfaceAssetModelHierarchyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assetModelHierarchyId());
        hashCode = 31 * hashCode + Objects.hashCode(interfaceAssetModelHierarchyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HierarchyMapping)) {
            return false;
        }
        HierarchyMapping other = (HierarchyMapping) obj;
        return Objects.equals(assetModelHierarchyId(), other.assetModelHierarchyId())
                && Objects.equals(interfaceAssetModelHierarchyId(), other.interfaceAssetModelHierarchyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HierarchyMapping").add("AssetModelHierarchyId", assetModelHierarchyId())
                .add("InterfaceAssetModelHierarchyId", interfaceAssetModelHierarchyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetModelHierarchyId":
            return Optional.ofNullable(clazz.cast(assetModelHierarchyId()));
        case "interfaceAssetModelHierarchyId":
            return Optional.ofNullable(clazz.cast(interfaceAssetModelHierarchyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assetModelHierarchyId", ASSET_MODEL_HIERARCHY_ID_FIELD);
        map.put("interfaceAssetModelHierarchyId", INTERFACE_ASSET_MODEL_HIERARCHY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HierarchyMapping, T> g) {
        return obj -> g.apply((HierarchyMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HierarchyMapping> {
        /**
         * <p>
         * The ID of the hierarchy in the asset model where the interface is applied.
         * </p>
         * 
         * @param assetModelHierarchyId
         *        The ID of the hierarchy in the asset model where the interface is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelHierarchyId(String assetModelHierarchyId);

        /**
         * <p>
         * The ID of the hierarchy in the interface asset model.
         * </p>
         * 
         * @param interfaceAssetModelHierarchyId
         *        The ID of the hierarchy in the interface asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceAssetModelHierarchyId(String interfaceAssetModelHierarchyId);
    }

    static final class BuilderImpl implements Builder {
        private String assetModelHierarchyId;

        private String interfaceAssetModelHierarchyId;

        private BuilderImpl() {
        }

        private BuilderImpl(HierarchyMapping model) {
            assetModelHierarchyId(model.assetModelHierarchyId);
            interfaceAssetModelHierarchyId(model.interfaceAssetModelHierarchyId);
        }

        public final String getAssetModelHierarchyId() {
            return assetModelHierarchyId;
        }

        public final void setAssetModelHierarchyId(String assetModelHierarchyId) {
            this.assetModelHierarchyId = assetModelHierarchyId;
        }

        @Override
        public final Builder assetModelHierarchyId(String assetModelHierarchyId) {
            this.assetModelHierarchyId = assetModelHierarchyId;
            return this;
        }

        public final String getInterfaceAssetModelHierarchyId() {
            return interfaceAssetModelHierarchyId;
        }

        public final void setInterfaceAssetModelHierarchyId(String interfaceAssetModelHierarchyId) {
            this.interfaceAssetModelHierarchyId = interfaceAssetModelHierarchyId;
        }

        @Override
        public final Builder interfaceAssetModelHierarchyId(String interfaceAssetModelHierarchyId) {
            this.interfaceAssetModelHierarchyId = interfaceAssetModelHierarchyId;
            return this;
        }

        @Override
        public HierarchyMapping build() {
            return new HierarchyMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
