/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the execution summary of the computation model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ExecutionSummary.Builder, ExecutionSummary> {
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionId").getter(getter(ExecutionSummary::executionId)).setter(setter(Builder::executionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()).build();

    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionType").getter(getter(ExecutionSummary::actionType)).setter(setter(Builder::actionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionType").build()).build();

    private static final SdkField<TargetResource> TARGET_RESOURCE_FIELD = SdkField
            .<TargetResource> builder(MarshallingType.SDK_POJO).memberName("targetResource")
            .getter(getter(ExecutionSummary::targetResource)).setter(setter(Builder::targetResource))
            .constructor(TargetResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResource").build()).build();

    private static final SdkField<String> TARGET_RESOURCE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetResourceVersion").getter(getter(ExecutionSummary::targetResourceVersion))
            .setter(setter(Builder::targetResourceVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceVersion").build())
            .build();

    private static final SdkField<ResolveTo> RESOLVE_TO_FIELD = SdkField.<ResolveTo> builder(MarshallingType.SDK_POJO)
            .memberName("resolveTo").getter(getter(ExecutionSummary::resolveTo)).setter(setter(Builder::resolveTo))
            .constructor(ResolveTo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolveTo").build()).build();

    private static final SdkField<Instant> EXECUTION_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("executionStartTime").getter(getter(ExecutionSummary::executionStartTime))
            .setter(setter(Builder::executionStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStartTime").build())
            .build();

    private static final SdkField<Instant> EXECUTION_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("executionEndTime").getter(getter(ExecutionSummary::executionEndTime))
            .setter(setter(Builder::executionEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionEndTime").build()).build();

    private static final SdkField<ExecutionStatus> EXECUTION_STATUS_FIELD = SdkField
            .<ExecutionStatus> builder(MarshallingType.SDK_POJO).memberName("executionStatus")
            .getter(getter(ExecutionSummary::executionStatus)).setter(setter(Builder::executionStatus))
            .constructor(ExecutionStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStatus").build()).build();

    private static final SdkField<String> EXECUTION_ENTITY_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionEntityVersion").getter(getter(ExecutionSummary::executionEntityVersion))
            .setter(setter(Builder::executionEntityVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionEntityVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ID_FIELD,
            ACTION_TYPE_FIELD, TARGET_RESOURCE_FIELD, TARGET_RESOURCE_VERSION_FIELD, RESOLVE_TO_FIELD,
            EXECUTION_START_TIME_FIELD, EXECUTION_END_TIME_FIELD, EXECUTION_STATUS_FIELD, EXECUTION_ENTITY_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String executionId;

    private final String actionType;

    private final TargetResource targetResource;

    private final String targetResourceVersion;

    private final ResolveTo resolveTo;

    private final Instant executionStartTime;

    private final Instant executionEndTime;

    private final ExecutionStatus executionStatus;

    private final String executionEntityVersion;

    private ExecutionSummary(BuilderImpl builder) {
        this.executionId = builder.executionId;
        this.actionType = builder.actionType;
        this.targetResource = builder.targetResource;
        this.targetResourceVersion = builder.targetResourceVersion;
        this.resolveTo = builder.resolveTo;
        this.executionStartTime = builder.executionStartTime;
        this.executionEndTime = builder.executionEndTime;
        this.executionStatus = builder.executionStatus;
        this.executionEntityVersion = builder.executionEntityVersion;
    }

    /**
     * <p>
     * The ID of the execution.
     * </p>
     * 
     * @return The ID of the execution.
     */
    public final String executionId() {
        return executionId;
    }

    /**
     * <p>
     * The type of action exectued.
     * </p>
     * 
     * @return The type of action exectued.
     */
    public final String actionType() {
        return actionType;
    }

    /**
     * Returns the value of the TargetResource property for this object.
     * 
     * @return The value of the TargetResource property for this object.
     */
    public final TargetResource targetResource() {
        return targetResource;
    }

    /**
     * <p>
     * The version of the target resource.
     * </p>
     * 
     * @return The version of the target resource.
     */
    public final String targetResourceVersion() {
        return targetResourceVersion;
    }

    /**
     * <p>
     * The detailed resource this execution resolves to.
     * </p>
     * 
     * @return The detailed resource this execution resolves to.
     */
    public final ResolveTo resolveTo() {
        return resolveTo;
    }

    /**
     * <p>
     * The time the process started.
     * </p>
     * 
     * @return The time the process started.
     */
    public final Instant executionStartTime() {
        return executionStartTime;
    }

    /**
     * <p>
     * The time the process ended.
     * </p>
     * 
     * @return The time the process ended.
     */
    public final Instant executionEndTime() {
        return executionEndTime;
    }

    /**
     * <p>
     * The status of the execution process.
     * </p>
     * 
     * @return The status of the execution process.
     */
    public final ExecutionStatus executionStatus() {
        return executionStatus;
    }

    /**
     * <p>
     * The execution entity version associated with the summary.
     * </p>
     * 
     * @return The execution entity version associated with the summary.
     */
    public final String executionEntityVersion() {
        return executionEntityVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executionId());
        hashCode = 31 * hashCode + Objects.hashCode(actionType());
        hashCode = 31 * hashCode + Objects.hashCode(targetResource());
        hashCode = 31 * hashCode + Objects.hashCode(targetResourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(resolveTo());
        hashCode = 31 * hashCode + Objects.hashCode(executionStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(executionEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(executionStatus());
        hashCode = 31 * hashCode + Objects.hashCode(executionEntityVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionSummary)) {
            return false;
        }
        ExecutionSummary other = (ExecutionSummary) obj;
        return Objects.equals(executionId(), other.executionId()) && Objects.equals(actionType(), other.actionType())
                && Objects.equals(targetResource(), other.targetResource())
                && Objects.equals(targetResourceVersion(), other.targetResourceVersion())
                && Objects.equals(resolveTo(), other.resolveTo())
                && Objects.equals(executionStartTime(), other.executionStartTime())
                && Objects.equals(executionEndTime(), other.executionEndTime())
                && Objects.equals(executionStatus(), other.executionStatus())
                && Objects.equals(executionEntityVersion(), other.executionEntityVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecutionSummary").add("ExecutionId", executionId()).add("ActionType", actionType())
                .add("TargetResource", targetResource()).add("TargetResourceVersion", targetResourceVersion())
                .add("ResolveTo", resolveTo()).add("ExecutionStartTime", executionStartTime())
                .add("ExecutionEndTime", executionEndTime()).add("ExecutionStatus", executionStatus())
                .add("ExecutionEntityVersion", executionEntityVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionId":
            return Optional.ofNullable(clazz.cast(executionId()));
        case "actionType":
            return Optional.ofNullable(clazz.cast(actionType()));
        case "targetResource":
            return Optional.ofNullable(clazz.cast(targetResource()));
        case "targetResourceVersion":
            return Optional.ofNullable(clazz.cast(targetResourceVersion()));
        case "resolveTo":
            return Optional.ofNullable(clazz.cast(resolveTo()));
        case "executionStartTime":
            return Optional.ofNullable(clazz.cast(executionStartTime()));
        case "executionEndTime":
            return Optional.ofNullable(clazz.cast(executionEndTime()));
        case "executionStatus":
            return Optional.ofNullable(clazz.cast(executionStatus()));
        case "executionEntityVersion":
            return Optional.ofNullable(clazz.cast(executionEntityVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("executionId", EXECUTION_ID_FIELD);
        map.put("actionType", ACTION_TYPE_FIELD);
        map.put("targetResource", TARGET_RESOURCE_FIELD);
        map.put("targetResourceVersion", TARGET_RESOURCE_VERSION_FIELD);
        map.put("resolveTo", RESOLVE_TO_FIELD);
        map.put("executionStartTime", EXECUTION_START_TIME_FIELD);
        map.put("executionEndTime", EXECUTION_END_TIME_FIELD);
        map.put("executionStatus", EXECUTION_STATUS_FIELD);
        map.put("executionEntityVersion", EXECUTION_ENTITY_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecutionSummary, T> g) {
        return obj -> g.apply((ExecutionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecutionSummary> {
        /**
         * <p>
         * The ID of the execution.
         * </p>
         * 
         * @param executionId
         *        The ID of the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);

        /**
         * <p>
         * The type of action exectued.
         * </p>
         * 
         * @param actionType
         *        The type of action exectued.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionType(String actionType);

        /**
         * Sets the value of the TargetResource property for this object.
         *
         * @param targetResource
         *        The new value for the TargetResource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResource(TargetResource targetResource);

        /**
         * Sets the value of the TargetResource property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TargetResource.Builder} avoiding the need
         * to create one manually via {@link TargetResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetResource.Builder#build()} is called immediately and its
         * result is passed to {@link #targetResource(TargetResource)}.
         * 
         * @param targetResource
         *        a consumer that will call methods on {@link TargetResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetResource(TargetResource)
         */
        default Builder targetResource(Consumer<TargetResource.Builder> targetResource) {
            return targetResource(TargetResource.builder().applyMutation(targetResource).build());
        }

        /**
         * <p>
         * The version of the target resource.
         * </p>
         * 
         * @param targetResourceVersion
         *        The version of the target resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResourceVersion(String targetResourceVersion);

        /**
         * <p>
         * The detailed resource this execution resolves to.
         * </p>
         * 
         * @param resolveTo
         *        The detailed resource this execution resolves to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolveTo(ResolveTo resolveTo);

        /**
         * <p>
         * The detailed resource this execution resolves to.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResolveTo.Builder} avoiding the need to
         * create one manually via {@link ResolveTo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResolveTo.Builder#build()} is called immediately and its result
         * is passed to {@link #resolveTo(ResolveTo)}.
         * 
         * @param resolveTo
         *        a consumer that will call methods on {@link ResolveTo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resolveTo(ResolveTo)
         */
        default Builder resolveTo(Consumer<ResolveTo.Builder> resolveTo) {
            return resolveTo(ResolveTo.builder().applyMutation(resolveTo).build());
        }

        /**
         * <p>
         * The time the process started.
         * </p>
         * 
         * @param executionStartTime
         *        The time the process started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStartTime(Instant executionStartTime);

        /**
         * <p>
         * The time the process ended.
         * </p>
         * 
         * @param executionEndTime
         *        The time the process ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionEndTime(Instant executionEndTime);

        /**
         * <p>
         * The status of the execution process.
         * </p>
         * 
         * @param executionStatus
         *        The status of the execution process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStatus(ExecutionStatus executionStatus);

        /**
         * <p>
         * The status of the execution process.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecutionStatus.Builder} avoiding the
         * need to create one manually via {@link ExecutionStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecutionStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #executionStatus(ExecutionStatus)}.
         * 
         * @param executionStatus
         *        a consumer that will call methods on {@link ExecutionStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionStatus(ExecutionStatus)
         */
        default Builder executionStatus(Consumer<ExecutionStatus.Builder> executionStatus) {
            return executionStatus(ExecutionStatus.builder().applyMutation(executionStatus).build());
        }

        /**
         * <p>
         * The execution entity version associated with the summary.
         * </p>
         * 
         * @param executionEntityVersion
         *        The execution entity version associated with the summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionEntityVersion(String executionEntityVersion);
    }

    static final class BuilderImpl implements Builder {
        private String executionId;

        private String actionType;

        private TargetResource targetResource;

        private String targetResourceVersion;

        private ResolveTo resolveTo;

        private Instant executionStartTime;

        private Instant executionEndTime;

        private ExecutionStatus executionStatus;

        private String executionEntityVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionSummary model) {
            executionId(model.executionId);
            actionType(model.actionType);
            targetResource(model.targetResource);
            targetResourceVersion(model.targetResourceVersion);
            resolveTo(model.resolveTo);
            executionStartTime(model.executionStartTime);
            executionEndTime(model.executionEndTime);
            executionStatus(model.executionStatus);
            executionEntityVersion(model.executionEntityVersion);
        }

        public final String getExecutionId() {
            return executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getActionType() {
            return actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        public final TargetResource.Builder getTargetResource() {
            return targetResource != null ? targetResource.toBuilder() : null;
        }

        public final void setTargetResource(TargetResource.BuilderImpl targetResource) {
            this.targetResource = targetResource != null ? targetResource.build() : null;
        }

        @Override
        public final Builder targetResource(TargetResource targetResource) {
            this.targetResource = targetResource;
            return this;
        }

        public final String getTargetResourceVersion() {
            return targetResourceVersion;
        }

        public final void setTargetResourceVersion(String targetResourceVersion) {
            this.targetResourceVersion = targetResourceVersion;
        }

        @Override
        public final Builder targetResourceVersion(String targetResourceVersion) {
            this.targetResourceVersion = targetResourceVersion;
            return this;
        }

        public final ResolveTo.Builder getResolveTo() {
            return resolveTo != null ? resolveTo.toBuilder() : null;
        }

        public final void setResolveTo(ResolveTo.BuilderImpl resolveTo) {
            this.resolveTo = resolveTo != null ? resolveTo.build() : null;
        }

        @Override
        public final Builder resolveTo(ResolveTo resolveTo) {
            this.resolveTo = resolveTo;
            return this;
        }

        public final Instant getExecutionStartTime() {
            return executionStartTime;
        }

        public final void setExecutionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
        }

        @Override
        public final Builder executionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
            return this;
        }

        public final Instant getExecutionEndTime() {
            return executionEndTime;
        }

        public final void setExecutionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
        }

        @Override
        public final Builder executionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
            return this;
        }

        public final ExecutionStatus.Builder getExecutionStatus() {
            return executionStatus != null ? executionStatus.toBuilder() : null;
        }

        public final void setExecutionStatus(ExecutionStatus.BuilderImpl executionStatus) {
            this.executionStatus = executionStatus != null ? executionStatus.build() : null;
        }

        @Override
        public final Builder executionStatus(ExecutionStatus executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        public final String getExecutionEntityVersion() {
            return executionEntityVersion;
        }

        public final void setExecutionEntityVersion(String executionEntityVersion) {
            this.executionEntityVersion = executionEntityVersion;
        }

        @Override
        public final Builder executionEntityVersion(String executionEntityVersion) {
            this.executionEntityVersion = executionEntityVersion;
            return this;
        }

        @Override
        public ExecutionSummary build() {
            return new ExecutionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
