/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStorageConfigurationResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<DescribeStorageConfigurationResponse.Builder, DescribeStorageConfigurationResponse> {
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storageType").getter(getter(DescribeStorageConfigurationResponse::storageTypeAsString))
            .setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageType").build()).build();

    private static final SdkField<MultiLayerStorage> MULTI_LAYER_STORAGE_FIELD = SdkField
            .<MultiLayerStorage> builder(MarshallingType.SDK_POJO).memberName("multiLayerStorage")
            .getter(getter(DescribeStorageConfigurationResponse::multiLayerStorage)).setter(setter(Builder::multiLayerStorage))
            .constructor(MultiLayerStorage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiLayerStorage").build()).build();

    private static final SdkField<String> DISASSOCIATED_DATA_STORAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("disassociatedDataStorage")
            .getter(getter(DescribeStorageConfigurationResponse::disassociatedDataStorageAsString))
            .setter(setter(Builder::disassociatedDataStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disassociatedDataStorage").build())
            .build();

    private static final SdkField<RetentionPeriod> RETENTION_PERIOD_FIELD = SdkField
            .<RetentionPeriod> builder(MarshallingType.SDK_POJO).memberName("retentionPeriod")
            .getter(getter(DescribeStorageConfigurationResponse::retentionPeriod)).setter(setter(Builder::retentionPeriod))
            .constructor(RetentionPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionPeriod").build()).build();

    private static final SdkField<ConfigurationStatus> CONFIGURATION_STATUS_FIELD = SdkField
            .<ConfigurationStatus> builder(MarshallingType.SDK_POJO).memberName("configurationStatus")
            .getter(getter(DescribeStorageConfigurationResponse::configurationStatus))
            .setter(setter(Builder::configurationStatus)).constructor(ConfigurationStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationStatus").build())
            .build();

    private static final SdkField<Instant> LAST_UPDATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdateDate").getter(getter(DescribeStorageConfigurationResponse::lastUpdateDate))
            .setter(setter(Builder::lastUpdateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateDate").build()).build();

    private static final SdkField<String> WARM_TIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("warmTier").getter(getter(DescribeStorageConfigurationResponse::warmTierAsString))
            .setter(setter(Builder::warmTier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warmTier").build()).build();

    private static final SdkField<WarmTierRetentionPeriod> WARM_TIER_RETENTION_PERIOD_FIELD = SdkField
            .<WarmTierRetentionPeriod> builder(MarshallingType.SDK_POJO).memberName("warmTierRetentionPeriod")
            .getter(getter(DescribeStorageConfigurationResponse::warmTierRetentionPeriod))
            .setter(setter(Builder::warmTierRetentionPeriod)).constructor(WarmTierRetentionPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warmTierRetentionPeriod").build())
            .build();

    private static final SdkField<Boolean> DISALLOW_INGEST_NULL_NAN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("disallowIngestNullNaN").getter(getter(DescribeStorageConfigurationResponse::disallowIngestNullNaN))
            .setter(setter(Builder::disallowIngestNullNaN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disallowIngestNullNaN").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_TYPE_FIELD,
            MULTI_LAYER_STORAGE_FIELD, DISASSOCIATED_DATA_STORAGE_FIELD, RETENTION_PERIOD_FIELD, CONFIGURATION_STATUS_FIELD,
            LAST_UPDATE_DATE_FIELD, WARM_TIER_FIELD, WARM_TIER_RETENTION_PERIOD_FIELD, DISALLOW_INGEST_NULL_NAN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String storageType;

    private final MultiLayerStorage multiLayerStorage;

    private final String disassociatedDataStorage;

    private final RetentionPeriod retentionPeriod;

    private final ConfigurationStatus configurationStatus;

    private final Instant lastUpdateDate;

    private final String warmTier;

    private final WarmTierRetentionPeriod warmTierRetentionPeriod;

    private final Boolean disallowIngestNullNaN;

    private DescribeStorageConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.storageType = builder.storageType;
        this.multiLayerStorage = builder.multiLayerStorage;
        this.disassociatedDataStorage = builder.disassociatedDataStorage;
        this.retentionPeriod = builder.retentionPeriod;
        this.configurationStatus = builder.configurationStatus;
        this.lastUpdateDate = builder.lastUpdateDate;
        this.warmTier = builder.warmTier;
        this.warmTierRetentionPeriod = builder.warmTierRetentionPeriod;
        this.disallowIngestNullNaN = builder.disallowIngestNullNaN;
    }

    /**
     * <p>
     * The storage tier that you specified for your data. The <code>storageType</code> parameter can be one of the
     * following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise saves your data into the hot tier. The hot tier is a
     * service-managed database.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise saves your data in both the cold tier and the hot tier. The cold
     * tier is a customer-managed Amazon S3 bucket.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link StorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return The storage tier that you specified for your data. The <code>storageType</code> parameter can be one of
     *         the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise saves your data into the hot tier. The hot tier is a
     *         service-managed database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise saves your data in both the cold tier and the hot tier.
     *         The cold tier is a customer-managed Amazon S3 bucket.
     *         </p>
     *         </li>
     * @see StorageType
     */
    public final StorageType storageType() {
        return StorageType.fromValue(storageType);
    }

    /**
     * <p>
     * The storage tier that you specified for your data. The <code>storageType</code> parameter can be one of the
     * following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise saves your data into the hot tier. The hot tier is a
     * service-managed database.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise saves your data in both the cold tier and the hot tier. The cold
     * tier is a customer-managed Amazon S3 bucket.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link StorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return The storage tier that you specified for your data. The <code>storageType</code> parameter can be one of
     *         the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise saves your data into the hot tier. The hot tier is a
     *         service-managed database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise saves your data in both the cold tier and the hot tier.
     *         The cold tier is a customer-managed Amazon S3 bucket.
     *         </p>
     *         </li>
     * @see StorageType
     */
    public final String storageTypeAsString() {
        return storageType;
    }

    /**
     * <p>
     * Contains information about the storage destination.
     * </p>
     * 
     * @return Contains information about the storage destination.
     */
    public final MultiLayerStorage multiLayerStorage() {
        return multiLayerStorage;
    }

    /**
     * <p>
     * Contains the storage configuration for time series (data streams) that aren't associated with asset properties.
     * The <code>disassociatedDataStorage</code> can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> – IoT SiteWise accepts time series that aren't associated with asset properties.
     * </p>
     * <important>
     * <p>
     * After the <code>disassociatedDataStorage</code> is enabled, you can't disable it.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <code>DISABLED</code> – IoT SiteWise doesn't accept time series (data streams) that aren't associated with asset
     * properties.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html">Data streams</a> in the <i>IoT
     * SiteWise User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #disassociatedDataStorage} will return {@link DisassociatedDataStorageState#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #disassociatedDataStorageAsString}.
     * </p>
     * 
     * @return Contains the storage configuration for time series (data streams) that aren't associated with asset
     *         properties. The <code>disassociatedDataStorage</code> can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> – IoT SiteWise accepts time series that aren't associated with asset properties.
     *         </p>
     *         <important>
     *         <p>
     *         After the <code>disassociatedDataStorage</code> is enabled, you can't disable it.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> – IoT SiteWise doesn't accept time series (data streams) that aren't associated
     *         with asset properties.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html">Data streams</a> in
     *         the <i>IoT SiteWise User Guide</i>.
     * @see DisassociatedDataStorageState
     */
    public final DisassociatedDataStorageState disassociatedDataStorage() {
        return DisassociatedDataStorageState.fromValue(disassociatedDataStorage);
    }

    /**
     * <p>
     * Contains the storage configuration for time series (data streams) that aren't associated with asset properties.
     * The <code>disassociatedDataStorage</code> can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> – IoT SiteWise accepts time series that aren't associated with asset properties.
     * </p>
     * <important>
     * <p>
     * After the <code>disassociatedDataStorage</code> is enabled, you can't disable it.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <code>DISABLED</code> – IoT SiteWise doesn't accept time series (data streams) that aren't associated with asset
     * properties.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html">Data streams</a> in the <i>IoT
     * SiteWise User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #disassociatedDataStorage} will return {@link DisassociatedDataStorageState#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #disassociatedDataStorageAsString}.
     * </p>
     * 
     * @return Contains the storage configuration for time series (data streams) that aren't associated with asset
     *         properties. The <code>disassociatedDataStorage</code> can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> – IoT SiteWise accepts time series that aren't associated with asset properties.
     *         </p>
     *         <important>
     *         <p>
     *         After the <code>disassociatedDataStorage</code> is enabled, you can't disable it.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> – IoT SiteWise doesn't accept time series (data streams) that aren't associated
     *         with asset properties.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html">Data streams</a> in
     *         the <i>IoT SiteWise User Guide</i>.
     * @see DisassociatedDataStorageState
     */
    public final String disassociatedDataStorageAsString() {
        return disassociatedDataStorage;
    }

    /**
     * <p>
     * The number of days your data is kept in the hot tier. By default, your data is kept indefinitely in the hot tier.
     * </p>
     * 
     * @return The number of days your data is kept in the hot tier. By default, your data is kept indefinitely in the
     *         hot tier.
     */
    public final RetentionPeriod retentionPeriod() {
        return retentionPeriod;
    }

    /**
     * Returns the value of the ConfigurationStatus property for this object.
     * 
     * @return The value of the ConfigurationStatus property for this object.
     */
    public final ConfigurationStatus configurationStatus() {
        return configurationStatus;
    }

    /**
     * <p>
     * The date the storage configuration was last updated, in Unix epoch time.
     * </p>
     * 
     * @return The date the storage configuration was last updated, in Unix epoch time.
     */
    public final Instant lastUpdateDate() {
        return lastUpdateDate;
    }

    /**
     * <p>
     * A service managed storage tier optimized for analytical queries. It stores periodically uploaded, buffered and
     * historical data ingested with the CreaeBulkImportJob API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #warmTier} will
     * return {@link WarmTierState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #warmTierAsString}.
     * </p>
     * 
     * @return A service managed storage tier optimized for analytical queries. It stores periodically uploaded,
     *         buffered and historical data ingested with the CreaeBulkImportJob API.
     * @see WarmTierState
     */
    public final WarmTierState warmTier() {
        return WarmTierState.fromValue(warmTier);
    }

    /**
     * <p>
     * A service managed storage tier optimized for analytical queries. It stores periodically uploaded, buffered and
     * historical data ingested with the CreaeBulkImportJob API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #warmTier} will
     * return {@link WarmTierState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #warmTierAsString}.
     * </p>
     * 
     * @return A service managed storage tier optimized for analytical queries. It stores periodically uploaded,
     *         buffered and historical data ingested with the CreaeBulkImportJob API.
     * @see WarmTierState
     */
    public final String warmTierAsString() {
        return warmTier;
    }

    /**
     * <p>
     * Set this period to specify how long your data is stored in the warm tier before it is deleted. You can set this
     * only if cold tier is enabled.
     * </p>
     * 
     * @return Set this period to specify how long your data is stored in the warm tier before it is deleted. You can
     *         set this only if cold tier is enabled.
     */
    public final WarmTierRetentionPeriod warmTierRetentionPeriod() {
        return warmTierRetentionPeriod;
    }

    /**
     * <p>
     * Describes the configuration for ingesting NULL and NaN data. By default the feature is allowed. The feature is
     * disallowed if the value is <code>true</code>.
     * </p>
     * 
     * @return Describes the configuration for ingesting NULL and NaN data. By default the feature is allowed. The
     *         feature is disallowed if the value is <code>true</code>.
     */
    public final Boolean disallowIngestNullNaN() {
        return disallowIngestNullNaN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(storageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(multiLayerStorage());
        hashCode = 31 * hashCode + Objects.hashCode(disassociatedDataStorageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(configurationStatus());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateDate());
        hashCode = 31 * hashCode + Objects.hashCode(warmTierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(warmTierRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(disallowIngestNullNaN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStorageConfigurationResponse)) {
            return false;
        }
        DescribeStorageConfigurationResponse other = (DescribeStorageConfigurationResponse) obj;
        return Objects.equals(storageTypeAsString(), other.storageTypeAsString())
                && Objects.equals(multiLayerStorage(), other.multiLayerStorage())
                && Objects.equals(disassociatedDataStorageAsString(), other.disassociatedDataStorageAsString())
                && Objects.equals(retentionPeriod(), other.retentionPeriod())
                && Objects.equals(configurationStatus(), other.configurationStatus())
                && Objects.equals(lastUpdateDate(), other.lastUpdateDate())
                && Objects.equals(warmTierAsString(), other.warmTierAsString())
                && Objects.equals(warmTierRetentionPeriod(), other.warmTierRetentionPeriod())
                && Objects.equals(disallowIngestNullNaN(), other.disallowIngestNullNaN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStorageConfigurationResponse").add("StorageType", storageTypeAsString())
                .add("MultiLayerStorage", multiLayerStorage())
                .add("DisassociatedDataStorage", disassociatedDataStorageAsString()).add("RetentionPeriod", retentionPeriod())
                .add("ConfigurationStatus", configurationStatus()).add("LastUpdateDate", lastUpdateDate())
                .add("WarmTier", warmTierAsString()).add("WarmTierRetentionPeriod", warmTierRetentionPeriod())
                .add("DisallowIngestNullNaN", disallowIngestNullNaN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "storageType":
            return Optional.ofNullable(clazz.cast(storageTypeAsString()));
        case "multiLayerStorage":
            return Optional.ofNullable(clazz.cast(multiLayerStorage()));
        case "disassociatedDataStorage":
            return Optional.ofNullable(clazz.cast(disassociatedDataStorageAsString()));
        case "retentionPeriod":
            return Optional.ofNullable(clazz.cast(retentionPeriod()));
        case "configurationStatus":
            return Optional.ofNullable(clazz.cast(configurationStatus()));
        case "lastUpdateDate":
            return Optional.ofNullable(clazz.cast(lastUpdateDate()));
        case "warmTier":
            return Optional.ofNullable(clazz.cast(warmTierAsString()));
        case "warmTierRetentionPeriod":
            return Optional.ofNullable(clazz.cast(warmTierRetentionPeriod()));
        case "disallowIngestNullNaN":
            return Optional.ofNullable(clazz.cast(disallowIngestNullNaN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("storageType", STORAGE_TYPE_FIELD);
        map.put("multiLayerStorage", MULTI_LAYER_STORAGE_FIELD);
        map.put("disassociatedDataStorage", DISASSOCIATED_DATA_STORAGE_FIELD);
        map.put("retentionPeriod", RETENTION_PERIOD_FIELD);
        map.put("configurationStatus", CONFIGURATION_STATUS_FIELD);
        map.put("lastUpdateDate", LAST_UPDATE_DATE_FIELD);
        map.put("warmTier", WARM_TIER_FIELD);
        map.put("warmTierRetentionPeriod", WARM_TIER_RETENTION_PERIOD_FIELD);
        map.put("disallowIngestNullNaN", DISALLOW_INGEST_NULL_NAN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeStorageConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeStorageConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeStorageConfigurationResponse> {
        /**
         * <p>
         * The storage tier that you specified for your data. The <code>storageType</code> parameter can be one of the
         * following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise saves your data into the hot tier. The hot tier is a
         * service-managed database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise saves your data in both the cold tier and the hot tier. The
         * cold tier is a customer-managed Amazon S3 bucket.
         * </p>
         * </li>
         * </ul>
         * 
         * @param storageType
         *        The storage tier that you specified for your data. The <code>storageType</code> parameter can be one
         *        of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise saves your data into the hot tier. The hot tier
         *        is a service-managed database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise saves your data in both the cold tier and the hot
         *        tier. The cold tier is a customer-managed Amazon S3 bucket.
         *        </p>
         *        </li>
         * @see StorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageType
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The storage tier that you specified for your data. The <code>storageType</code> parameter can be one of the
         * following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise saves your data into the hot tier. The hot tier is a
         * service-managed database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise saves your data in both the cold tier and the hot tier. The
         * cold tier is a customer-managed Amazon S3 bucket.
         * </p>
         * </li>
         * </ul>
         * 
         * @param storageType
         *        The storage tier that you specified for your data. The <code>storageType</code> parameter can be one
         *        of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise saves your data into the hot tier. The hot tier
         *        is a service-managed database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise saves your data in both the cold tier and the hot
         *        tier. The cold tier is a customer-managed Amazon S3 bucket.
         *        </p>
         *        </li>
         * @see StorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageType
         */
        Builder storageType(StorageType storageType);

        /**
         * <p>
         * Contains information about the storage destination.
         * </p>
         * 
         * @param multiLayerStorage
         *        Contains information about the storage destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiLayerStorage(MultiLayerStorage multiLayerStorage);

        /**
         * <p>
         * Contains information about the storage destination.
         * </p>
         * This is a convenience method that creates an instance of the {@link MultiLayerStorage.Builder} avoiding the
         * need to create one manually via {@link MultiLayerStorage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MultiLayerStorage.Builder#build()} is called immediately and its
         * result is passed to {@link #multiLayerStorage(MultiLayerStorage)}.
         * 
         * @param multiLayerStorage
         *        a consumer that will call methods on {@link MultiLayerStorage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiLayerStorage(MultiLayerStorage)
         */
        default Builder multiLayerStorage(Consumer<MultiLayerStorage.Builder> multiLayerStorage) {
            return multiLayerStorage(MultiLayerStorage.builder().applyMutation(multiLayerStorage).build());
        }

        /**
         * <p>
         * Contains the storage configuration for time series (data streams) that aren't associated with asset
         * properties. The <code>disassociatedDataStorage</code> can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> – IoT SiteWise accepts time series that aren't associated with asset properties.
         * </p>
         * <important>
         * <p>
         * After the <code>disassociatedDataStorage</code> is enabled, you can't disable it.
         * </p>
         * </important></li>
         * <li>
         * <p>
         * <code>DISABLED</code> – IoT SiteWise doesn't accept time series (data streams) that aren't associated with
         * asset properties.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html">Data streams</a> in the
         * <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param disassociatedDataStorage
         *        Contains the storage configuration for time series (data streams) that aren't associated with asset
         *        properties. The <code>disassociatedDataStorage</code> can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> – IoT SiteWise accepts time series that aren't associated with asset properties.
         *        </p>
         *        <important>
         *        <p>
         *        After the <code>disassociatedDataStorage</code> is enabled, you can't disable it.
         *        </p>
         *        </important></li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> – IoT SiteWise doesn't accept time series (data streams) that aren't associated
         *        with asset properties.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html">Data streams</a> in
         *        the <i>IoT SiteWise User Guide</i>.
         * @see DisassociatedDataStorageState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DisassociatedDataStorageState
         */
        Builder disassociatedDataStorage(String disassociatedDataStorage);

        /**
         * <p>
         * Contains the storage configuration for time series (data streams) that aren't associated with asset
         * properties. The <code>disassociatedDataStorage</code> can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> – IoT SiteWise accepts time series that aren't associated with asset properties.
         * </p>
         * <important>
         * <p>
         * After the <code>disassociatedDataStorage</code> is enabled, you can't disable it.
         * </p>
         * </important></li>
         * <li>
         * <p>
         * <code>DISABLED</code> – IoT SiteWise doesn't accept time series (data streams) that aren't associated with
         * asset properties.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html">Data streams</a> in the
         * <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param disassociatedDataStorage
         *        Contains the storage configuration for time series (data streams) that aren't associated with asset
         *        properties. The <code>disassociatedDataStorage</code> can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> – IoT SiteWise accepts time series that aren't associated with asset properties.
         *        </p>
         *        <important>
         *        <p>
         *        After the <code>disassociatedDataStorage</code> is enabled, you can't disable it.
         *        </p>
         *        </important></li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> – IoT SiteWise doesn't accept time series (data streams) that aren't associated
         *        with asset properties.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html">Data streams</a> in
         *        the <i>IoT SiteWise User Guide</i>.
         * @see DisassociatedDataStorageState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DisassociatedDataStorageState
         */
        Builder disassociatedDataStorage(DisassociatedDataStorageState disassociatedDataStorage);

        /**
         * <p>
         * The number of days your data is kept in the hot tier. By default, your data is kept indefinitely in the hot
         * tier.
         * </p>
         * 
         * @param retentionPeriod
         *        The number of days your data is kept in the hot tier. By default, your data is kept indefinitely in
         *        the hot tier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriod(RetentionPeriod retentionPeriod);

        /**
         * <p>
         * The number of days your data is kept in the hot tier. By default, your data is kept indefinitely in the hot
         * tier.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetentionPeriod.Builder} avoiding the
         * need to create one manually via {@link RetentionPeriod#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetentionPeriod.Builder#build()} is called immediately and its
         * result is passed to {@link #retentionPeriod(RetentionPeriod)}.
         * 
         * @param retentionPeriod
         *        a consumer that will call methods on {@link RetentionPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retentionPeriod(RetentionPeriod)
         */
        default Builder retentionPeriod(Consumer<RetentionPeriod.Builder> retentionPeriod) {
            return retentionPeriod(RetentionPeriod.builder().applyMutation(retentionPeriod).build());
        }

        /**
         * Sets the value of the ConfigurationStatus property for this object.
         *
         * @param configurationStatus
         *        The new value for the ConfigurationStatus property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationStatus(ConfigurationStatus configurationStatus);

        /**
         * Sets the value of the ConfigurationStatus property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ConfigurationStatus.Builder} avoiding the
         * need to create one manually via {@link ConfigurationStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfigurationStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #configurationStatus(ConfigurationStatus)}.
         * 
         * @param configurationStatus
         *        a consumer that will call methods on {@link ConfigurationStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationStatus(ConfigurationStatus)
         */
        default Builder configurationStatus(Consumer<ConfigurationStatus.Builder> configurationStatus) {
            return configurationStatus(ConfigurationStatus.builder().applyMutation(configurationStatus).build());
        }

        /**
         * <p>
         * The date the storage configuration was last updated, in Unix epoch time.
         * </p>
         * 
         * @param lastUpdateDate
         *        The date the storage configuration was last updated, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateDate(Instant lastUpdateDate);

        /**
         * <p>
         * A service managed storage tier optimized for analytical queries. It stores periodically uploaded, buffered
         * and historical data ingested with the CreaeBulkImportJob API.
         * </p>
         * 
         * @param warmTier
         *        A service managed storage tier optimized for analytical queries. It stores periodically uploaded,
         *        buffered and historical data ingested with the CreaeBulkImportJob API.
         * @see WarmTierState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WarmTierState
         */
        Builder warmTier(String warmTier);

        /**
         * <p>
         * A service managed storage tier optimized for analytical queries. It stores periodically uploaded, buffered
         * and historical data ingested with the CreaeBulkImportJob API.
         * </p>
         * 
         * @param warmTier
         *        A service managed storage tier optimized for analytical queries. It stores periodically uploaded,
         *        buffered and historical data ingested with the CreaeBulkImportJob API.
         * @see WarmTierState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WarmTierState
         */
        Builder warmTier(WarmTierState warmTier);

        /**
         * <p>
         * Set this period to specify how long your data is stored in the warm tier before it is deleted. You can set
         * this only if cold tier is enabled.
         * </p>
         * 
         * @param warmTierRetentionPeriod
         *        Set this period to specify how long your data is stored in the warm tier before it is deleted. You can
         *        set this only if cold tier is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warmTierRetentionPeriod(WarmTierRetentionPeriod warmTierRetentionPeriod);

        /**
         * <p>
         * Set this period to specify how long your data is stored in the warm tier before it is deleted. You can set
         * this only if cold tier is enabled.
         * </p>
         * This is a convenience method that creates an instance of the {@link WarmTierRetentionPeriod.Builder} avoiding
         * the need to create one manually via {@link WarmTierRetentionPeriod#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WarmTierRetentionPeriod.Builder#build()} is called immediately
         * and its result is passed to {@link #warmTierRetentionPeriod(WarmTierRetentionPeriod)}.
         * 
         * @param warmTierRetentionPeriod
         *        a consumer that will call methods on {@link WarmTierRetentionPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #warmTierRetentionPeriod(WarmTierRetentionPeriod)
         */
        default Builder warmTierRetentionPeriod(Consumer<WarmTierRetentionPeriod.Builder> warmTierRetentionPeriod) {
            return warmTierRetentionPeriod(WarmTierRetentionPeriod.builder().applyMutation(warmTierRetentionPeriod).build());
        }

        /**
         * <p>
         * Describes the configuration for ingesting NULL and NaN data. By default the feature is allowed. The feature
         * is disallowed if the value is <code>true</code>.
         * </p>
         * 
         * @param disallowIngestNullNaN
         *        Describes the configuration for ingesting NULL and NaN data. By default the feature is allowed. The
         *        feature is disallowed if the value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disallowIngestNullNaN(Boolean disallowIngestNullNaN);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private String storageType;

        private MultiLayerStorage multiLayerStorage;

        private String disassociatedDataStorage;

        private RetentionPeriod retentionPeriod;

        private ConfigurationStatus configurationStatus;

        private Instant lastUpdateDate;

        private String warmTier;

        private WarmTierRetentionPeriod warmTierRetentionPeriod;

        private Boolean disallowIngestNullNaN;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStorageConfigurationResponse model) {
            super(model);
            storageType(model.storageType);
            multiLayerStorage(model.multiLayerStorage);
            disassociatedDataStorage(model.disassociatedDataStorage);
            retentionPeriod(model.retentionPeriod);
            configurationStatus(model.configurationStatus);
            lastUpdateDate(model.lastUpdateDate);
            warmTier(model.warmTier);
            warmTierRetentionPeriod(model.warmTierRetentionPeriod);
            disallowIngestNullNaN(model.disallowIngestNullNaN);
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(StorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final MultiLayerStorage.Builder getMultiLayerStorage() {
            return multiLayerStorage != null ? multiLayerStorage.toBuilder() : null;
        }

        public final void setMultiLayerStorage(MultiLayerStorage.BuilderImpl multiLayerStorage) {
            this.multiLayerStorage = multiLayerStorage != null ? multiLayerStorage.build() : null;
        }

        @Override
        public final Builder multiLayerStorage(MultiLayerStorage multiLayerStorage) {
            this.multiLayerStorage = multiLayerStorage;
            return this;
        }

        public final String getDisassociatedDataStorage() {
            return disassociatedDataStorage;
        }

        public final void setDisassociatedDataStorage(String disassociatedDataStorage) {
            this.disassociatedDataStorage = disassociatedDataStorage;
        }

        @Override
        public final Builder disassociatedDataStorage(String disassociatedDataStorage) {
            this.disassociatedDataStorage = disassociatedDataStorage;
            return this;
        }

        @Override
        public final Builder disassociatedDataStorage(DisassociatedDataStorageState disassociatedDataStorage) {
            this.disassociatedDataStorage(disassociatedDataStorage == null ? null : disassociatedDataStorage.toString());
            return this;
        }

        public final RetentionPeriod.Builder getRetentionPeriod() {
            return retentionPeriod != null ? retentionPeriod.toBuilder() : null;
        }

        public final void setRetentionPeriod(RetentionPeriod.BuilderImpl retentionPeriod) {
            this.retentionPeriod = retentionPeriod != null ? retentionPeriod.build() : null;
        }

        @Override
        public final Builder retentionPeriod(RetentionPeriod retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final ConfigurationStatus.Builder getConfigurationStatus() {
            return configurationStatus != null ? configurationStatus.toBuilder() : null;
        }

        public final void setConfigurationStatus(ConfigurationStatus.BuilderImpl configurationStatus) {
            this.configurationStatus = configurationStatus != null ? configurationStatus.build() : null;
        }

        @Override
        public final Builder configurationStatus(ConfigurationStatus configurationStatus) {
            this.configurationStatus = configurationStatus;
            return this;
        }

        public final Instant getLastUpdateDate() {
            return lastUpdateDate;
        }

        public final void setLastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
        }

        @Override
        public final Builder lastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
            return this;
        }

        public final String getWarmTier() {
            return warmTier;
        }

        public final void setWarmTier(String warmTier) {
            this.warmTier = warmTier;
        }

        @Override
        public final Builder warmTier(String warmTier) {
            this.warmTier = warmTier;
            return this;
        }

        @Override
        public final Builder warmTier(WarmTierState warmTier) {
            this.warmTier(warmTier == null ? null : warmTier.toString());
            return this;
        }

        public final WarmTierRetentionPeriod.Builder getWarmTierRetentionPeriod() {
            return warmTierRetentionPeriod != null ? warmTierRetentionPeriod.toBuilder() : null;
        }

        public final void setWarmTierRetentionPeriod(WarmTierRetentionPeriod.BuilderImpl warmTierRetentionPeriod) {
            this.warmTierRetentionPeriod = warmTierRetentionPeriod != null ? warmTierRetentionPeriod.build() : null;
        }

        @Override
        public final Builder warmTierRetentionPeriod(WarmTierRetentionPeriod warmTierRetentionPeriod) {
            this.warmTierRetentionPeriod = warmTierRetentionPeriod;
            return this;
        }

        public final Boolean getDisallowIngestNullNaN() {
            return disallowIngestNullNaN;
        }

        public final void setDisallowIngestNullNaN(Boolean disallowIngestNullNaN) {
            this.disallowIngestNullNaN = disallowIngestNullNaN;
        }

        @Override
        public final Builder disallowIngestNullNaN(Boolean disallowIngestNullNaN) {
            this.disallowIngestNullNaN = disallowIngestNullNaN;
            return this;
        }

        @Override
        public DescribeStorageConfigurationResponse build() {
            return new DescribeStorageConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
