/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeComputationModelResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<DescribeComputationModelResponse.Builder, DescribeComputationModelResponse> {
    private static final SdkField<String> COMPUTATION_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computationModelId").getter(getter(DescribeComputationModelResponse::computationModelId))
            .setter(setter(Builder::computationModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelId").build())
            .build();

    private static final SdkField<String> COMPUTATION_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computationModelArn").getter(getter(DescribeComputationModelResponse::computationModelArn))
            .setter(setter(Builder::computationModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelArn").build())
            .build();

    private static final SdkField<String> COMPUTATION_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computationModelName").getter(getter(DescribeComputationModelResponse::computationModelName))
            .setter(setter(Builder::computationModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelName").build())
            .build();

    private static final SdkField<String> COMPUTATION_MODEL_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("computationModelDescription")
            .getter(getter(DescribeComputationModelResponse::computationModelDescription))
            .setter(setter(Builder::computationModelDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelDescription")
                    .build()).build();

    private static final SdkField<ComputationModelConfiguration> COMPUTATION_MODEL_CONFIGURATION_FIELD = SdkField
            .<ComputationModelConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("computationModelConfiguration")
            .getter(getter(DescribeComputationModelResponse::computationModelConfiguration))
            .setter(setter(Builder::computationModelConfiguration))
            .constructor(ComputationModelConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelConfiguration")
                    .build()).build();

    private static final SdkField<Map<String, ComputationModelDataBindingValue>> COMPUTATION_MODEL_DATA_BINDING_FIELD = SdkField
            .<Map<String, ComputationModelDataBindingValue>> builder(MarshallingType.MAP)
            .memberName("computationModelDataBinding")
            .getter(getter(DescribeComputationModelResponse::computationModelDataBinding))
            .setter(setter(Builder::computationModelDataBinding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelDataBinding")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ComputationModelDataBindingValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComputationModelDataBindingValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> COMPUTATION_MODEL_CREATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("computationModelCreationDate")
            .getter(getter(DescribeComputationModelResponse::computationModelCreationDate))
            .setter(setter(Builder::computationModelCreationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelCreationDate")
                    .build()).build();

    private static final SdkField<Instant> COMPUTATION_MODEL_LAST_UPDATE_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("computationModelLastUpdateDate")
            .getter(getter(DescribeComputationModelResponse::computationModelLastUpdateDate))
            .setter(setter(Builder::computationModelLastUpdateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelLastUpdateDate")
                    .build()).build();

    private static final SdkField<ComputationModelStatus> COMPUTATION_MODEL_STATUS_FIELD = SdkField
            .<ComputationModelStatus> builder(MarshallingType.SDK_POJO).memberName("computationModelStatus")
            .getter(getter(DescribeComputationModelResponse::computationModelStatus))
            .setter(setter(Builder::computationModelStatus)).constructor(ComputationModelStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelStatus").build())
            .build();

    private static final SdkField<String> COMPUTATION_MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computationModelVersion").getter(getter(DescribeComputationModelResponse::computationModelVersion))
            .setter(setter(Builder::computationModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelVersion").build())
            .build();

    private static final SdkField<List<ActionDefinition>> ACTION_DEFINITIONS_FIELD = SdkField
            .<List<ActionDefinition>> builder(MarshallingType.LIST)
            .memberName("actionDefinitions")
            .getter(getter(DescribeComputationModelResponse::actionDefinitions))
            .setter(setter(Builder::actionDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActionDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActionDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTATION_MODEL_ID_FIELD,
            COMPUTATION_MODEL_ARN_FIELD, COMPUTATION_MODEL_NAME_FIELD, COMPUTATION_MODEL_DESCRIPTION_FIELD,
            COMPUTATION_MODEL_CONFIGURATION_FIELD, COMPUTATION_MODEL_DATA_BINDING_FIELD, COMPUTATION_MODEL_CREATION_DATE_FIELD,
            COMPUTATION_MODEL_LAST_UPDATE_DATE_FIELD, COMPUTATION_MODEL_STATUS_FIELD, COMPUTATION_MODEL_VERSION_FIELD,
            ACTION_DEFINITIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String computationModelId;

    private final String computationModelArn;

    private final String computationModelName;

    private final String computationModelDescription;

    private final ComputationModelConfiguration computationModelConfiguration;

    private final Map<String, ComputationModelDataBindingValue> computationModelDataBinding;

    private final Instant computationModelCreationDate;

    private final Instant computationModelLastUpdateDate;

    private final ComputationModelStatus computationModelStatus;

    private final String computationModelVersion;

    private final List<ActionDefinition> actionDefinitions;

    private DescribeComputationModelResponse(BuilderImpl builder) {
        super(builder);
        this.computationModelId = builder.computationModelId;
        this.computationModelArn = builder.computationModelArn;
        this.computationModelName = builder.computationModelName;
        this.computationModelDescription = builder.computationModelDescription;
        this.computationModelConfiguration = builder.computationModelConfiguration;
        this.computationModelDataBinding = builder.computationModelDataBinding;
        this.computationModelCreationDate = builder.computationModelCreationDate;
        this.computationModelLastUpdateDate = builder.computationModelLastUpdateDate;
        this.computationModelStatus = builder.computationModelStatus;
        this.computationModelVersion = builder.computationModelVersion;
        this.actionDefinitions = builder.actionDefinitions;
    }

    /**
     * <p>
     * The ID of the computation model.
     * </p>
     * 
     * @return The ID of the computation model.
     */
    public final String computationModelId() {
        return computationModelId;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     * computation model, which has the following format.
     * </p>
     * <p>
     * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:computation-model/${ComputationModelId}</code>
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         computation model, which has the following format.</p>
     *         <p>
     *         <code>arn:${Partition}:iotsitewise:${Region}:${Account}:computation-model/${ComputationModelId}</code>
     */
    public final String computationModelArn() {
        return computationModelArn;
    }

    /**
     * <p>
     * The name of the computation model.
     * </p>
     * 
     * @return The name of the computation model.
     */
    public final String computationModelName() {
        return computationModelName;
    }

    /**
     * <p>
     * The description of the computation model.
     * </p>
     * 
     * @return The description of the computation model.
     */
    public final String computationModelDescription() {
        return computationModelDescription;
    }

    /**
     * <p>
     * The configuration for the computation model.
     * </p>
     * 
     * @return The configuration for the computation model.
     */
    public final ComputationModelConfiguration computationModelConfiguration() {
        return computationModelConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComputationModelDataBinding property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasComputationModelDataBinding() {
        return computationModelDataBinding != null && !(computationModelDataBinding instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The data binding for the computation model. Key is a variable name defined in configuration. Value is a
     * <code>ComputationModelDataBindingValue</code> referenced by the variable.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComputationModelDataBinding} method.
     * </p>
     * 
     * @return The data binding for the computation model. Key is a variable name defined in configuration. Value is a
     *         <code>ComputationModelDataBindingValue</code> referenced by the variable.
     */
    public final Map<String, ComputationModelDataBindingValue> computationModelDataBinding() {
        return computationModelDataBinding;
    }

    /**
     * <p>
     * The model creation date, in Unix epoch time.
     * </p>
     * 
     * @return The model creation date, in Unix epoch time.
     */
    public final Instant computationModelCreationDate() {
        return computationModelCreationDate;
    }

    /**
     * <p>
     * The date the model was last updated, in Unix epoch time.
     * </p>
     * 
     * @return The date the model was last updated, in Unix epoch time.
     */
    public final Instant computationModelLastUpdateDate() {
        return computationModelLastUpdateDate;
    }

    /**
     * <p>
     * The current status of the asset model, which contains a state and an error message if any.
     * </p>
     * 
     * @return The current status of the asset model, which contains a state and an error message if any.
     */
    public final ComputationModelStatus computationModelStatus() {
        return computationModelStatus;
    }

    /**
     * <p>
     * The version of the computation model.
     * </p>
     * 
     * @return The version of the computation model.
     */
    public final String computationModelVersion() {
        return computationModelVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActionDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasActionDefinitions() {
        return actionDefinitions != null && !(actionDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The available actions for this computation model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActionDefinitions} method.
     * </p>
     * 
     * @return The available actions for this computation model.
     */
    public final List<ActionDefinition> actionDefinitions() {
        return actionDefinitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(computationModelId());
        hashCode = 31 * hashCode + Objects.hashCode(computationModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(computationModelName());
        hashCode = 31 * hashCode + Objects.hashCode(computationModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(computationModelConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasComputationModelDataBinding() ? computationModelDataBinding() : null);
        hashCode = 31 * hashCode + Objects.hashCode(computationModelCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(computationModelLastUpdateDate());
        hashCode = 31 * hashCode + Objects.hashCode(computationModelStatus());
        hashCode = 31 * hashCode + Objects.hashCode(computationModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasActionDefinitions() ? actionDefinitions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComputationModelResponse)) {
            return false;
        }
        DescribeComputationModelResponse other = (DescribeComputationModelResponse) obj;
        return Objects.equals(computationModelId(), other.computationModelId())
                && Objects.equals(computationModelArn(), other.computationModelArn())
                && Objects.equals(computationModelName(), other.computationModelName())
                && Objects.equals(computationModelDescription(), other.computationModelDescription())
                && Objects.equals(computationModelConfiguration(), other.computationModelConfiguration())
                && hasComputationModelDataBinding() == other.hasComputationModelDataBinding()
                && Objects.equals(computationModelDataBinding(), other.computationModelDataBinding())
                && Objects.equals(computationModelCreationDate(), other.computationModelCreationDate())
                && Objects.equals(computationModelLastUpdateDate(), other.computationModelLastUpdateDate())
                && Objects.equals(computationModelStatus(), other.computationModelStatus())
                && Objects.equals(computationModelVersion(), other.computationModelVersion())
                && hasActionDefinitions() == other.hasActionDefinitions()
                && Objects.equals(actionDefinitions(), other.actionDefinitions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeComputationModelResponse").add("ComputationModelId", computationModelId())
                .add("ComputationModelArn", computationModelArn()).add("ComputationModelName", computationModelName())
                .add("ComputationModelDescription", computationModelDescription())
                .add("ComputationModelConfiguration", computationModelConfiguration())
                .add("ComputationModelDataBinding", hasComputationModelDataBinding() ? computationModelDataBinding() : null)
                .add("ComputationModelCreationDate", computationModelCreationDate())
                .add("ComputationModelLastUpdateDate", computationModelLastUpdateDate())
                .add("ComputationModelStatus", computationModelStatus())
                .add("ComputationModelVersion", computationModelVersion())
                .add("ActionDefinitions", hasActionDefinitions() ? actionDefinitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "computationModelId":
            return Optional.ofNullable(clazz.cast(computationModelId()));
        case "computationModelArn":
            return Optional.ofNullable(clazz.cast(computationModelArn()));
        case "computationModelName":
            return Optional.ofNullable(clazz.cast(computationModelName()));
        case "computationModelDescription":
            return Optional.ofNullable(clazz.cast(computationModelDescription()));
        case "computationModelConfiguration":
            return Optional.ofNullable(clazz.cast(computationModelConfiguration()));
        case "computationModelDataBinding":
            return Optional.ofNullable(clazz.cast(computationModelDataBinding()));
        case "computationModelCreationDate":
            return Optional.ofNullable(clazz.cast(computationModelCreationDate()));
        case "computationModelLastUpdateDate":
            return Optional.ofNullable(clazz.cast(computationModelLastUpdateDate()));
        case "computationModelStatus":
            return Optional.ofNullable(clazz.cast(computationModelStatus()));
        case "computationModelVersion":
            return Optional.ofNullable(clazz.cast(computationModelVersion()));
        case "actionDefinitions":
            return Optional.ofNullable(clazz.cast(actionDefinitions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("computationModelId", COMPUTATION_MODEL_ID_FIELD);
        map.put("computationModelArn", COMPUTATION_MODEL_ARN_FIELD);
        map.put("computationModelName", COMPUTATION_MODEL_NAME_FIELD);
        map.put("computationModelDescription", COMPUTATION_MODEL_DESCRIPTION_FIELD);
        map.put("computationModelConfiguration", COMPUTATION_MODEL_CONFIGURATION_FIELD);
        map.put("computationModelDataBinding", COMPUTATION_MODEL_DATA_BINDING_FIELD);
        map.put("computationModelCreationDate", COMPUTATION_MODEL_CREATION_DATE_FIELD);
        map.put("computationModelLastUpdateDate", COMPUTATION_MODEL_LAST_UPDATE_DATE_FIELD);
        map.put("computationModelStatus", COMPUTATION_MODEL_STATUS_FIELD);
        map.put("computationModelVersion", COMPUTATION_MODEL_VERSION_FIELD);
        map.put("actionDefinitions", ACTION_DEFINITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeComputationModelResponse, T> g) {
        return obj -> g.apply((DescribeComputationModelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeComputationModelResponse> {
        /**
         * <p>
         * The ID of the computation model.
         * </p>
         * 
         * @param computationModelId
         *        The ID of the computation model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationModelId(String computationModelId);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
         * computation model, which has the following format.
         * </p>
         * <p>
         * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:computation-model/${ComputationModelId}</code>
         * </p>
         * 
         * @param computationModelArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the computation model, which has the following format.</p>
         *        <p>
         *        <code>arn:${Partition}:iotsitewise:${Region}:${Account}:computation-model/${ComputationModelId}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationModelArn(String computationModelArn);

        /**
         * <p>
         * The name of the computation model.
         * </p>
         * 
         * @param computationModelName
         *        The name of the computation model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationModelName(String computationModelName);

        /**
         * <p>
         * The description of the computation model.
         * </p>
         * 
         * @param computationModelDescription
         *        The description of the computation model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationModelDescription(String computationModelDescription);

        /**
         * <p>
         * The configuration for the computation model.
         * </p>
         * 
         * @param computationModelConfiguration
         *        The configuration for the computation model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationModelConfiguration(ComputationModelConfiguration computationModelConfiguration);

        /**
         * <p>
         * The configuration for the computation model.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComputationModelConfiguration.Builder}
         * avoiding the need to create one manually via {@link ComputationModelConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputationModelConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #computationModelConfiguration(ComputationModelConfiguration)}.
         * 
         * @param computationModelConfiguration
         *        a consumer that will call methods on {@link ComputationModelConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computationModelConfiguration(ComputationModelConfiguration)
         */
        default Builder computationModelConfiguration(
                Consumer<ComputationModelConfiguration.Builder> computationModelConfiguration) {
            return computationModelConfiguration(ComputationModelConfiguration.builder()
                    .applyMutation(computationModelConfiguration).build());
        }

        /**
         * <p>
         * The data binding for the computation model. Key is a variable name defined in configuration. Value is a
         * <code>ComputationModelDataBindingValue</code> referenced by the variable.
         * </p>
         * 
         * @param computationModelDataBinding
         *        The data binding for the computation model. Key is a variable name defined in configuration. Value is
         *        a <code>ComputationModelDataBindingValue</code> referenced by the variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationModelDataBinding(Map<String, ComputationModelDataBindingValue> computationModelDataBinding);

        /**
         * <p>
         * The model creation date, in Unix epoch time.
         * </p>
         * 
         * @param computationModelCreationDate
         *        The model creation date, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationModelCreationDate(Instant computationModelCreationDate);

        /**
         * <p>
         * The date the model was last updated, in Unix epoch time.
         * </p>
         * 
         * @param computationModelLastUpdateDate
         *        The date the model was last updated, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationModelLastUpdateDate(Instant computationModelLastUpdateDate);

        /**
         * <p>
         * The current status of the asset model, which contains a state and an error message if any.
         * </p>
         * 
         * @param computationModelStatus
         *        The current status of the asset model, which contains a state and an error message if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationModelStatus(ComputationModelStatus computationModelStatus);

        /**
         * <p>
         * The current status of the asset model, which contains a state and an error message if any.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComputationModelStatus.Builder} avoiding
         * the need to create one manually via {@link ComputationModelStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputationModelStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #computationModelStatus(ComputationModelStatus)}.
         * 
         * @param computationModelStatus
         *        a consumer that will call methods on {@link ComputationModelStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computationModelStatus(ComputationModelStatus)
         */
        default Builder computationModelStatus(Consumer<ComputationModelStatus.Builder> computationModelStatus) {
            return computationModelStatus(ComputationModelStatus.builder().applyMutation(computationModelStatus).build());
        }

        /**
         * <p>
         * The version of the computation model.
         * </p>
         * 
         * @param computationModelVersion
         *        The version of the computation model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationModelVersion(String computationModelVersion);

        /**
         * <p>
         * The available actions for this computation model.
         * </p>
         * 
         * @param actionDefinitions
         *        The available actions for this computation model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionDefinitions(Collection<ActionDefinition> actionDefinitions);

        /**
         * <p>
         * The available actions for this computation model.
         * </p>
         * 
         * @param actionDefinitions
         *        The available actions for this computation model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionDefinitions(ActionDefinition... actionDefinitions);

        /**
         * <p>
         * The available actions for this computation model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.ActionDefinition.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.iotsitewise.model.ActionDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.ActionDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #actionDefinitions(List<ActionDefinition>)}.
         * 
         * @param actionDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.ActionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionDefinitions(java.util.Collection<ActionDefinition>)
         */
        Builder actionDefinitions(Consumer<ActionDefinition.Builder>... actionDefinitions);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private String computationModelId;

        private String computationModelArn;

        private String computationModelName;

        private String computationModelDescription;

        private ComputationModelConfiguration computationModelConfiguration;

        private Map<String, ComputationModelDataBindingValue> computationModelDataBinding = DefaultSdkAutoConstructMap
                .getInstance();

        private Instant computationModelCreationDate;

        private Instant computationModelLastUpdateDate;

        private ComputationModelStatus computationModelStatus;

        private String computationModelVersion;

        private List<ActionDefinition> actionDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComputationModelResponse model) {
            super(model);
            computationModelId(model.computationModelId);
            computationModelArn(model.computationModelArn);
            computationModelName(model.computationModelName);
            computationModelDescription(model.computationModelDescription);
            computationModelConfiguration(model.computationModelConfiguration);
            computationModelDataBinding(model.computationModelDataBinding);
            computationModelCreationDate(model.computationModelCreationDate);
            computationModelLastUpdateDate(model.computationModelLastUpdateDate);
            computationModelStatus(model.computationModelStatus);
            computationModelVersion(model.computationModelVersion);
            actionDefinitions(model.actionDefinitions);
        }

        public final String getComputationModelId() {
            return computationModelId;
        }

        public final void setComputationModelId(String computationModelId) {
            this.computationModelId = computationModelId;
        }

        @Override
        public final Builder computationModelId(String computationModelId) {
            this.computationModelId = computationModelId;
            return this;
        }

        public final String getComputationModelArn() {
            return computationModelArn;
        }

        public final void setComputationModelArn(String computationModelArn) {
            this.computationModelArn = computationModelArn;
        }

        @Override
        public final Builder computationModelArn(String computationModelArn) {
            this.computationModelArn = computationModelArn;
            return this;
        }

        public final String getComputationModelName() {
            return computationModelName;
        }

        public final void setComputationModelName(String computationModelName) {
            this.computationModelName = computationModelName;
        }

        @Override
        public final Builder computationModelName(String computationModelName) {
            this.computationModelName = computationModelName;
            return this;
        }

        public final String getComputationModelDescription() {
            return computationModelDescription;
        }

        public final void setComputationModelDescription(String computationModelDescription) {
            this.computationModelDescription = computationModelDescription;
        }

        @Override
        public final Builder computationModelDescription(String computationModelDescription) {
            this.computationModelDescription = computationModelDescription;
            return this;
        }

        public final ComputationModelConfiguration.Builder getComputationModelConfiguration() {
            return computationModelConfiguration != null ? computationModelConfiguration.toBuilder() : null;
        }

        public final void setComputationModelConfiguration(ComputationModelConfiguration.BuilderImpl computationModelConfiguration) {
            this.computationModelConfiguration = computationModelConfiguration != null ? computationModelConfiguration.build()
                    : null;
        }

        @Override
        public final Builder computationModelConfiguration(ComputationModelConfiguration computationModelConfiguration) {
            this.computationModelConfiguration = computationModelConfiguration;
            return this;
        }

        public final Map<String, ComputationModelDataBindingValue.Builder> getComputationModelDataBinding() {
            Map<String, ComputationModelDataBindingValue.Builder> result = ComputationModelDataBindingCopier
                    .copyToBuilder(this.computationModelDataBinding);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setComputationModelDataBinding(
                Map<String, ComputationModelDataBindingValue.BuilderImpl> computationModelDataBinding) {
            this.computationModelDataBinding = ComputationModelDataBindingCopier.copyFromBuilder(computationModelDataBinding);
        }

        @Override
        public final Builder computationModelDataBinding(Map<String, ComputationModelDataBindingValue> computationModelDataBinding) {
            this.computationModelDataBinding = ComputationModelDataBindingCopier.copy(computationModelDataBinding);
            return this;
        }

        public final Instant getComputationModelCreationDate() {
            return computationModelCreationDate;
        }

        public final void setComputationModelCreationDate(Instant computationModelCreationDate) {
            this.computationModelCreationDate = computationModelCreationDate;
        }

        @Override
        public final Builder computationModelCreationDate(Instant computationModelCreationDate) {
            this.computationModelCreationDate = computationModelCreationDate;
            return this;
        }

        public final Instant getComputationModelLastUpdateDate() {
            return computationModelLastUpdateDate;
        }

        public final void setComputationModelLastUpdateDate(Instant computationModelLastUpdateDate) {
            this.computationModelLastUpdateDate = computationModelLastUpdateDate;
        }

        @Override
        public final Builder computationModelLastUpdateDate(Instant computationModelLastUpdateDate) {
            this.computationModelLastUpdateDate = computationModelLastUpdateDate;
            return this;
        }

        public final ComputationModelStatus.Builder getComputationModelStatus() {
            return computationModelStatus != null ? computationModelStatus.toBuilder() : null;
        }

        public final void setComputationModelStatus(ComputationModelStatus.BuilderImpl computationModelStatus) {
            this.computationModelStatus = computationModelStatus != null ? computationModelStatus.build() : null;
        }

        @Override
        public final Builder computationModelStatus(ComputationModelStatus computationModelStatus) {
            this.computationModelStatus = computationModelStatus;
            return this;
        }

        public final String getComputationModelVersion() {
            return computationModelVersion;
        }

        public final void setComputationModelVersion(String computationModelVersion) {
            this.computationModelVersion = computationModelVersion;
        }

        @Override
        public final Builder computationModelVersion(String computationModelVersion) {
            this.computationModelVersion = computationModelVersion;
            return this;
        }

        public final List<ActionDefinition.Builder> getActionDefinitions() {
            List<ActionDefinition.Builder> result = ActionDefinitionsCopier.copyToBuilder(this.actionDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionDefinitions(Collection<ActionDefinition.BuilderImpl> actionDefinitions) {
            this.actionDefinitions = ActionDefinitionsCopier.copyFromBuilder(actionDefinitions);
        }

        @Override
        public final Builder actionDefinitions(Collection<ActionDefinition> actionDefinitions) {
            this.actionDefinitions = ActionDefinitionsCopier.copy(actionDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionDefinitions(ActionDefinition... actionDefinitions) {
            actionDefinitions(Arrays.asList(actionDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionDefinitions(Consumer<ActionDefinition.Builder>... actionDefinitions) {
            actionDefinitions(Stream.of(actionDefinitions).map(c -> ActionDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeComputationModelResponse build() {
            return new DescribeComputationModelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
