/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAssetResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<DescribeAssetResponse.Builder, DescribeAssetResponse> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetId").getter(getter(DescribeAssetResponse::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()).build();

    private static final SdkField<String> ASSET_EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetExternalId").getter(getter(DescribeAssetResponse::assetExternalId))
            .setter(setter(Builder::assetExternalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetExternalId").build()).build();

    private static final SdkField<String> ASSET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetArn").getter(getter(DescribeAssetResponse::assetArn)).setter(setter(Builder::assetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetArn").build()).build();

    private static final SdkField<String> ASSET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetName").getter(getter(DescribeAssetResponse::assetName)).setter(setter(Builder::assetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetName").build()).build();

    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelId").getter(getter(DescribeAssetResponse::assetModelId)).setter(setter(Builder::assetModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelId").build()).build();

    private static final SdkField<List<AssetProperty>> ASSET_PROPERTIES_FIELD = SdkField
            .<List<AssetProperty>> builder(MarshallingType.LIST)
            .memberName("assetProperties")
            .getter(getter(DescribeAssetResponse::assetProperties))
            .setter(setter(Builder::assetProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetHierarchy>> ASSET_HIERARCHIES_FIELD = SdkField
            .<List<AssetHierarchy>> builder(MarshallingType.LIST)
            .memberName("assetHierarchies")
            .getter(getter(DescribeAssetResponse::assetHierarchies))
            .setter(setter(Builder::assetHierarchies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetHierarchies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetHierarchy> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetHierarchy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetCompositeModel>> ASSET_COMPOSITE_MODELS_FIELD = SdkField
            .<List<AssetCompositeModel>> builder(MarshallingType.LIST)
            .memberName("assetCompositeModels")
            .getter(getter(DescribeAssetResponse::assetCompositeModels))
            .setter(setter(Builder::assetCompositeModels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetCompositeModels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetCompositeModel> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetCompositeModel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> ASSET_CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("assetCreationDate").getter(getter(DescribeAssetResponse::assetCreationDate))
            .setter(setter(Builder::assetCreationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetCreationDate").build()).build();

    private static final SdkField<Instant> ASSET_LAST_UPDATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("assetLastUpdateDate").getter(getter(DescribeAssetResponse::assetLastUpdateDate))
            .setter(setter(Builder::assetLastUpdateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetLastUpdateDate").build())
            .build();

    private static final SdkField<AssetStatus> ASSET_STATUS_FIELD = SdkField.<AssetStatus> builder(MarshallingType.SDK_POJO)
            .memberName("assetStatus").getter(getter(DescribeAssetResponse::assetStatus)).setter(setter(Builder::assetStatus))
            .constructor(AssetStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetStatus").build()).build();

    private static final SdkField<String> ASSET_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetDescription").getter(getter(DescribeAssetResponse::assetDescription))
            .setter(setter(Builder::assetDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetDescription").build()).build();

    private static final SdkField<List<AssetCompositeModelSummary>> ASSET_COMPOSITE_MODEL_SUMMARIES_FIELD = SdkField
            .<List<AssetCompositeModelSummary>> builder(MarshallingType.LIST)
            .memberName("assetCompositeModelSummaries")
            .getter(getter(DescribeAssetResponse::assetCompositeModelSummaries))
            .setter(setter(Builder::assetCompositeModelSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetCompositeModelSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetCompositeModelSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetCompositeModelSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD,
            ASSET_EXTERNAL_ID_FIELD, ASSET_ARN_FIELD, ASSET_NAME_FIELD, ASSET_MODEL_ID_FIELD, ASSET_PROPERTIES_FIELD,
            ASSET_HIERARCHIES_FIELD, ASSET_COMPOSITE_MODELS_FIELD, ASSET_CREATION_DATE_FIELD, ASSET_LAST_UPDATE_DATE_FIELD,
            ASSET_STATUS_FIELD, ASSET_DESCRIPTION_FIELD, ASSET_COMPOSITE_MODEL_SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String assetId;

    private final String assetExternalId;

    private final String assetArn;

    private final String assetName;

    private final String assetModelId;

    private final List<AssetProperty> assetProperties;

    private final List<AssetHierarchy> assetHierarchies;

    private final List<AssetCompositeModel> assetCompositeModels;

    private final Instant assetCreationDate;

    private final Instant assetLastUpdateDate;

    private final AssetStatus assetStatus;

    private final String assetDescription;

    private final List<AssetCompositeModelSummary> assetCompositeModelSummaries;

    private DescribeAssetResponse(BuilderImpl builder) {
        super(builder);
        this.assetId = builder.assetId;
        this.assetExternalId = builder.assetExternalId;
        this.assetArn = builder.assetArn;
        this.assetName = builder.assetName;
        this.assetModelId = builder.assetModelId;
        this.assetProperties = builder.assetProperties;
        this.assetHierarchies = builder.assetHierarchies;
        this.assetCompositeModels = builder.assetCompositeModels;
        this.assetCreationDate = builder.assetCreationDate;
        this.assetLastUpdateDate = builder.assetLastUpdateDate;
        this.assetStatus = builder.assetStatus;
        this.assetDescription = builder.assetDescription;
        this.assetCompositeModelSummaries = builder.assetCompositeModelSummaries;
    }

    /**
     * <p>
     * The ID of the asset, in UUID format.
     * </p>
     * 
     * @return The ID of the asset, in UUID format.
     */
    public final String assetId() {
        return assetId;
    }

    /**
     * <p>
     * The external ID of the asset, if any.
     * </p>
     * 
     * @return The external ID of the asset, if any.
     */
    public final String assetExternalId() {
        return assetExternalId;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset,
     * which has the following format.
     * </p>
     * <p>
     * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code>
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         asset, which has the following format.</p>
     *         <p>
     *         <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code>
     */
    public final String assetArn() {
        return assetArn;
    }

    /**
     * <p>
     * The name of the asset.
     * </p>
     * 
     * @return The name of the asset.
     */
    public final String assetName() {
        return assetName;
    }

    /**
     * <p>
     * The ID of the asset model that was used to create the asset.
     * </p>
     * 
     * @return The ID of the asset model that was used to create the asset.
     */
    public final String assetModelId() {
        return assetModelId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssetProperties() {
        return assetProperties != null && !(assetProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of asset properties for the asset.
     * </p>
     * <p>
     * This object doesn't include properties that you define in composite models. You can find composite model
     * properties in the <code>assetCompositeModels</code> object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetProperties} method.
     * </p>
     * 
     * @return The list of asset properties for the asset.</p>
     *         <p>
     *         This object doesn't include properties that you define in composite models. You can find composite model
     *         properties in the <code>assetCompositeModels</code> object.
     */
    public final List<AssetProperty> assetProperties() {
        return assetProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetHierarchies property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssetHierarchies() {
        return assetHierarchies != null && !(assetHierarchies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed
     * parent/child asset relationships.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetHierarchies} method.
     * </p>
     * 
     * @return A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed
     *         parent/child asset relationships.
     */
    public final List<AssetHierarchy> assetHierarchies() {
        return assetHierarchies;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetCompositeModels property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssetCompositeModels() {
        return assetCompositeModels != null && !(assetCompositeModels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The composite models for the asset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetCompositeModels} method.
     * </p>
     * 
     * @return The composite models for the asset.
     */
    public final List<AssetCompositeModel> assetCompositeModels() {
        return assetCompositeModels;
    }

    /**
     * <p>
     * The date the asset was created, in Unix epoch time.
     * </p>
     * 
     * @return The date the asset was created, in Unix epoch time.
     */
    public final Instant assetCreationDate() {
        return assetCreationDate;
    }

    /**
     * <p>
     * The date the asset was last updated, in Unix epoch time.
     * </p>
     * 
     * @return The date the asset was last updated, in Unix epoch time.
     */
    public final Instant assetLastUpdateDate() {
        return assetLastUpdateDate;
    }

    /**
     * <p>
     * The current status of the asset, which contains a state and any error message.
     * </p>
     * 
     * @return The current status of the asset, which contains a state and any error message.
     */
    public final AssetStatus assetStatus() {
        return assetStatus;
    }

    /**
     * <p>
     * A description for the asset.
     * </p>
     * 
     * @return A description for the asset.
     */
    public final String assetDescription() {
        return assetDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetCompositeModelSummaries property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssetCompositeModelSummaries() {
        return assetCompositeModelSummaries != null && !(assetCompositeModelSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of the immediate child custom composite model summaries for the asset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetCompositeModelSummaries} method.
     * </p>
     * 
     * @return The list of the immediate child custom composite model summaries for the asset.
     */
    public final List<AssetCompositeModelSummary> assetCompositeModelSummaries() {
        return assetCompositeModelSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(assetExternalId());
        hashCode = 31 * hashCode + Objects.hashCode(assetArn());
        hashCode = 31 * hashCode + Objects.hashCode(assetName());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetProperties() ? assetProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetHierarchies() ? assetHierarchies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetCompositeModels() ? assetCompositeModels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(assetCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(assetLastUpdateDate());
        hashCode = 31 * hashCode + Objects.hashCode(assetStatus());
        hashCode = 31 * hashCode + Objects.hashCode(assetDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetCompositeModelSummaries() ? assetCompositeModelSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssetResponse)) {
            return false;
        }
        DescribeAssetResponse other = (DescribeAssetResponse) obj;
        return Objects.equals(assetId(), other.assetId()) && Objects.equals(assetExternalId(), other.assetExternalId())
                && Objects.equals(assetArn(), other.assetArn()) && Objects.equals(assetName(), other.assetName())
                && Objects.equals(assetModelId(), other.assetModelId()) && hasAssetProperties() == other.hasAssetProperties()
                && Objects.equals(assetProperties(), other.assetProperties())
                && hasAssetHierarchies() == other.hasAssetHierarchies()
                && Objects.equals(assetHierarchies(), other.assetHierarchies())
                && hasAssetCompositeModels() == other.hasAssetCompositeModels()
                && Objects.equals(assetCompositeModels(), other.assetCompositeModels())
                && Objects.equals(assetCreationDate(), other.assetCreationDate())
                && Objects.equals(assetLastUpdateDate(), other.assetLastUpdateDate())
                && Objects.equals(assetStatus(), other.assetStatus())
                && Objects.equals(assetDescription(), other.assetDescription())
                && hasAssetCompositeModelSummaries() == other.hasAssetCompositeModelSummaries()
                && Objects.equals(assetCompositeModelSummaries(), other.assetCompositeModelSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAssetResponse").add("AssetId", assetId()).add("AssetExternalId", assetExternalId())
                .add("AssetArn", assetArn()).add("AssetName", assetName()).add("AssetModelId", assetModelId())
                .add("AssetProperties", hasAssetProperties() ? assetProperties() : null)
                .add("AssetHierarchies", hasAssetHierarchies() ? assetHierarchies() : null)
                .add("AssetCompositeModels", hasAssetCompositeModels() ? assetCompositeModels() : null)
                .add("AssetCreationDate", assetCreationDate()).add("AssetLastUpdateDate", assetLastUpdateDate())
                .add("AssetStatus", assetStatus()).add("AssetDescription", assetDescription())
                .add("AssetCompositeModelSummaries", hasAssetCompositeModelSummaries() ? assetCompositeModelSummaries() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "assetExternalId":
            return Optional.ofNullable(clazz.cast(assetExternalId()));
        case "assetArn":
            return Optional.ofNullable(clazz.cast(assetArn()));
        case "assetName":
            return Optional.ofNullable(clazz.cast(assetName()));
        case "assetModelId":
            return Optional.ofNullable(clazz.cast(assetModelId()));
        case "assetProperties":
            return Optional.ofNullable(clazz.cast(assetProperties()));
        case "assetHierarchies":
            return Optional.ofNullable(clazz.cast(assetHierarchies()));
        case "assetCompositeModels":
            return Optional.ofNullable(clazz.cast(assetCompositeModels()));
        case "assetCreationDate":
            return Optional.ofNullable(clazz.cast(assetCreationDate()));
        case "assetLastUpdateDate":
            return Optional.ofNullable(clazz.cast(assetLastUpdateDate()));
        case "assetStatus":
            return Optional.ofNullable(clazz.cast(assetStatus()));
        case "assetDescription":
            return Optional.ofNullable(clazz.cast(assetDescription()));
        case "assetCompositeModelSummaries":
            return Optional.ofNullable(clazz.cast(assetCompositeModelSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assetId", ASSET_ID_FIELD);
        map.put("assetExternalId", ASSET_EXTERNAL_ID_FIELD);
        map.put("assetArn", ASSET_ARN_FIELD);
        map.put("assetName", ASSET_NAME_FIELD);
        map.put("assetModelId", ASSET_MODEL_ID_FIELD);
        map.put("assetProperties", ASSET_PROPERTIES_FIELD);
        map.put("assetHierarchies", ASSET_HIERARCHIES_FIELD);
        map.put("assetCompositeModels", ASSET_COMPOSITE_MODELS_FIELD);
        map.put("assetCreationDate", ASSET_CREATION_DATE_FIELD);
        map.put("assetLastUpdateDate", ASSET_LAST_UPDATE_DATE_FIELD);
        map.put("assetStatus", ASSET_STATUS_FIELD);
        map.put("assetDescription", ASSET_DESCRIPTION_FIELD);
        map.put("assetCompositeModelSummaries", ASSET_COMPOSITE_MODEL_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssetResponse, T> g) {
        return obj -> g.apply((DescribeAssetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAssetResponse> {
        /**
         * <p>
         * The ID of the asset, in UUID format.
         * </p>
         * 
         * @param assetId
         *        The ID of the asset, in UUID format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * The external ID of the asset, if any.
         * </p>
         * 
         * @param assetExternalId
         *        The external ID of the asset, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetExternalId(String assetExternalId);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
         * asset, which has the following format.
         * </p>
         * <p>
         * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code>
         * </p>
         * 
         * @param assetArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the asset, which has the following format.</p>
         *        <p>
         *        <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetArn(String assetArn);

        /**
         * <p>
         * The name of the asset.
         * </p>
         * 
         * @param assetName
         *        The name of the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetName(String assetName);

        /**
         * <p>
         * The ID of the asset model that was used to create the asset.
         * </p>
         * 
         * @param assetModelId
         *        The ID of the asset model that was used to create the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelId(String assetModelId);

        /**
         * <p>
         * The list of asset properties for the asset.
         * </p>
         * <p>
         * This object doesn't include properties that you define in composite models. You can find composite model
         * properties in the <code>assetCompositeModels</code> object.
         * </p>
         * 
         * @param assetProperties
         *        The list of asset properties for the asset.</p>
         *        <p>
         *        This object doesn't include properties that you define in composite models. You can find composite
         *        model properties in the <code>assetCompositeModels</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetProperties(Collection<AssetProperty> assetProperties);

        /**
         * <p>
         * The list of asset properties for the asset.
         * </p>
         * <p>
         * This object doesn't include properties that you define in composite models. You can find composite model
         * properties in the <code>assetCompositeModels</code> object.
         * </p>
         * 
         * @param assetProperties
         *        The list of asset properties for the asset.</p>
         *        <p>
         *        This object doesn't include properties that you define in composite models. You can find composite
         *        model properties in the <code>assetCompositeModels</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetProperties(AssetProperty... assetProperties);

        /**
         * <p>
         * The list of asset properties for the asset.
         * </p>
         * <p>
         * This object doesn't include properties that you define in composite models. You can find composite model
         * properties in the <code>assetCompositeModels</code> object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetProperty.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iotsitewise.model.AssetProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetProperty.Builder#build()} is called immediately
         * and its result is passed to {@link #assetProperties(List<AssetProperty>)}.
         * 
         * @param assetProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.AssetProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetProperties(java.util.Collection<AssetProperty>)
         */
        Builder assetProperties(Consumer<AssetProperty.Builder>... assetProperties);

        /**
         * <p>
         * A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed
         * parent/child asset relationships.
         * </p>
         * 
         * @param assetHierarchies
         *        A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies
         *        allowed parent/child asset relationships.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetHierarchies(Collection<AssetHierarchy> assetHierarchies);

        /**
         * <p>
         * A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed
         * parent/child asset relationships.
         * </p>
         * 
         * @param assetHierarchies
         *        A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies
         *        allowed parent/child asset relationships.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetHierarchies(AssetHierarchy... assetHierarchies);

        /**
         * <p>
         * A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed
         * parent/child asset relationships.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetHierarchy.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iotsitewise.model.AssetHierarchy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetHierarchy.Builder#build()} is called
         * immediately and its result is passed to {@link #assetHierarchies(List<AssetHierarchy>)}.
         * 
         * @param assetHierarchies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.AssetHierarchy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetHierarchies(java.util.Collection<AssetHierarchy>)
         */
        Builder assetHierarchies(Consumer<AssetHierarchy.Builder>... assetHierarchies);

        /**
         * <p>
         * The composite models for the asset.
         * </p>
         * 
         * @param assetCompositeModels
         *        The composite models for the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetCompositeModels(Collection<AssetCompositeModel> assetCompositeModels);

        /**
         * <p>
         * The composite models for the asset.
         * </p>
         * 
         * @param assetCompositeModels
         *        The composite models for the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetCompositeModels(AssetCompositeModel... assetCompositeModels);

        /**
         * <p>
         * The composite models for the asset.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModel.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModel.Builder#build()} is called
         * immediately and its result is passed to {@link #assetCompositeModels(List<AssetCompositeModel>)}.
         * 
         * @param assetCompositeModels
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetCompositeModels(java.util.Collection<AssetCompositeModel>)
         */
        Builder assetCompositeModels(Consumer<AssetCompositeModel.Builder>... assetCompositeModels);

        /**
         * <p>
         * The date the asset was created, in Unix epoch time.
         * </p>
         * 
         * @param assetCreationDate
         *        The date the asset was created, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetCreationDate(Instant assetCreationDate);

        /**
         * <p>
         * The date the asset was last updated, in Unix epoch time.
         * </p>
         * 
         * @param assetLastUpdateDate
         *        The date the asset was last updated, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetLastUpdateDate(Instant assetLastUpdateDate);

        /**
         * <p>
         * The current status of the asset, which contains a state and any error message.
         * </p>
         * 
         * @param assetStatus
         *        The current status of the asset, which contains a state and any error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetStatus(AssetStatus assetStatus);

        /**
         * <p>
         * The current status of the asset, which contains a state and any error message.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssetStatus.Builder} avoiding the need to
         * create one manually via {@link AssetStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetStatus.Builder#build()} is called immediately and its result
         * is passed to {@link #assetStatus(AssetStatus)}.
         * 
         * @param assetStatus
         *        a consumer that will call methods on {@link AssetStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetStatus(AssetStatus)
         */
        default Builder assetStatus(Consumer<AssetStatus.Builder> assetStatus) {
            return assetStatus(AssetStatus.builder().applyMutation(assetStatus).build());
        }

        /**
         * <p>
         * A description for the asset.
         * </p>
         * 
         * @param assetDescription
         *        A description for the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetDescription(String assetDescription);

        /**
         * <p>
         * The list of the immediate child custom composite model summaries for the asset.
         * </p>
         * 
         * @param assetCompositeModelSummaries
         *        The list of the immediate child custom composite model summaries for the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetCompositeModelSummaries(Collection<AssetCompositeModelSummary> assetCompositeModelSummaries);

        /**
         * <p>
         * The list of the immediate child custom composite model summaries for the asset.
         * </p>
         * 
         * @param assetCompositeModelSummaries
         *        The list of the immediate child custom composite model summaries for the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetCompositeModelSummaries(AssetCompositeModelSummary... assetCompositeModelSummaries);

        /**
         * <p>
         * The list of the immediate child custom composite model summaries for the asset.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModelSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModelSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModelSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #assetCompositeModelSummaries(List<AssetCompositeModelSummary>)}.
         * 
         * @param assetCompositeModelSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModelSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetCompositeModelSummaries(java.util.Collection<AssetCompositeModelSummary>)
         */
        Builder assetCompositeModelSummaries(Consumer<AssetCompositeModelSummary.Builder>... assetCompositeModelSummaries);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private String assetId;

        private String assetExternalId;

        private String assetArn;

        private String assetName;

        private String assetModelId;

        private List<AssetProperty> assetProperties = DefaultSdkAutoConstructList.getInstance();

        private List<AssetHierarchy> assetHierarchies = DefaultSdkAutoConstructList.getInstance();

        private List<AssetCompositeModel> assetCompositeModels = DefaultSdkAutoConstructList.getInstance();

        private Instant assetCreationDate;

        private Instant assetLastUpdateDate;

        private AssetStatus assetStatus;

        private String assetDescription;

        private List<AssetCompositeModelSummary> assetCompositeModelSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssetResponse model) {
            super(model);
            assetId(model.assetId);
            assetExternalId(model.assetExternalId);
            assetArn(model.assetArn);
            assetName(model.assetName);
            assetModelId(model.assetModelId);
            assetProperties(model.assetProperties);
            assetHierarchies(model.assetHierarchies);
            assetCompositeModels(model.assetCompositeModels);
            assetCreationDate(model.assetCreationDate);
            assetLastUpdateDate(model.assetLastUpdateDate);
            assetStatus(model.assetStatus);
            assetDescription(model.assetDescription);
            assetCompositeModelSummaries(model.assetCompositeModelSummaries);
        }

        public final String getAssetId() {
            return assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getAssetExternalId() {
            return assetExternalId;
        }

        public final void setAssetExternalId(String assetExternalId) {
            this.assetExternalId = assetExternalId;
        }

        @Override
        public final Builder assetExternalId(String assetExternalId) {
            this.assetExternalId = assetExternalId;
            return this;
        }

        public final String getAssetArn() {
            return assetArn;
        }

        public final void setAssetArn(String assetArn) {
            this.assetArn = assetArn;
        }

        @Override
        public final Builder assetArn(String assetArn) {
            this.assetArn = assetArn;
            return this;
        }

        public final String getAssetName() {
            return assetName;
        }

        public final void setAssetName(String assetName) {
            this.assetName = assetName;
        }

        @Override
        public final Builder assetName(String assetName) {
            this.assetName = assetName;
            return this;
        }

        public final String getAssetModelId() {
            return assetModelId;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final List<AssetProperty.Builder> getAssetProperties() {
            List<AssetProperty.Builder> result = AssetPropertiesCopier.copyToBuilder(this.assetProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetProperties(Collection<AssetProperty.BuilderImpl> assetProperties) {
            this.assetProperties = AssetPropertiesCopier.copyFromBuilder(assetProperties);
        }

        @Override
        public final Builder assetProperties(Collection<AssetProperty> assetProperties) {
            this.assetProperties = AssetPropertiesCopier.copy(assetProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetProperties(AssetProperty... assetProperties) {
            assetProperties(Arrays.asList(assetProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetProperties(Consumer<AssetProperty.Builder>... assetProperties) {
            assetProperties(Stream.of(assetProperties).map(c -> AssetProperty.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AssetHierarchy.Builder> getAssetHierarchies() {
            List<AssetHierarchy.Builder> result = AssetHierarchiesCopier.copyToBuilder(this.assetHierarchies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetHierarchies(Collection<AssetHierarchy.BuilderImpl> assetHierarchies) {
            this.assetHierarchies = AssetHierarchiesCopier.copyFromBuilder(assetHierarchies);
        }

        @Override
        public final Builder assetHierarchies(Collection<AssetHierarchy> assetHierarchies) {
            this.assetHierarchies = AssetHierarchiesCopier.copy(assetHierarchies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetHierarchies(AssetHierarchy... assetHierarchies) {
            assetHierarchies(Arrays.asList(assetHierarchies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetHierarchies(Consumer<AssetHierarchy.Builder>... assetHierarchies) {
            assetHierarchies(Stream.of(assetHierarchies).map(c -> AssetHierarchy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AssetCompositeModel.Builder> getAssetCompositeModels() {
            List<AssetCompositeModel.Builder> result = AssetCompositeModelsCopier.copyToBuilder(this.assetCompositeModels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetCompositeModels(Collection<AssetCompositeModel.BuilderImpl> assetCompositeModels) {
            this.assetCompositeModels = AssetCompositeModelsCopier.copyFromBuilder(assetCompositeModels);
        }

        @Override
        public final Builder assetCompositeModels(Collection<AssetCompositeModel> assetCompositeModels) {
            this.assetCompositeModels = AssetCompositeModelsCopier.copy(assetCompositeModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetCompositeModels(AssetCompositeModel... assetCompositeModels) {
            assetCompositeModels(Arrays.asList(assetCompositeModels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetCompositeModels(Consumer<AssetCompositeModel.Builder>... assetCompositeModels) {
            assetCompositeModels(Stream.of(assetCompositeModels).map(c -> AssetCompositeModel.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getAssetCreationDate() {
            return assetCreationDate;
        }

        public final void setAssetCreationDate(Instant assetCreationDate) {
            this.assetCreationDate = assetCreationDate;
        }

        @Override
        public final Builder assetCreationDate(Instant assetCreationDate) {
            this.assetCreationDate = assetCreationDate;
            return this;
        }

        public final Instant getAssetLastUpdateDate() {
            return assetLastUpdateDate;
        }

        public final void setAssetLastUpdateDate(Instant assetLastUpdateDate) {
            this.assetLastUpdateDate = assetLastUpdateDate;
        }

        @Override
        public final Builder assetLastUpdateDate(Instant assetLastUpdateDate) {
            this.assetLastUpdateDate = assetLastUpdateDate;
            return this;
        }

        public final AssetStatus.Builder getAssetStatus() {
            return assetStatus != null ? assetStatus.toBuilder() : null;
        }

        public final void setAssetStatus(AssetStatus.BuilderImpl assetStatus) {
            this.assetStatus = assetStatus != null ? assetStatus.build() : null;
        }

        @Override
        public final Builder assetStatus(AssetStatus assetStatus) {
            this.assetStatus = assetStatus;
            return this;
        }

        public final String getAssetDescription() {
            return assetDescription;
        }

        public final void setAssetDescription(String assetDescription) {
            this.assetDescription = assetDescription;
        }

        @Override
        public final Builder assetDescription(String assetDescription) {
            this.assetDescription = assetDescription;
            return this;
        }

        public final List<AssetCompositeModelSummary.Builder> getAssetCompositeModelSummaries() {
            List<AssetCompositeModelSummary.Builder> result = AssetCompositeModelSummariesCopier
                    .copyToBuilder(this.assetCompositeModelSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetCompositeModelSummaries(
                Collection<AssetCompositeModelSummary.BuilderImpl> assetCompositeModelSummaries) {
            this.assetCompositeModelSummaries = AssetCompositeModelSummariesCopier.copyFromBuilder(assetCompositeModelSummaries);
        }

        @Override
        public final Builder assetCompositeModelSummaries(Collection<AssetCompositeModelSummary> assetCompositeModelSummaries) {
            this.assetCompositeModelSummaries = AssetCompositeModelSummariesCopier.copy(assetCompositeModelSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetCompositeModelSummaries(AssetCompositeModelSummary... assetCompositeModelSummaries) {
            assetCompositeModelSummaries(Arrays.asList(assetCompositeModelSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetCompositeModelSummaries(
                Consumer<AssetCompositeModelSummary.Builder>... assetCompositeModelSummaries) {
            assetCompositeModelSummaries(Stream.of(assetCompositeModelSummaries)
                    .map(c -> AssetCompositeModelSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeAssetResponse build() {
            return new DescribeAssetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
