/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAssetModelRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<DescribeAssetModelRequest.Builder, DescribeAssetModelRequest> {
    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelId").getter(getter(DescribeAssetModelRequest::assetModelId))
            .setter(setter(Builder::assetModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assetModelId").build()).build();

    private static final SdkField<Boolean> EXCLUDE_PROPERTIES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("excludeProperties").getter(getter(DescribeAssetModelRequest::excludeProperties))
            .setter(setter(Builder::excludeProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("excludeProperties").build())
            .build();

    private static final SdkField<String> ASSET_MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelVersion").getter(getter(DescribeAssetModelRequest::assetModelVersion))
            .setter(setter(Builder::assetModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("assetModelVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_ID_FIELD,
            EXCLUDE_PROPERTIES_FIELD, ASSET_MODEL_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String assetModelId;

    private final Boolean excludeProperties;

    private final String assetModelVersion;

    private DescribeAssetModelRequest(BuilderImpl builder) {
        super(builder);
        this.assetModelId = builder.assetModelId;
        this.excludeProperties = builder.excludeProperties;
        this.assetModelVersion = builder.assetModelVersion;
    }

    /**
     * <p>
     * The ID of the asset model. This can be either the actual ID in UUID format, or else <code>externalId:</code>
     * followed by the external ID, if it has one. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
     * >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The ID of the asset model. This can be either the actual ID in UUID format, or else
     *         <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
     *         >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String assetModelId() {
        return assetModelId;
    }

    /**
     * <p>
     * Whether or not to exclude asset model properties from the response.
     * </p>
     * 
     * @return Whether or not to exclude asset model properties from the response.
     */
    public final Boolean excludeProperties() {
        return excludeProperties;
    }

    /**
     * <p>
     * The version alias that specifies the latest or active version of the asset model. The details are returned in the
     * response. The default value is <code>LATEST</code>. See <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/model-active-version.html"> Asset model
     * versions</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The version alias that specifies the latest or active version of the asset model. The details are
     *         returned in the response. The default value is <code>LATEST</code>. See <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/model-active-version.html"> Asset model
     *         versions</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String assetModelVersion() {
        return assetModelVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(excludeProperties());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssetModelRequest)) {
            return false;
        }
        DescribeAssetModelRequest other = (DescribeAssetModelRequest) obj;
        return Objects.equals(assetModelId(), other.assetModelId())
                && Objects.equals(excludeProperties(), other.excludeProperties())
                && Objects.equals(assetModelVersion(), other.assetModelVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAssetModelRequest").add("AssetModelId", assetModelId())
                .add("ExcludeProperties", excludeProperties()).add("AssetModelVersion", assetModelVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetModelId":
            return Optional.ofNullable(clazz.cast(assetModelId()));
        case "excludeProperties":
            return Optional.ofNullable(clazz.cast(excludeProperties()));
        case "assetModelVersion":
            return Optional.ofNullable(clazz.cast(assetModelVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assetModelId", ASSET_MODEL_ID_FIELD);
        map.put("excludeProperties", EXCLUDE_PROPERTIES_FIELD);
        map.put("assetModelVersion", ASSET_MODEL_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssetModelRequest, T> g) {
        return obj -> g.apply((DescribeAssetModelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAssetModelRequest> {
        /**
         * <p>
         * The ID of the asset model. This can be either the actual ID in UUID format, or else <code>externalId:</code>
         * followed by the external ID, if it has one. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
         * >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param assetModelId
         *        The ID of the asset model. This can be either the actual ID in UUID format, or else
         *        <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
         *        >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelId(String assetModelId);

        /**
         * <p>
         * Whether or not to exclude asset model properties from the response.
         * </p>
         * 
         * @param excludeProperties
         *        Whether or not to exclude asset model properties from the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeProperties(Boolean excludeProperties);

        /**
         * <p>
         * The version alias that specifies the latest or active version of the asset model. The details are returned in
         * the response. The default value is <code>LATEST</code>. See <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/model-active-version.html"> Asset model
         * versions</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param assetModelVersion
         *        The version alias that specifies the latest or active version of the asset model. The details are
         *        returned in the response. The default value is <code>LATEST</code>. See <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/model-active-version.html"> Asset
         *        model versions</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelVersion(String assetModelVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String assetModelId;

        private Boolean excludeProperties;

        private String assetModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssetModelRequest model) {
            super(model);
            assetModelId(model.assetModelId);
            excludeProperties(model.excludeProperties);
            assetModelVersion(model.assetModelVersion);
        }

        public final String getAssetModelId() {
            return assetModelId;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final Boolean getExcludeProperties() {
            return excludeProperties;
        }

        public final void setExcludeProperties(Boolean excludeProperties) {
            this.excludeProperties = excludeProperties;
        }

        @Override
        public final Builder excludeProperties(Boolean excludeProperties) {
            this.excludeProperties = excludeProperties;
            return this;
        }

        public final String getAssetModelVersion() {
            return assetModelVersion;
        }

        public final void setAssetModelVersion(String assetModelVersion) {
            this.assetModelVersion = assetModelVersion;
        }

        @Override
        public final Builder assetModelVersion(String assetModelVersion) {
            this.assetModelVersion = assetModelVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAssetModelRequest build() {
            return new DescribeAssetModelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
