/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePortalResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<CreatePortalResponse.Builder, CreatePortalResponse> {
    private static final SdkField<String> PORTAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalId").getter(getter(CreatePortalResponse::portalId)).setter(setter(Builder::portalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalId").build()).build();

    private static final SdkField<String> PORTAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalArn").getter(getter(CreatePortalResponse::portalArn)).setter(setter(Builder::portalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalArn").build()).build();

    private static final SdkField<String> PORTAL_START_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalStartUrl").getter(getter(CreatePortalResponse::portalStartUrl))
            .setter(setter(Builder::portalStartUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalStartUrl").build()).build();

    private static final SdkField<PortalStatus> PORTAL_STATUS_FIELD = SdkField.<PortalStatus> builder(MarshallingType.SDK_POJO)
            .memberName("portalStatus").getter(getter(CreatePortalResponse::portalStatus)).setter(setter(Builder::portalStatus))
            .constructor(PortalStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalStatus").build()).build();

    private static final SdkField<String> SSO_APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ssoApplicationId").getter(getter(CreatePortalResponse::ssoApplicationId))
            .setter(setter(Builder::ssoApplicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssoApplicationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTAL_ID_FIELD,
            PORTAL_ARN_FIELD, PORTAL_START_URL_FIELD, PORTAL_STATUS_FIELD, SSO_APPLICATION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String portalId;

    private final String portalArn;

    private final String portalStartUrl;

    private final PortalStatus portalStatus;

    private final String ssoApplicationId;

    private CreatePortalResponse(BuilderImpl builder) {
        super(builder);
        this.portalId = builder.portalId;
        this.portalArn = builder.portalArn;
        this.portalStartUrl = builder.portalStartUrl;
        this.portalStatus = builder.portalStatus;
        this.ssoApplicationId = builder.ssoApplicationId;
    }

    /**
     * <p>
     * The ID of the created portal.
     * </p>
     * 
     * @return The ID of the created portal.
     */
    public final String portalId() {
        return portalId;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the portal,
     * which has the following format.
     * </p>
     * <p>
     * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}</code>
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         portal, which has the following format.</p>
     *         <p>
     *         <code>arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}</code>
     */
    public final String portalArn() {
        return portalArn;
    }

    /**
     * <p>
     * The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use IAM Identity Center
     * for authentication. For portals that use IAM for authentication, you must use the IoT SiteWise console to get a
     * URL that you can use to access the portal.
     * </p>
     * 
     * @return The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use IAM Identity
     *         Center for authentication. For portals that use IAM for authentication, you must use the IoT SiteWise
     *         console to get a URL that you can use to access the portal.
     */
    public final String portalStartUrl() {
        return portalStartUrl;
    }

    /**
     * <p>
     * The status of the portal, which contains a state (<code>CREATING</code> after successfully calling this
     * operation) and any error message.
     * </p>
     * 
     * @return The status of the portal, which contains a state (<code>CREATING</code> after successfully calling this
     *         operation) and any error message.
     */
    public final PortalStatus portalStatus() {
        return portalStatus;
    }

    /**
     * <p>
     * The associated IAM Identity Center application ID, if the portal uses IAM Identity Center.
     * </p>
     * 
     * @return The associated IAM Identity Center application ID, if the portal uses IAM Identity Center.
     */
    public final String ssoApplicationId() {
        return ssoApplicationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(portalId());
        hashCode = 31 * hashCode + Objects.hashCode(portalArn());
        hashCode = 31 * hashCode + Objects.hashCode(portalStartUrl());
        hashCode = 31 * hashCode + Objects.hashCode(portalStatus());
        hashCode = 31 * hashCode + Objects.hashCode(ssoApplicationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePortalResponse)) {
            return false;
        }
        CreatePortalResponse other = (CreatePortalResponse) obj;
        return Objects.equals(portalId(), other.portalId()) && Objects.equals(portalArn(), other.portalArn())
                && Objects.equals(portalStartUrl(), other.portalStartUrl())
                && Objects.equals(portalStatus(), other.portalStatus())
                && Objects.equals(ssoApplicationId(), other.ssoApplicationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePortalResponse").add("PortalId", portalId()).add("PortalArn", portalArn())
                .add("PortalStartUrl", portalStartUrl()).add("PortalStatus", portalStatus())
                .add("SsoApplicationId", ssoApplicationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "portalId":
            return Optional.ofNullable(clazz.cast(portalId()));
        case "portalArn":
            return Optional.ofNullable(clazz.cast(portalArn()));
        case "portalStartUrl":
            return Optional.ofNullable(clazz.cast(portalStartUrl()));
        case "portalStatus":
            return Optional.ofNullable(clazz.cast(portalStatus()));
        case "ssoApplicationId":
            return Optional.ofNullable(clazz.cast(ssoApplicationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("portalId", PORTAL_ID_FIELD);
        map.put("portalArn", PORTAL_ARN_FIELD);
        map.put("portalStartUrl", PORTAL_START_URL_FIELD);
        map.put("portalStatus", PORTAL_STATUS_FIELD);
        map.put("ssoApplicationId", SSO_APPLICATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePortalResponse, T> g) {
        return obj -> g.apply((CreatePortalResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreatePortalResponse> {
        /**
         * <p>
         * The ID of the created portal.
         * </p>
         * 
         * @param portalId
         *        The ID of the created portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalId(String portalId);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
         * portal, which has the following format.
         * </p>
         * <p>
         * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}</code>
         * </p>
         * 
         * @param portalArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the portal, which has the following format.</p>
         *        <p>
         *        <code>arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalArn(String portalArn);

        /**
         * <p>
         * The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use IAM Identity
         * Center for authentication. For portals that use IAM for authentication, you must use the IoT SiteWise console
         * to get a URL that you can use to access the portal.
         * </p>
         * 
         * @param portalStartUrl
         *        The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use IAM
         *        Identity Center for authentication. For portals that use IAM for authentication, you must use the IoT
         *        SiteWise console to get a URL that you can use to access the portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalStartUrl(String portalStartUrl);

        /**
         * <p>
         * The status of the portal, which contains a state (<code>CREATING</code> after successfully calling this
         * operation) and any error message.
         * </p>
         * 
         * @param portalStatus
         *        The status of the portal, which contains a state (<code>CREATING</code> after successfully calling
         *        this operation) and any error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalStatus(PortalStatus portalStatus);

        /**
         * <p>
         * The status of the portal, which contains a state (<code>CREATING</code> after successfully calling this
         * operation) and any error message.
         * </p>
         * This is a convenience method that creates an instance of the {@link PortalStatus.Builder} avoiding the need
         * to create one manually via {@link PortalStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PortalStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #portalStatus(PortalStatus)}.
         * 
         * @param portalStatus
         *        a consumer that will call methods on {@link PortalStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portalStatus(PortalStatus)
         */
        default Builder portalStatus(Consumer<PortalStatus.Builder> portalStatus) {
            return portalStatus(PortalStatus.builder().applyMutation(portalStatus).build());
        }

        /**
         * <p>
         * The associated IAM Identity Center application ID, if the portal uses IAM Identity Center.
         * </p>
         * 
         * @param ssoApplicationId
         *        The associated IAM Identity Center application ID, if the portal uses IAM Identity Center.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssoApplicationId(String ssoApplicationId);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private String portalId;

        private String portalArn;

        private String portalStartUrl;

        private PortalStatus portalStatus;

        private String ssoApplicationId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePortalResponse model) {
            super(model);
            portalId(model.portalId);
            portalArn(model.portalArn);
            portalStartUrl(model.portalStartUrl);
            portalStatus(model.portalStatus);
            ssoApplicationId(model.ssoApplicationId);
        }

        public final String getPortalId() {
            return portalId;
        }

        public final void setPortalId(String portalId) {
            this.portalId = portalId;
        }

        @Override
        public final Builder portalId(String portalId) {
            this.portalId = portalId;
            return this;
        }

        public final String getPortalArn() {
            return portalArn;
        }

        public final void setPortalArn(String portalArn) {
            this.portalArn = portalArn;
        }

        @Override
        public final Builder portalArn(String portalArn) {
            this.portalArn = portalArn;
            return this;
        }

        public final String getPortalStartUrl() {
            return portalStartUrl;
        }

        public final void setPortalStartUrl(String portalStartUrl) {
            this.portalStartUrl = portalStartUrl;
        }

        @Override
        public final Builder portalStartUrl(String portalStartUrl) {
            this.portalStartUrl = portalStartUrl;
            return this;
        }

        public final PortalStatus.Builder getPortalStatus() {
            return portalStatus != null ? portalStatus.toBuilder() : null;
        }

        public final void setPortalStatus(PortalStatus.BuilderImpl portalStatus) {
            this.portalStatus = portalStatus != null ? portalStatus.build() : null;
        }

        @Override
        public final Builder portalStatus(PortalStatus portalStatus) {
            this.portalStatus = portalStatus;
            return this;
        }

        public final String getSsoApplicationId() {
            return ssoApplicationId;
        }

        public final void setSsoApplicationId(String ssoApplicationId) {
            this.ssoApplicationId = ssoApplicationId;
        }

        @Override
        public final Builder ssoApplicationId(String ssoApplicationId) {
            this.ssoApplicationId = ssoApplicationId;
            return this;
        }

        @Override
        public CreatePortalResponse build() {
            return new CreatePortalResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
