/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAccessPolicyResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<CreateAccessPolicyResponse.Builder, CreateAccessPolicyResponse> {
    private static final SdkField<String> ACCESS_POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessPolicyId").getter(getter(CreateAccessPolicyResponse::accessPolicyId))
            .setter(setter(Builder::accessPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicyId").build()).build();

    private static final SdkField<String> ACCESS_POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessPolicyArn").getter(getter(CreateAccessPolicyResponse::accessPolicyArn))
            .setter(setter(Builder::accessPolicyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POLICY_ID_FIELD,
            ACCESS_POLICY_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accessPolicyId;

    private final String accessPolicyArn;

    private CreateAccessPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.accessPolicyId = builder.accessPolicyId;
        this.accessPolicyArn = builder.accessPolicyArn;
    }

    /**
     * <p>
     * The ID of the access policy.
     * </p>
     * 
     * @return The ID of the access policy.
     */
    public final String accessPolicyId() {
        return accessPolicyId;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the access
     * policy, which has the following format.
     * </p>
     * <p>
     * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:access-policy/${AccessPolicyId}</code>
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         access policy, which has the following format.</p>
     *         <p>
     *         <code>arn:${Partition}:iotsitewise:${Region}:${Account}:access-policy/${AccessPolicyId}</code>
     */
    public final String accessPolicyArn() {
        return accessPolicyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessPolicyResponse)) {
            return false;
        }
        CreateAccessPolicyResponse other = (CreateAccessPolicyResponse) obj;
        return Objects.equals(accessPolicyId(), other.accessPolicyId())
                && Objects.equals(accessPolicyArn(), other.accessPolicyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAccessPolicyResponse").add("AccessPolicyId", accessPolicyId())
                .add("AccessPolicyArn", accessPolicyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessPolicyId":
            return Optional.ofNullable(clazz.cast(accessPolicyId()));
        case "accessPolicyArn":
            return Optional.ofNullable(clazz.cast(accessPolicyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accessPolicyId", ACCESS_POLICY_ID_FIELD);
        map.put("accessPolicyArn", ACCESS_POLICY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessPolicyResponse, T> g) {
        return obj -> g.apply((CreateAccessPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateAccessPolicyResponse> {
        /**
         * <p>
         * The ID of the access policy.
         * </p>
         * 
         * @param accessPolicyId
         *        The ID of the access policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicyId(String accessPolicyId);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
         * access policy, which has the following format.
         * </p>
         * <p>
         * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:access-policy/${AccessPolicyId}</code>
         * </p>
         * 
         * @param accessPolicyArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the access policy, which has the following format.</p>
         *        <p>
         *        <code>arn:${Partition}:iotsitewise:${Region}:${Account}:access-policy/${AccessPolicyId}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicyArn(String accessPolicyArn);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private String accessPolicyId;

        private String accessPolicyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessPolicyResponse model) {
            super(model);
            accessPolicyId(model.accessPolicyId);
            accessPolicyArn(model.accessPolicyArn);
        }

        public final String getAccessPolicyId() {
            return accessPolicyId;
        }

        public final void setAccessPolicyId(String accessPolicyId) {
            this.accessPolicyId = accessPolicyId;
        }

        @Override
        public final Builder accessPolicyId(String accessPolicyId) {
            this.accessPolicyId = accessPolicyId;
            return this;
        }

        public final String getAccessPolicyArn() {
            return accessPolicyArn;
        }

        public final void setAccessPolicyArn(String accessPolicyArn) {
            this.accessPolicyArn = accessPolicyArn;
        }

        @Override
        public final Builder accessPolicyArn(String accessPolicyArn) {
            this.accessPolicyArn = accessPolicyArn;
            return this;
        }

        @Override
        public CreateAccessPolicyResponse build() {
            return new CreateAccessPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
