/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the resource that a computation model resolves to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComputationModelResolveToResourceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ComputationModelResolveToResourceSummary.Builder, ComputationModelResolveToResourceSummary> {
    private static final SdkField<ResolveTo> RESOLVE_TO_FIELD = SdkField.<ResolveTo> builder(MarshallingType.SDK_POJO)
            .memberName("resolveTo").getter(getter(ComputationModelResolveToResourceSummary::resolveTo))
            .setter(setter(Builder::resolveTo)).constructor(ResolveTo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolveTo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOLVE_TO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ResolveTo resolveTo;

    private ComputationModelResolveToResourceSummary(BuilderImpl builder) {
        this.resolveTo = builder.resolveTo;
    }

    /**
     * Returns the value of the ResolveTo property for this object.
     * 
     * @return The value of the ResolveTo property for this object.
     */
    public final ResolveTo resolveTo() {
        return resolveTo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resolveTo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputationModelResolveToResourceSummary)) {
            return false;
        }
        ComputationModelResolveToResourceSummary other = (ComputationModelResolveToResourceSummary) obj;
        return Objects.equals(resolveTo(), other.resolveTo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComputationModelResolveToResourceSummary").add("ResolveTo", resolveTo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resolveTo":
            return Optional.ofNullable(clazz.cast(resolveTo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resolveTo", RESOLVE_TO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComputationModelResolveToResourceSummary, T> g) {
        return obj -> g.apply((ComputationModelResolveToResourceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComputationModelResolveToResourceSummary> {
        /**
         * Sets the value of the ResolveTo property for this object.
         *
         * @param resolveTo
         *        The new value for the ResolveTo property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolveTo(ResolveTo resolveTo);

        /**
         * Sets the value of the ResolveTo property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResolveTo.Builder} avoiding the need to
         * create one manually via {@link ResolveTo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResolveTo.Builder#build()} is called immediately and its result
         * is passed to {@link #resolveTo(ResolveTo)}.
         * 
         * @param resolveTo
         *        a consumer that will call methods on {@link ResolveTo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resolveTo(ResolveTo)
         */
        default Builder resolveTo(Consumer<ResolveTo.Builder> resolveTo) {
            return resolveTo(ResolveTo.builder().applyMutation(resolveTo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ResolveTo resolveTo;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputationModelResolveToResourceSummary model) {
            resolveTo(model.resolveTo);
        }

        public final ResolveTo.Builder getResolveTo() {
            return resolveTo != null ? resolveTo.toBuilder() : null;
        }

        public final void setResolveTo(ResolveTo.BuilderImpl resolveTo) {
            this.resolveTo = resolveTo != null ? resolveTo.build() : null;
        }

        @Override
        public final Builder resolveTo(ResolveTo resolveTo) {
            this.resolveTo = resolveTo;
            return this;
        }

        @Override
        public ComputationModelResolveToResourceSummary build() {
            return new ComputationModelResolveToResourceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
