/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains computation model data binding value information, which can be one of <code>assetModelProperty</code>,
 * <code>list</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComputationModelDataBindingValue implements SdkPojo, Serializable,
        ToCopyableBuilder<ComputationModelDataBindingValue.Builder, ComputationModelDataBindingValue> {
    private static final SdkField<AssetModelPropertyBindingValue> ASSET_MODEL_PROPERTY_FIELD = SdkField
            .<AssetModelPropertyBindingValue> builder(MarshallingType.SDK_POJO).memberName("assetModelProperty")
            .getter(getter(ComputationModelDataBindingValue::assetModelProperty)).setter(setter(Builder::assetModelProperty))
            .constructor(AssetModelPropertyBindingValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelProperty").build())
            .build();

    private static final SdkField<AssetPropertyBindingValue> ASSET_PROPERTY_FIELD = SdkField
            .<AssetPropertyBindingValue> builder(MarshallingType.SDK_POJO).memberName("assetProperty")
            .getter(getter(ComputationModelDataBindingValue::assetProperty)).setter(setter(Builder::assetProperty))
            .constructor(AssetPropertyBindingValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetProperty").build()).build();

    private static final SdkField<List<ComputationModelDataBindingValue>> LIST_FIELD = SdkField
            .<List<ComputationModelDataBindingValue>> builder(MarshallingType.LIST)
            .memberName("list")
            .getter(getter(ComputationModelDataBindingValue::list))
            .setter(setter(Builder::list))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("list").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComputationModelDataBindingValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComputationModelDataBindingValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_PROPERTY_FIELD,
            ASSET_PROPERTY_FIELD, LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AssetModelPropertyBindingValue assetModelProperty;

    private final AssetPropertyBindingValue assetProperty;

    private final List<ComputationModelDataBindingValue> list;

    private ComputationModelDataBindingValue(BuilderImpl builder) {
        this.assetModelProperty = builder.assetModelProperty;
        this.assetProperty = builder.assetProperty;
        this.list = builder.list;
    }

    /**
     * <p>
     * Specifies an asset model property data binding value.
     * </p>
     * 
     * @return Specifies an asset model property data binding value.
     */
    public final AssetModelPropertyBindingValue assetModelProperty() {
        return assetModelProperty;
    }

    /**
     * <p>
     * The asset property value used for computation model data binding.
     * </p>
     * 
     * @return The asset property value used for computation model data binding.
     */
    public final AssetPropertyBindingValue assetProperty() {
        return assetProperty;
    }

    /**
     * For responses, this returns true if the service returned a value for the List property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasList() {
        return list != null && !(list instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies a list of data binding value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasList} method.
     * </p>
     * 
     * @return Specifies a list of data binding value.
     */
    public final List<ComputationModelDataBindingValue> list() {
        return list;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assetModelProperty());
        hashCode = 31 * hashCode + Objects.hashCode(assetProperty());
        hashCode = 31 * hashCode + Objects.hashCode(hasList() ? list() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputationModelDataBindingValue)) {
            return false;
        }
        ComputationModelDataBindingValue other = (ComputationModelDataBindingValue) obj;
        return Objects.equals(assetModelProperty(), other.assetModelProperty())
                && Objects.equals(assetProperty(), other.assetProperty()) && hasList() == other.hasList()
                && Objects.equals(list(), other.list());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComputationModelDataBindingValue").add("AssetModelProperty", assetModelProperty())
                .add("AssetProperty", assetProperty()).add("List", hasList() ? list() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetModelProperty":
            return Optional.ofNullable(clazz.cast(assetModelProperty()));
        case "assetProperty":
            return Optional.ofNullable(clazz.cast(assetProperty()));
        case "list":
            return Optional.ofNullable(clazz.cast(list()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assetModelProperty", ASSET_MODEL_PROPERTY_FIELD);
        map.put("assetProperty", ASSET_PROPERTY_FIELD);
        map.put("list", LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComputationModelDataBindingValue, T> g) {
        return obj -> g.apply((ComputationModelDataBindingValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComputationModelDataBindingValue> {
        /**
         * <p>
         * Specifies an asset model property data binding value.
         * </p>
         * 
         * @param assetModelProperty
         *        Specifies an asset model property data binding value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelProperty(AssetModelPropertyBindingValue assetModelProperty);

        /**
         * <p>
         * Specifies an asset model property data binding value.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssetModelPropertyBindingValue.Builder}
         * avoiding the need to create one manually via {@link AssetModelPropertyBindingValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetModelPropertyBindingValue.Builder#build()} is called
         * immediately and its result is passed to {@link #assetModelProperty(AssetModelPropertyBindingValue)}.
         * 
         * @param assetModelProperty
         *        a consumer that will call methods on {@link AssetModelPropertyBindingValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetModelProperty(AssetModelPropertyBindingValue)
         */
        default Builder assetModelProperty(Consumer<AssetModelPropertyBindingValue.Builder> assetModelProperty) {
            return assetModelProperty(AssetModelPropertyBindingValue.builder().applyMutation(assetModelProperty).build());
        }

        /**
         * <p>
         * The asset property value used for computation model data binding.
         * </p>
         * 
         * @param assetProperty
         *        The asset property value used for computation model data binding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetProperty(AssetPropertyBindingValue assetProperty);

        /**
         * <p>
         * The asset property value used for computation model data binding.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssetPropertyBindingValue.Builder}
         * avoiding the need to create one manually via {@link AssetPropertyBindingValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetPropertyBindingValue.Builder#build()} is called immediately
         * and its result is passed to {@link #assetProperty(AssetPropertyBindingValue)}.
         * 
         * @param assetProperty
         *        a consumer that will call methods on {@link AssetPropertyBindingValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetProperty(AssetPropertyBindingValue)
         */
        default Builder assetProperty(Consumer<AssetPropertyBindingValue.Builder> assetProperty) {
            return assetProperty(AssetPropertyBindingValue.builder().applyMutation(assetProperty).build());
        }

        /**
         * <p>
         * Specifies a list of data binding value.
         * </p>
         * 
         * @param list
         *        Specifies a list of data binding value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder list(Collection<ComputationModelDataBindingValue> list);

        /**
         * <p>
         * Specifies a list of data binding value.
         * </p>
         * 
         * @param list
         *        Specifies a list of data binding value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder list(ComputationModelDataBindingValue... list);

        /**
         * <p>
         * Specifies a list of data binding value.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.ComputationModelDataBindingValue.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.ComputationModelDataBindingValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.ComputationModelDataBindingValue.Builder#build()} is
         * called immediately and its result is passed to {@link #list(List<ComputationModelDataBindingValue>)}.
         * 
         * @param list
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.ComputationModelDataBindingValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #list(java.util.Collection<ComputationModelDataBindingValue>)
         */
        Builder list(Consumer<Builder>... list);
    }

    static final class BuilderImpl implements Builder {
        private AssetModelPropertyBindingValue assetModelProperty;

        private AssetPropertyBindingValue assetProperty;

        private List<ComputationModelDataBindingValue> list = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComputationModelDataBindingValue model) {
            assetModelProperty(model.assetModelProperty);
            assetProperty(model.assetProperty);
            list(model.list);
        }

        public final AssetModelPropertyBindingValue.Builder getAssetModelProperty() {
            return assetModelProperty != null ? assetModelProperty.toBuilder() : null;
        }

        public final void setAssetModelProperty(AssetModelPropertyBindingValue.BuilderImpl assetModelProperty) {
            this.assetModelProperty = assetModelProperty != null ? assetModelProperty.build() : null;
        }

        @Override
        public final Builder assetModelProperty(AssetModelPropertyBindingValue assetModelProperty) {
            this.assetModelProperty = assetModelProperty;
            return this;
        }

        public final AssetPropertyBindingValue.Builder getAssetProperty() {
            return assetProperty != null ? assetProperty.toBuilder() : null;
        }

        public final void setAssetProperty(AssetPropertyBindingValue.BuilderImpl assetProperty) {
            this.assetProperty = assetProperty != null ? assetProperty.build() : null;
        }

        @Override
        public final Builder assetProperty(AssetPropertyBindingValue assetProperty) {
            this.assetProperty = assetProperty;
            return this;
        }

        public final List<Builder> getList() {
            List<Builder> result = BindingValueListCopier.copyToBuilder(this.list);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setList(Collection<BuilderImpl> list) {
            this.list = BindingValueListCopier.copyFromBuilder(list);
        }

        @Override
        public final Builder list(Collection<ComputationModelDataBindingValue> list) {
            this.list = BindingValueListCopier.copy(list);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder list(ComputationModelDataBindingValue... list) {
            list(Arrays.asList(list));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder list(Consumer<Builder>... list) {
            list(Stream.of(list).map(c -> ComputationModelDataBindingValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ComputationModelDataBindingValue build() {
            return new ComputationModelDataBindingValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
