/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for the computation model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComputationModelConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ComputationModelConfiguration.Builder, ComputationModelConfiguration> {
    private static final SdkField<ComputationModelAnomalyDetectionConfiguration> ANOMALY_DETECTION_FIELD = SdkField
            .<ComputationModelAnomalyDetectionConfiguration> builder(MarshallingType.SDK_POJO).memberName("anomalyDetection")
            .getter(getter(ComputationModelConfiguration::anomalyDetection)).setter(setter(Builder::anomalyDetection))
            .constructor(ComputationModelAnomalyDetectionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anomalyDetection").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ComputationModelAnomalyDetectionConfiguration anomalyDetection;

    private ComputationModelConfiguration(BuilderImpl builder) {
        this.anomalyDetection = builder.anomalyDetection;
    }

    /**
     * <p>
     * The configuration for the anomaly detection type of computation model.
     * </p>
     * 
     * @return The configuration for the anomaly detection type of computation model.
     */
    public final ComputationModelAnomalyDetectionConfiguration anomalyDetection() {
        return anomalyDetection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputationModelConfiguration)) {
            return false;
        }
        ComputationModelConfiguration other = (ComputationModelConfiguration) obj;
        return Objects.equals(anomalyDetection(), other.anomalyDetection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComputationModelConfiguration").add("AnomalyDetection", anomalyDetection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "anomalyDetection":
            return Optional.ofNullable(clazz.cast(anomalyDetection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("anomalyDetection", ANOMALY_DETECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComputationModelConfiguration, T> g) {
        return obj -> g.apply((ComputationModelConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComputationModelConfiguration> {
        /**
         * <p>
         * The configuration for the anomaly detection type of computation model.
         * </p>
         * 
         * @param anomalyDetection
         *        The configuration for the anomaly detection type of computation model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetection(ComputationModelAnomalyDetectionConfiguration anomalyDetection);

        /**
         * <p>
         * The configuration for the anomaly detection type of computation model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ComputationModelAnomalyDetectionConfiguration.Builder} avoiding the need to create one manually via
         * {@link ComputationModelAnomalyDetectionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputationModelAnomalyDetectionConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #anomalyDetection(ComputationModelAnomalyDetectionConfiguration)}.
         * 
         * @param anomalyDetection
         *        a consumer that will call methods on {@link ComputationModelAnomalyDetectionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #anomalyDetection(ComputationModelAnomalyDetectionConfiguration)
         */
        default Builder anomalyDetection(Consumer<ComputationModelAnomalyDetectionConfiguration.Builder> anomalyDetection) {
            return anomalyDetection(ComputationModelAnomalyDetectionConfiguration.builder().applyMutation(anomalyDetection)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ComputationModelAnomalyDetectionConfiguration anomalyDetection;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputationModelConfiguration model) {
            anomalyDetection(model.anomalyDetection);
        }

        public final ComputationModelAnomalyDetectionConfiguration.Builder getAnomalyDetection() {
            return anomalyDetection != null ? anomalyDetection.toBuilder() : null;
        }

        public final void setAnomalyDetection(ComputationModelAnomalyDetectionConfiguration.BuilderImpl anomalyDetection) {
            this.anomalyDetection = anomalyDetection != null ? anomalyDetection.build() : null;
        }

        @Override
        public final Builder anomalyDetection(ComputationModelAnomalyDetectionConfiguration anomalyDetection) {
            this.anomalyDetection = anomalyDetection;
            return this;
        }

        @Override
        public ComputationModelConfiguration build() {
            return new ComputationModelConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
