/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information for an entry that has been processed by the previous <a
 * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html"
 * >BatchGetAssetPropertyValue</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetAssetPropertyValueSkippedEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchGetAssetPropertyValueSkippedEntry.Builder, BatchGetAssetPropertyValueSkippedEntry> {
    private static final SdkField<String> ENTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entryId").getter(getter(BatchGetAssetPropertyValueSkippedEntry::entryId))
            .setter(setter(Builder::entryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryId").build()).build();

    private static final SdkField<String> COMPLETION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("completionStatus").getter(getter(BatchGetAssetPropertyValueSkippedEntry::completionStatusAsString))
            .setter(setter(Builder::completionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completionStatus").build()).build();

    private static final SdkField<BatchGetAssetPropertyValueErrorInfo> ERROR_INFO_FIELD = SdkField
            .<BatchGetAssetPropertyValueErrorInfo> builder(MarshallingType.SDK_POJO).memberName("errorInfo")
            .getter(getter(BatchGetAssetPropertyValueSkippedEntry::errorInfo)).setter(setter(Builder::errorInfo))
            .constructor(BatchGetAssetPropertyValueErrorInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_ID_FIELD,
            COMPLETION_STATUS_FIELD, ERROR_INFO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String entryId;

    private final String completionStatus;

    private final BatchGetAssetPropertyValueErrorInfo errorInfo;

    private BatchGetAssetPropertyValueSkippedEntry(BuilderImpl builder) {
        this.entryId = builder.entryId;
        this.completionStatus = builder.completionStatus;
        this.errorInfo = builder.errorInfo;
    }

    /**
     * <p>
     * The ID of the entry.
     * </p>
     * 
     * @return The ID of the entry.
     */
    public final String entryId() {
        return entryId;
    }

    /**
     * <p>
     * The completion status of each entry that is associated with the <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html"
     * >BatchGetAssetPropertyValue</a> request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #completionStatus}
     * will return {@link BatchEntryCompletionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #completionStatusAsString}.
     * </p>
     * 
     * @return The completion status of each entry that is associated with the <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html"
     *         >BatchGetAssetPropertyValue</a> request.
     * @see BatchEntryCompletionStatus
     */
    public final BatchEntryCompletionStatus completionStatus() {
        return BatchEntryCompletionStatus.fromValue(completionStatus);
    }

    /**
     * <p>
     * The completion status of each entry that is associated with the <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html"
     * >BatchGetAssetPropertyValue</a> request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #completionStatus}
     * will return {@link BatchEntryCompletionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #completionStatusAsString}.
     * </p>
     * 
     * @return The completion status of each entry that is associated with the <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html"
     *         >BatchGetAssetPropertyValue</a> request.
     * @see BatchEntryCompletionStatus
     */
    public final String completionStatusAsString() {
        return completionStatus;
    }

    /**
     * <p>
     * The error information, such as the error code and the timestamp.
     * </p>
     * 
     * @return The error information, such as the error code and the timestamp.
     */
    public final BatchGetAssetPropertyValueErrorInfo errorInfo() {
        return errorInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entryId());
        hashCode = 31 * hashCode + Objects.hashCode(completionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAssetPropertyValueSkippedEntry)) {
            return false;
        }
        BatchGetAssetPropertyValueSkippedEntry other = (BatchGetAssetPropertyValueSkippedEntry) obj;
        return Objects.equals(entryId(), other.entryId())
                && Objects.equals(completionStatusAsString(), other.completionStatusAsString())
                && Objects.equals(errorInfo(), other.errorInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetAssetPropertyValueSkippedEntry").add("EntryId", entryId())
                .add("CompletionStatus", completionStatusAsString()).add("ErrorInfo", errorInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entryId":
            return Optional.ofNullable(clazz.cast(entryId()));
        case "completionStatus":
            return Optional.ofNullable(clazz.cast(completionStatusAsString()));
        case "errorInfo":
            return Optional.ofNullable(clazz.cast(errorInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("entryId", ENTRY_ID_FIELD);
        map.put("completionStatus", COMPLETION_STATUS_FIELD);
        map.put("errorInfo", ERROR_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAssetPropertyValueSkippedEntry, T> g) {
        return obj -> g.apply((BatchGetAssetPropertyValueSkippedEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchGetAssetPropertyValueSkippedEntry> {
        /**
         * <p>
         * The ID of the entry.
         * </p>
         * 
         * @param entryId
         *        The ID of the entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entryId(String entryId);

        /**
         * <p>
         * The completion status of each entry that is associated with the <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html"
         * >BatchGetAssetPropertyValue</a> request.
         * </p>
         * 
         * @param completionStatus
         *        The completion status of each entry that is associated with the <a href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html"
         *        >BatchGetAssetPropertyValue</a> request.
         * @see BatchEntryCompletionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchEntryCompletionStatus
         */
        Builder completionStatus(String completionStatus);

        /**
         * <p>
         * The completion status of each entry that is associated with the <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html"
         * >BatchGetAssetPropertyValue</a> request.
         * </p>
         * 
         * @param completionStatus
         *        The completion status of each entry that is associated with the <a href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html"
         *        >BatchGetAssetPropertyValue</a> request.
         * @see BatchEntryCompletionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchEntryCompletionStatus
         */
        Builder completionStatus(BatchEntryCompletionStatus completionStatus);

        /**
         * <p>
         * The error information, such as the error code and the timestamp.
         * </p>
         * 
         * @param errorInfo
         *        The error information, such as the error code and the timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorInfo(BatchGetAssetPropertyValueErrorInfo errorInfo);

        /**
         * <p>
         * The error information, such as the error code and the timestamp.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link BatchGetAssetPropertyValueErrorInfo.Builder} avoiding the need to create one manually via
         * {@link BatchGetAssetPropertyValueErrorInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchGetAssetPropertyValueErrorInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #errorInfo(BatchGetAssetPropertyValueErrorInfo)}.
         * 
         * @param errorInfo
         *        a consumer that will call methods on {@link BatchGetAssetPropertyValueErrorInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorInfo(BatchGetAssetPropertyValueErrorInfo)
         */
        default Builder errorInfo(Consumer<BatchGetAssetPropertyValueErrorInfo.Builder> errorInfo) {
            return errorInfo(BatchGetAssetPropertyValueErrorInfo.builder().applyMutation(errorInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String entryId;

        private String completionStatus;

        private BatchGetAssetPropertyValueErrorInfo errorInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAssetPropertyValueSkippedEntry model) {
            entryId(model.entryId);
            completionStatus(model.completionStatus);
            errorInfo(model.errorInfo);
        }

        public final String getEntryId() {
            return entryId;
        }

        public final void setEntryId(String entryId) {
            this.entryId = entryId;
        }

        @Override
        public final Builder entryId(String entryId) {
            this.entryId = entryId;
            return this;
        }

        public final String getCompletionStatus() {
            return completionStatus;
        }

        public final void setCompletionStatus(String completionStatus) {
            this.completionStatus = completionStatus;
        }

        @Override
        public final Builder completionStatus(String completionStatus) {
            this.completionStatus = completionStatus;
            return this;
        }

        @Override
        public final Builder completionStatus(BatchEntryCompletionStatus completionStatus) {
            this.completionStatus(completionStatus == null ? null : completionStatus.toString());
            return this;
        }

        public final BatchGetAssetPropertyValueErrorInfo.Builder getErrorInfo() {
            return errorInfo != null ? errorInfo.toBuilder() : null;
        }

        public final void setErrorInfo(BatchGetAssetPropertyValueErrorInfo.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        @Override
        public final Builder errorInfo(BatchGetAssetPropertyValueErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        @Override
        public BatchGetAssetPropertyValueSkippedEntry build() {
            return new BatchGetAssetPropertyValueSkippedEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
