/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about assets that are related to one another.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetRelationshipSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetRelationshipSummary.Builder, AssetRelationshipSummary> {
    private static final SdkField<AssetHierarchyInfo> HIERARCHY_INFO_FIELD = SdkField
            .<AssetHierarchyInfo> builder(MarshallingType.SDK_POJO).memberName("hierarchyInfo")
            .getter(getter(AssetRelationshipSummary::hierarchyInfo)).setter(setter(Builder::hierarchyInfo))
            .constructor(AssetHierarchyInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hierarchyInfo").build()).build();

    private static final SdkField<String> RELATIONSHIP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("relationshipType").getter(getter(AssetRelationshipSummary::relationshipTypeAsString))
            .setter(setter(Builder::relationshipType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationshipType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HIERARCHY_INFO_FIELD,
            RELATIONSHIP_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AssetHierarchyInfo hierarchyInfo;

    private final String relationshipType;

    private AssetRelationshipSummary(BuilderImpl builder) {
        this.hierarchyInfo = builder.hierarchyInfo;
        this.relationshipType = builder.relationshipType;
    }

    /**
     * <p>
     * The assets that are related through an asset hierarchy.
     * </p>
     * <p>
     * This object is present if the <code>relationshipType</code> is <code>HIERARCHY</code>.
     * </p>
     * 
     * @return The assets that are related through an asset hierarchy.</p>
     *         <p>
     *         This object is present if the <code>relationshipType</code> is <code>HIERARCHY</code>.
     */
    public final AssetHierarchyInfo hierarchyInfo() {
        return hierarchyInfo;
    }

    /**
     * <p>
     * The relationship type of the assets in this relationship. This value is one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HIERARCHY</code> – The assets are related through an asset hierarchy. If you specify this relationship
     * type, this asset relationship includes the <code>hierarchyInfo</code> object.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relationshipType}
     * will return {@link AssetRelationshipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #relationshipTypeAsString}.
     * </p>
     * 
     * @return The relationship type of the assets in this relationship. This value is one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HIERARCHY</code> – The assets are related through an asset hierarchy. If you specify this
     *         relationship type, this asset relationship includes the <code>hierarchyInfo</code> object.
     *         </p>
     *         </li>
     * @see AssetRelationshipType
     */
    public final AssetRelationshipType relationshipType() {
        return AssetRelationshipType.fromValue(relationshipType);
    }

    /**
     * <p>
     * The relationship type of the assets in this relationship. This value is one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HIERARCHY</code> – The assets are related through an asset hierarchy. If you specify this relationship
     * type, this asset relationship includes the <code>hierarchyInfo</code> object.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relationshipType}
     * will return {@link AssetRelationshipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #relationshipTypeAsString}.
     * </p>
     * 
     * @return The relationship type of the assets in this relationship. This value is one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HIERARCHY</code> – The assets are related through an asset hierarchy. If you specify this
     *         relationship type, this asset relationship includes the <code>hierarchyInfo</code> object.
     *         </p>
     *         </li>
     * @see AssetRelationshipType
     */
    public final String relationshipTypeAsString() {
        return relationshipType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hierarchyInfo());
        hashCode = 31 * hashCode + Objects.hashCode(relationshipTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetRelationshipSummary)) {
            return false;
        }
        AssetRelationshipSummary other = (AssetRelationshipSummary) obj;
        return Objects.equals(hierarchyInfo(), other.hierarchyInfo())
                && Objects.equals(relationshipTypeAsString(), other.relationshipTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetRelationshipSummary").add("HierarchyInfo", hierarchyInfo())
                .add("RelationshipType", relationshipTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "hierarchyInfo":
            return Optional.ofNullable(clazz.cast(hierarchyInfo()));
        case "relationshipType":
            return Optional.ofNullable(clazz.cast(relationshipTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("hierarchyInfo", HIERARCHY_INFO_FIELD);
        map.put("relationshipType", RELATIONSHIP_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetRelationshipSummary, T> g) {
        return obj -> g.apply((AssetRelationshipSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetRelationshipSummary> {
        /**
         * <p>
         * The assets that are related through an asset hierarchy.
         * </p>
         * <p>
         * This object is present if the <code>relationshipType</code> is <code>HIERARCHY</code>.
         * </p>
         * 
         * @param hierarchyInfo
         *        The assets that are related through an asset hierarchy.</p>
         *        <p>
         *        This object is present if the <code>relationshipType</code> is <code>HIERARCHY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchyInfo(AssetHierarchyInfo hierarchyInfo);

        /**
         * <p>
         * The assets that are related through an asset hierarchy.
         * </p>
         * <p>
         * This object is present if the <code>relationshipType</code> is <code>HIERARCHY</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssetHierarchyInfo.Builder} avoiding the
         * need to create one manually via {@link AssetHierarchyInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetHierarchyInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #hierarchyInfo(AssetHierarchyInfo)}.
         * 
         * @param hierarchyInfo
         *        a consumer that will call methods on {@link AssetHierarchyInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hierarchyInfo(AssetHierarchyInfo)
         */
        default Builder hierarchyInfo(Consumer<AssetHierarchyInfo.Builder> hierarchyInfo) {
            return hierarchyInfo(AssetHierarchyInfo.builder().applyMutation(hierarchyInfo).build());
        }

        /**
         * <p>
         * The relationship type of the assets in this relationship. This value is one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HIERARCHY</code> – The assets are related through an asset hierarchy. If you specify this relationship
         * type, this asset relationship includes the <code>hierarchyInfo</code> object.
         * </p>
         * </li>
         * </ul>
         * 
         * @param relationshipType
         *        The relationship type of the assets in this relationship. This value is one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HIERARCHY</code> – The assets are related through an asset hierarchy. If you specify this
         *        relationship type, this asset relationship includes the <code>hierarchyInfo</code> object.
         *        </p>
         *        </li>
         * @see AssetRelationshipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetRelationshipType
         */
        Builder relationshipType(String relationshipType);

        /**
         * <p>
         * The relationship type of the assets in this relationship. This value is one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HIERARCHY</code> – The assets are related through an asset hierarchy. If you specify this relationship
         * type, this asset relationship includes the <code>hierarchyInfo</code> object.
         * </p>
         * </li>
         * </ul>
         * 
         * @param relationshipType
         *        The relationship type of the assets in this relationship. This value is one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HIERARCHY</code> – The assets are related through an asset hierarchy. If you specify this
         *        relationship type, this asset relationship includes the <code>hierarchyInfo</code> object.
         *        </p>
         *        </li>
         * @see AssetRelationshipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetRelationshipType
         */
        Builder relationshipType(AssetRelationshipType relationshipType);
    }

    static final class BuilderImpl implements Builder {
        private AssetHierarchyInfo hierarchyInfo;

        private String relationshipType;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetRelationshipSummary model) {
            hierarchyInfo(model.hierarchyInfo);
            relationshipType(model.relationshipType);
        }

        public final AssetHierarchyInfo.Builder getHierarchyInfo() {
            return hierarchyInfo != null ? hierarchyInfo.toBuilder() : null;
        }

        public final void setHierarchyInfo(AssetHierarchyInfo.BuilderImpl hierarchyInfo) {
            this.hierarchyInfo = hierarchyInfo != null ? hierarchyInfo.build() : null;
        }

        @Override
        public final Builder hierarchyInfo(AssetHierarchyInfo hierarchyInfo) {
            this.hierarchyInfo = hierarchyInfo;
            return this;
        }

        public final String getRelationshipType() {
            return relationshipType;
        }

        public final void setRelationshipType(String relationshipType) {
            this.relationshipType = relationshipType;
        }

        @Override
        public final Builder relationshipType(String relationshipType) {
            this.relationshipType = relationshipType;
            return this;
        }

        @Override
        public final Builder relationshipType(AssetRelationshipType relationshipType) {
            this.relationshipType(relationshipType == null ? null : relationshipType.toString());
            return this;
        }

        @Override
        public AssetRelationshipSummary build() {
            return new AssetRelationshipSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
