/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.Content;
import software.amazon.awssdk.services.iotsitewise.model.Reference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Citation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Citation> {
    private static final SdkField<Reference> REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("reference").getter(Citation.getter(Citation::reference)).setter(Citation.setter(Builder::reference)).constructor(Reference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reference").build()}).build();
    private static final SdkField<Content> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("content").getter(Citation.getter(Citation::content)).setter(Citation.setter(Builder::content)).constructor(Content::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCE_FIELD, CONTENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Citation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Reference reference;
    private final Content content;

    private Citation(BuilderImpl builder) {
        this.reference = builder.reference;
        this.content = builder.content;
    }

    public final Reference reference() {
        return this.reference;
    }

    public final Content content() {
        return this.content;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reference());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Citation)) {
            return false;
        }
        Citation other = (Citation)obj;
        return Objects.equals(this.reference(), other.reference()) && Objects.equals(this.content(), other.content());
    }

    public final String toString() {
        return ToString.builder((String)"Citation").add("Reference", (Object)this.reference()).add("Content", (Object)this.content()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "reference": {
                return Optional.ofNullable(clazz.cast(this.reference()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("reference", REFERENCE_FIELD);
        map.put("content", CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Citation, T> g) {
        return obj -> g.apply((Citation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Reference reference;
        private Content content;

        private BuilderImpl() {
        }

        private BuilderImpl(Citation model) {
            this.reference(model.reference);
            this.content(model.content);
        }

        public final Reference.Builder getReference() {
            return this.reference != null ? this.reference.toBuilder() : null;
        }

        public final void setReference(Reference.BuilderImpl reference) {
            this.reference = reference != null ? reference.build() : null;
        }

        @Override
        public final Builder reference(Reference reference) {
            this.reference = reference;
            return this;
        }

        public final Content.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        public final void setContent(Content.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(Content content) {
            this.content = content;
            return this;
        }

        public Citation build() {
            return new Citation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Citation> {
        public Builder reference(Reference var1);

        default public Builder reference(Consumer<Reference.Builder> reference) {
            return this.reference((Reference)((Reference.Builder)Reference.builder().applyMutation(reference)).build());
        }

        public Builder content(Content var1);

        default public Builder content(Consumer<Content.Builder> content) {
            return this.content((Content)((Content.Builder)Content.builder().applyMutation(content)).build());
        }
    }
}

