/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.ActionDefinition;
import software.amazon.awssdk.services.iotsitewise.model.ActionDefinitionsCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModelPathCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModelPathSegment;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModelSummariesCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModelSummary;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertiesCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelProperty;
import software.amazon.awssdk.services.iotsitewise.model.CompositionDetails;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAssetModelCompositeModelResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, DescribeAssetModelCompositeModelResponse> {
    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelId").getter(DescribeAssetModelCompositeModelResponse.getter(DescribeAssetModelCompositeModelResponse::assetModelId)).setter(DescribeAssetModelCompositeModelResponse.setter(Builder::assetModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelId").build()}).build();
    private static final SdkField<String> ASSET_MODEL_COMPOSITE_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelCompositeModelId").getter(DescribeAssetModelCompositeModelResponse.getter(DescribeAssetModelCompositeModelResponse::assetModelCompositeModelId)).setter(DescribeAssetModelCompositeModelResponse.setter(Builder::assetModelCompositeModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelId").build()}).build();
    private static final SdkField<String> ASSET_MODEL_COMPOSITE_MODEL_EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelCompositeModelExternalId").getter(DescribeAssetModelCompositeModelResponse.getter(DescribeAssetModelCompositeModelResponse::assetModelCompositeModelExternalId)).setter(DescribeAssetModelCompositeModelResponse.setter(Builder::assetModelCompositeModelExternalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelExternalId").build()}).build();
    private static final SdkField<List<AssetModelCompositeModelPathSegment>> ASSET_MODEL_COMPOSITE_MODEL_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetModelCompositeModelPath").getter(DescribeAssetModelCompositeModelResponse.getter(DescribeAssetModelCompositeModelResponse::assetModelCompositeModelPath)).setter(DescribeAssetModelCompositeModelResponse.setter(Builder::assetModelCompositeModelPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelPath").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetModelCompositeModelPathSegment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ASSET_MODEL_COMPOSITE_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelCompositeModelName").getter(DescribeAssetModelCompositeModelResponse.getter(DescribeAssetModelCompositeModelResponse::assetModelCompositeModelName)).setter(DescribeAssetModelCompositeModelResponse.setter(Builder::assetModelCompositeModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelName").build()}).build();
    private static final SdkField<String> ASSET_MODEL_COMPOSITE_MODEL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelCompositeModelDescription").getter(DescribeAssetModelCompositeModelResponse.getter(DescribeAssetModelCompositeModelResponse::assetModelCompositeModelDescription)).setter(DescribeAssetModelCompositeModelResponse.setter(Builder::assetModelCompositeModelDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelDescription").build()}).build();
    private static final SdkField<String> ASSET_MODEL_COMPOSITE_MODEL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelCompositeModelType").getter(DescribeAssetModelCompositeModelResponse.getter(DescribeAssetModelCompositeModelResponse::assetModelCompositeModelType)).setter(DescribeAssetModelCompositeModelResponse.setter(Builder::assetModelCompositeModelType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelType").build()}).build();
    private static final SdkField<List<AssetModelProperty>> ASSET_MODEL_COMPOSITE_MODEL_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetModelCompositeModelProperties").getter(DescribeAssetModelCompositeModelResponse.getter(DescribeAssetModelCompositeModelResponse::assetModelCompositeModelProperties)).setter(DescribeAssetModelCompositeModelResponse.setter(Builder::assetModelCompositeModelProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetModelProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CompositionDetails> COMPOSITION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("compositionDetails").getter(DescribeAssetModelCompositeModelResponse.getter(DescribeAssetModelCompositeModelResponse::compositionDetails)).setter(DescribeAssetModelCompositeModelResponse.setter(Builder::compositionDetails)).constructor(CompositionDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compositionDetails").build()}).build();
    private static final SdkField<List<AssetModelCompositeModelSummary>> ASSET_MODEL_COMPOSITE_MODEL_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetModelCompositeModelSummaries").getter(DescribeAssetModelCompositeModelResponse.getter(DescribeAssetModelCompositeModelResponse::assetModelCompositeModelSummaries)).setter(DescribeAssetModelCompositeModelResponse.setter(Builder::assetModelCompositeModelSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetModelCompositeModelSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ActionDefinition>> ACTION_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actionDefinitions").getter(DescribeAssetModelCompositeModelResponse.getter(DescribeAssetModelCompositeModelResponse::actionDefinitions)).setter(DescribeAssetModelCompositeModelResponse.setter(Builder::actionDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActionDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_ID_FIELD, ASSET_MODEL_COMPOSITE_MODEL_ID_FIELD, ASSET_MODEL_COMPOSITE_MODEL_EXTERNAL_ID_FIELD, ASSET_MODEL_COMPOSITE_MODEL_PATH_FIELD, ASSET_MODEL_COMPOSITE_MODEL_NAME_FIELD, ASSET_MODEL_COMPOSITE_MODEL_DESCRIPTION_FIELD, ASSET_MODEL_COMPOSITE_MODEL_TYPE_FIELD, ASSET_MODEL_COMPOSITE_MODEL_PROPERTIES_FIELD, COMPOSITION_DETAILS_FIELD, ASSET_MODEL_COMPOSITE_MODEL_SUMMARIES_FIELD, ACTION_DEFINITIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAssetModelCompositeModelResponse.memberNameToFieldInitializer();
    private final String assetModelId;
    private final String assetModelCompositeModelId;
    private final String assetModelCompositeModelExternalId;
    private final List<AssetModelCompositeModelPathSegment> assetModelCompositeModelPath;
    private final String assetModelCompositeModelName;
    private final String assetModelCompositeModelDescription;
    private final String assetModelCompositeModelType;
    private final List<AssetModelProperty> assetModelCompositeModelProperties;
    private final CompositionDetails compositionDetails;
    private final List<AssetModelCompositeModelSummary> assetModelCompositeModelSummaries;
    private final List<ActionDefinition> actionDefinitions;

    private DescribeAssetModelCompositeModelResponse(BuilderImpl builder) {
        super(builder);
        this.assetModelId = builder.assetModelId;
        this.assetModelCompositeModelId = builder.assetModelCompositeModelId;
        this.assetModelCompositeModelExternalId = builder.assetModelCompositeModelExternalId;
        this.assetModelCompositeModelPath = builder.assetModelCompositeModelPath;
        this.assetModelCompositeModelName = builder.assetModelCompositeModelName;
        this.assetModelCompositeModelDescription = builder.assetModelCompositeModelDescription;
        this.assetModelCompositeModelType = builder.assetModelCompositeModelType;
        this.assetModelCompositeModelProperties = builder.assetModelCompositeModelProperties;
        this.compositionDetails = builder.compositionDetails;
        this.assetModelCompositeModelSummaries = builder.assetModelCompositeModelSummaries;
        this.actionDefinitions = builder.actionDefinitions;
    }

    public final String assetModelId() {
        return this.assetModelId;
    }

    public final String assetModelCompositeModelId() {
        return this.assetModelCompositeModelId;
    }

    public final String assetModelCompositeModelExternalId() {
        return this.assetModelCompositeModelExternalId;
    }

    public final boolean hasAssetModelCompositeModelPath() {
        return this.assetModelCompositeModelPath != null && !(this.assetModelCompositeModelPath instanceof SdkAutoConstructList);
    }

    public final List<AssetModelCompositeModelPathSegment> assetModelCompositeModelPath() {
        return this.assetModelCompositeModelPath;
    }

    public final String assetModelCompositeModelName() {
        return this.assetModelCompositeModelName;
    }

    public final String assetModelCompositeModelDescription() {
        return this.assetModelCompositeModelDescription;
    }

    public final String assetModelCompositeModelType() {
        return this.assetModelCompositeModelType;
    }

    public final boolean hasAssetModelCompositeModelProperties() {
        return this.assetModelCompositeModelProperties != null && !(this.assetModelCompositeModelProperties instanceof SdkAutoConstructList);
    }

    public final List<AssetModelProperty> assetModelCompositeModelProperties() {
        return this.assetModelCompositeModelProperties;
    }

    public final CompositionDetails compositionDetails() {
        return this.compositionDetails;
    }

    public final boolean hasAssetModelCompositeModelSummaries() {
        return this.assetModelCompositeModelSummaries != null && !(this.assetModelCompositeModelSummaries instanceof SdkAutoConstructList);
    }

    public final List<AssetModelCompositeModelSummary> assetModelCompositeModelSummaries() {
        return this.assetModelCompositeModelSummaries;
    }

    public final boolean hasActionDefinitions() {
        return this.actionDefinitions != null && !(this.actionDefinitions instanceof SdkAutoConstructList);
    }

    public final List<ActionDefinition> actionDefinitions() {
        return this.actionDefinitions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelCompositeModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelCompositeModelExternalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetModelCompositeModelPath() ? this.assetModelCompositeModelPath() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelCompositeModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelCompositeModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelCompositeModelType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetModelCompositeModelProperties() ? this.assetModelCompositeModelProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.compositionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetModelCompositeModelSummaries() ? this.assetModelCompositeModelSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionDefinitions() ? this.actionDefinitions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssetModelCompositeModelResponse)) {
            return false;
        }
        DescribeAssetModelCompositeModelResponse other = (DescribeAssetModelCompositeModelResponse)((Object)obj);
        return Objects.equals(this.assetModelId(), other.assetModelId()) && Objects.equals(this.assetModelCompositeModelId(), other.assetModelCompositeModelId()) && Objects.equals(this.assetModelCompositeModelExternalId(), other.assetModelCompositeModelExternalId()) && this.hasAssetModelCompositeModelPath() == other.hasAssetModelCompositeModelPath() && Objects.equals(this.assetModelCompositeModelPath(), other.assetModelCompositeModelPath()) && Objects.equals(this.assetModelCompositeModelName(), other.assetModelCompositeModelName()) && Objects.equals(this.assetModelCompositeModelDescription(), other.assetModelCompositeModelDescription()) && Objects.equals(this.assetModelCompositeModelType(), other.assetModelCompositeModelType()) && this.hasAssetModelCompositeModelProperties() == other.hasAssetModelCompositeModelProperties() && Objects.equals(this.assetModelCompositeModelProperties(), other.assetModelCompositeModelProperties()) && Objects.equals(this.compositionDetails(), other.compositionDetails()) && this.hasAssetModelCompositeModelSummaries() == other.hasAssetModelCompositeModelSummaries() && Objects.equals(this.assetModelCompositeModelSummaries(), other.assetModelCompositeModelSummaries()) && this.hasActionDefinitions() == other.hasActionDefinitions() && Objects.equals(this.actionDefinitions(), other.actionDefinitions());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAssetModelCompositeModelResponse").add("AssetModelId", (Object)this.assetModelId()).add("AssetModelCompositeModelId", (Object)this.assetModelCompositeModelId()).add("AssetModelCompositeModelExternalId", (Object)this.assetModelCompositeModelExternalId()).add("AssetModelCompositeModelPath", this.hasAssetModelCompositeModelPath() ? this.assetModelCompositeModelPath() : null).add("AssetModelCompositeModelName", (Object)this.assetModelCompositeModelName()).add("AssetModelCompositeModelDescription", (Object)this.assetModelCompositeModelDescription()).add("AssetModelCompositeModelType", (Object)this.assetModelCompositeModelType()).add("AssetModelCompositeModelProperties", this.hasAssetModelCompositeModelProperties() ? this.assetModelCompositeModelProperties() : null).add("CompositionDetails", (Object)this.compositionDetails()).add("AssetModelCompositeModelSummaries", this.hasAssetModelCompositeModelSummaries() ? this.assetModelCompositeModelSummaries() : null).add("ActionDefinitions", this.hasActionDefinitions() ? this.actionDefinitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetModelId": {
                return Optional.ofNullable(clazz.cast(this.assetModelId()));
            }
            case "assetModelCompositeModelId": {
                return Optional.ofNullable(clazz.cast(this.assetModelCompositeModelId()));
            }
            case "assetModelCompositeModelExternalId": {
                return Optional.ofNullable(clazz.cast(this.assetModelCompositeModelExternalId()));
            }
            case "assetModelCompositeModelPath": {
                return Optional.ofNullable(clazz.cast(this.assetModelCompositeModelPath()));
            }
            case "assetModelCompositeModelName": {
                return Optional.ofNullable(clazz.cast(this.assetModelCompositeModelName()));
            }
            case "assetModelCompositeModelDescription": {
                return Optional.ofNullable(clazz.cast(this.assetModelCompositeModelDescription()));
            }
            case "assetModelCompositeModelType": {
                return Optional.ofNullable(clazz.cast(this.assetModelCompositeModelType()));
            }
            case "assetModelCompositeModelProperties": {
                return Optional.ofNullable(clazz.cast(this.assetModelCompositeModelProperties()));
            }
            case "compositionDetails": {
                return Optional.ofNullable(clazz.cast(this.compositionDetails()));
            }
            case "assetModelCompositeModelSummaries": {
                return Optional.ofNullable(clazz.cast(this.assetModelCompositeModelSummaries()));
            }
            case "actionDefinitions": {
                return Optional.ofNullable(clazz.cast(this.actionDefinitions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assetModelId", ASSET_MODEL_ID_FIELD);
        map.put("assetModelCompositeModelId", ASSET_MODEL_COMPOSITE_MODEL_ID_FIELD);
        map.put("assetModelCompositeModelExternalId", ASSET_MODEL_COMPOSITE_MODEL_EXTERNAL_ID_FIELD);
        map.put("assetModelCompositeModelPath", ASSET_MODEL_COMPOSITE_MODEL_PATH_FIELD);
        map.put("assetModelCompositeModelName", ASSET_MODEL_COMPOSITE_MODEL_NAME_FIELD);
        map.put("assetModelCompositeModelDescription", ASSET_MODEL_COMPOSITE_MODEL_DESCRIPTION_FIELD);
        map.put("assetModelCompositeModelType", ASSET_MODEL_COMPOSITE_MODEL_TYPE_FIELD);
        map.put("assetModelCompositeModelProperties", ASSET_MODEL_COMPOSITE_MODEL_PROPERTIES_FIELD);
        map.put("compositionDetails", COMPOSITION_DETAILS_FIELD);
        map.put("assetModelCompositeModelSummaries", ASSET_MODEL_COMPOSITE_MODEL_SUMMARIES_FIELD);
        map.put("actionDefinitions", ACTION_DEFINITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssetModelCompositeModelResponse, T> g) {
        return obj -> g.apply((DescribeAssetModelCompositeModelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private String assetModelId;
        private String assetModelCompositeModelId;
        private String assetModelCompositeModelExternalId;
        private List<AssetModelCompositeModelPathSegment> assetModelCompositeModelPath = DefaultSdkAutoConstructList.getInstance();
        private String assetModelCompositeModelName;
        private String assetModelCompositeModelDescription;
        private String assetModelCompositeModelType;
        private List<AssetModelProperty> assetModelCompositeModelProperties = DefaultSdkAutoConstructList.getInstance();
        private CompositionDetails compositionDetails;
        private List<AssetModelCompositeModelSummary> assetModelCompositeModelSummaries = DefaultSdkAutoConstructList.getInstance();
        private List<ActionDefinition> actionDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssetModelCompositeModelResponse model) {
            super(model);
            this.assetModelId(model.assetModelId);
            this.assetModelCompositeModelId(model.assetModelCompositeModelId);
            this.assetModelCompositeModelExternalId(model.assetModelCompositeModelExternalId);
            this.assetModelCompositeModelPath(model.assetModelCompositeModelPath);
            this.assetModelCompositeModelName(model.assetModelCompositeModelName);
            this.assetModelCompositeModelDescription(model.assetModelCompositeModelDescription);
            this.assetModelCompositeModelType(model.assetModelCompositeModelType);
            this.assetModelCompositeModelProperties(model.assetModelCompositeModelProperties);
            this.compositionDetails(model.compositionDetails);
            this.assetModelCompositeModelSummaries(model.assetModelCompositeModelSummaries);
            this.actionDefinitions(model.actionDefinitions);
        }

        public final String getAssetModelId() {
            return this.assetModelId;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final String getAssetModelCompositeModelId() {
            return this.assetModelCompositeModelId;
        }

        public final void setAssetModelCompositeModelId(String assetModelCompositeModelId) {
            this.assetModelCompositeModelId = assetModelCompositeModelId;
        }

        @Override
        public final Builder assetModelCompositeModelId(String assetModelCompositeModelId) {
            this.assetModelCompositeModelId = assetModelCompositeModelId;
            return this;
        }

        public final String getAssetModelCompositeModelExternalId() {
            return this.assetModelCompositeModelExternalId;
        }

        public final void setAssetModelCompositeModelExternalId(String assetModelCompositeModelExternalId) {
            this.assetModelCompositeModelExternalId = assetModelCompositeModelExternalId;
        }

        @Override
        public final Builder assetModelCompositeModelExternalId(String assetModelCompositeModelExternalId) {
            this.assetModelCompositeModelExternalId = assetModelCompositeModelExternalId;
            return this;
        }

        public final List<AssetModelCompositeModelPathSegment.Builder> getAssetModelCompositeModelPath() {
            List<AssetModelCompositeModelPathSegment.Builder> result = AssetModelCompositeModelPathCopier.copyToBuilder(this.assetModelCompositeModelPath);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetModelCompositeModelPath(Collection<AssetModelCompositeModelPathSegment.BuilderImpl> assetModelCompositeModelPath) {
            this.assetModelCompositeModelPath = AssetModelCompositeModelPathCopier.copyFromBuilder(assetModelCompositeModelPath);
        }

        @Override
        public final Builder assetModelCompositeModelPath(Collection<AssetModelCompositeModelPathSegment> assetModelCompositeModelPath) {
            this.assetModelCompositeModelPath = AssetModelCompositeModelPathCopier.copy(assetModelCompositeModelPath);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModelPath(AssetModelCompositeModelPathSegment ... assetModelCompositeModelPath) {
            this.assetModelCompositeModelPath(Arrays.asList(assetModelCompositeModelPath));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModelPath(Consumer<AssetModelCompositeModelPathSegment.Builder> ... assetModelCompositeModelPath) {
            this.assetModelCompositeModelPath(Stream.of(assetModelCompositeModelPath).map(c -> (AssetModelCompositeModelPathSegment)((AssetModelCompositeModelPathSegment.Builder)AssetModelCompositeModelPathSegment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAssetModelCompositeModelName() {
            return this.assetModelCompositeModelName;
        }

        public final void setAssetModelCompositeModelName(String assetModelCompositeModelName) {
            this.assetModelCompositeModelName = assetModelCompositeModelName;
        }

        @Override
        public final Builder assetModelCompositeModelName(String assetModelCompositeModelName) {
            this.assetModelCompositeModelName = assetModelCompositeModelName;
            return this;
        }

        public final String getAssetModelCompositeModelDescription() {
            return this.assetModelCompositeModelDescription;
        }

        public final void setAssetModelCompositeModelDescription(String assetModelCompositeModelDescription) {
            this.assetModelCompositeModelDescription = assetModelCompositeModelDescription;
        }

        @Override
        public final Builder assetModelCompositeModelDescription(String assetModelCompositeModelDescription) {
            this.assetModelCompositeModelDescription = assetModelCompositeModelDescription;
            return this;
        }

        public final String getAssetModelCompositeModelType() {
            return this.assetModelCompositeModelType;
        }

        public final void setAssetModelCompositeModelType(String assetModelCompositeModelType) {
            this.assetModelCompositeModelType = assetModelCompositeModelType;
        }

        @Override
        public final Builder assetModelCompositeModelType(String assetModelCompositeModelType) {
            this.assetModelCompositeModelType = assetModelCompositeModelType;
            return this;
        }

        public final List<AssetModelProperty.Builder> getAssetModelCompositeModelProperties() {
            List<AssetModelProperty.Builder> result = AssetModelPropertiesCopier.copyToBuilder(this.assetModelCompositeModelProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetModelCompositeModelProperties(Collection<AssetModelProperty.BuilderImpl> assetModelCompositeModelProperties) {
            this.assetModelCompositeModelProperties = AssetModelPropertiesCopier.copyFromBuilder(assetModelCompositeModelProperties);
        }

        @Override
        public final Builder assetModelCompositeModelProperties(Collection<AssetModelProperty> assetModelCompositeModelProperties) {
            this.assetModelCompositeModelProperties = AssetModelPropertiesCopier.copy(assetModelCompositeModelProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModelProperties(AssetModelProperty ... assetModelCompositeModelProperties) {
            this.assetModelCompositeModelProperties(Arrays.asList(assetModelCompositeModelProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModelProperties(Consumer<AssetModelProperty.Builder> ... assetModelCompositeModelProperties) {
            this.assetModelCompositeModelProperties(Stream.of(assetModelCompositeModelProperties).map(c -> (AssetModelProperty)((AssetModelProperty.Builder)AssetModelProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CompositionDetails.Builder getCompositionDetails() {
            return this.compositionDetails != null ? this.compositionDetails.toBuilder() : null;
        }

        public final void setCompositionDetails(CompositionDetails.BuilderImpl compositionDetails) {
            this.compositionDetails = compositionDetails != null ? compositionDetails.build() : null;
        }

        @Override
        public final Builder compositionDetails(CompositionDetails compositionDetails) {
            this.compositionDetails = compositionDetails;
            return this;
        }

        public final List<AssetModelCompositeModelSummary.Builder> getAssetModelCompositeModelSummaries() {
            List<AssetModelCompositeModelSummary.Builder> result = AssetModelCompositeModelSummariesCopier.copyToBuilder(this.assetModelCompositeModelSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetModelCompositeModelSummaries(Collection<AssetModelCompositeModelSummary.BuilderImpl> assetModelCompositeModelSummaries) {
            this.assetModelCompositeModelSummaries = AssetModelCompositeModelSummariesCopier.copyFromBuilder(assetModelCompositeModelSummaries);
        }

        @Override
        public final Builder assetModelCompositeModelSummaries(Collection<AssetModelCompositeModelSummary> assetModelCompositeModelSummaries) {
            this.assetModelCompositeModelSummaries = AssetModelCompositeModelSummariesCopier.copy(assetModelCompositeModelSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModelSummaries(AssetModelCompositeModelSummary ... assetModelCompositeModelSummaries) {
            this.assetModelCompositeModelSummaries(Arrays.asList(assetModelCompositeModelSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModelSummaries(Consumer<AssetModelCompositeModelSummary.Builder> ... assetModelCompositeModelSummaries) {
            this.assetModelCompositeModelSummaries(Stream.of(assetModelCompositeModelSummaries).map(c -> (AssetModelCompositeModelSummary)((AssetModelCompositeModelSummary.Builder)AssetModelCompositeModelSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ActionDefinition.Builder> getActionDefinitions() {
            List<ActionDefinition.Builder> result = ActionDefinitionsCopier.copyToBuilder(this.actionDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionDefinitions(Collection<ActionDefinition.BuilderImpl> actionDefinitions) {
            this.actionDefinitions = ActionDefinitionsCopier.copyFromBuilder(actionDefinitions);
        }

        @Override
        public final Builder actionDefinitions(Collection<ActionDefinition> actionDefinitions) {
            this.actionDefinitions = ActionDefinitionsCopier.copy(actionDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionDefinitions(ActionDefinition ... actionDefinitions) {
            this.actionDefinitions(Arrays.asList(actionDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionDefinitions(Consumer<ActionDefinition.Builder> ... actionDefinitions) {
            this.actionDefinitions(Stream.of(actionDefinitions).map(c -> (ActionDefinition)((ActionDefinition.Builder)ActionDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeAssetModelCompositeModelResponse build() {
            return new DescribeAssetModelCompositeModelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAssetModelCompositeModelResponse> {
        public Builder assetModelId(String var1);

        public Builder assetModelCompositeModelId(String var1);

        public Builder assetModelCompositeModelExternalId(String var1);

        public Builder assetModelCompositeModelPath(Collection<AssetModelCompositeModelPathSegment> var1);

        public Builder assetModelCompositeModelPath(AssetModelCompositeModelPathSegment ... var1);

        public Builder assetModelCompositeModelPath(Consumer<AssetModelCompositeModelPathSegment.Builder> ... var1);

        public Builder assetModelCompositeModelName(String var1);

        public Builder assetModelCompositeModelDescription(String var1);

        public Builder assetModelCompositeModelType(String var1);

        public Builder assetModelCompositeModelProperties(Collection<AssetModelProperty> var1);

        public Builder assetModelCompositeModelProperties(AssetModelProperty ... var1);

        public Builder assetModelCompositeModelProperties(Consumer<AssetModelProperty.Builder> ... var1);

        public Builder compositionDetails(CompositionDetails var1);

        default public Builder compositionDetails(Consumer<CompositionDetails.Builder> compositionDetails) {
            return this.compositionDetails((CompositionDetails)((CompositionDetails.Builder)CompositionDetails.builder().applyMutation(compositionDetails)).build());
        }

        public Builder assetModelCompositeModelSummaries(Collection<AssetModelCompositeModelSummary> var1);

        public Builder assetModelCompositeModelSummaries(AssetModelCompositeModelSummary ... var1);

        public Builder assetModelCompositeModelSummaries(Consumer<AssetModelCompositeModelSummary.Builder> ... var1);

        public Builder actionDefinitions(Collection<ActionDefinition> var1);

        public Builder actionDefinitions(ActionDefinition ... var1);

        public Builder actionDefinitions(Consumer<ActionDefinition.Builder> ... var1);
    }
}

