/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.AggregatedValue;
import software.amazon.awssdk.services.iotsitewise.model.AggregatedValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetAssetPropertyAggregatesSuccessEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchGetAssetPropertyAggregatesSuccessEntry> {
    private static final SdkField<String> ENTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entryId").getter(BatchGetAssetPropertyAggregatesSuccessEntry.getter(BatchGetAssetPropertyAggregatesSuccessEntry::entryId)).setter(BatchGetAssetPropertyAggregatesSuccessEntry.setter(Builder::entryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryId").build()}).build();
    private static final SdkField<List<AggregatedValue>> AGGREGATED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("aggregatedValues").getter(BatchGetAssetPropertyAggregatesSuccessEntry.getter(BatchGetAssetPropertyAggregatesSuccessEntry::aggregatedValues)).setter(BatchGetAssetPropertyAggregatesSuccessEntry.setter(Builder::aggregatedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregatedValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AggregatedValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_ID_FIELD, AGGREGATED_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetAssetPropertyAggregatesSuccessEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String entryId;
    private final List<AggregatedValue> aggregatedValues;

    private BatchGetAssetPropertyAggregatesSuccessEntry(BuilderImpl builder) {
        this.entryId = builder.entryId;
        this.aggregatedValues = builder.aggregatedValues;
    }

    public final String entryId() {
        return this.entryId;
    }

    public final boolean hasAggregatedValues() {
        return this.aggregatedValues != null && !(this.aggregatedValues instanceof SdkAutoConstructList);
    }

    public final List<AggregatedValue> aggregatedValues() {
        return this.aggregatedValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregatedValues() ? this.aggregatedValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAssetPropertyAggregatesSuccessEntry)) {
            return false;
        }
        BatchGetAssetPropertyAggregatesSuccessEntry other = (BatchGetAssetPropertyAggregatesSuccessEntry)obj;
        return Objects.equals(this.entryId(), other.entryId()) && this.hasAggregatedValues() == other.hasAggregatedValues() && Objects.equals(this.aggregatedValues(), other.aggregatedValues());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetAssetPropertyAggregatesSuccessEntry").add("EntryId", (Object)this.entryId()).add("AggregatedValues", this.hasAggregatedValues() ? this.aggregatedValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entryId": {
                return Optional.ofNullable(clazz.cast(this.entryId()));
            }
            case "aggregatedValues": {
                return Optional.ofNullable(clazz.cast(this.aggregatedValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("entryId", ENTRY_ID_FIELD);
        map.put("aggregatedValues", AGGREGATED_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAssetPropertyAggregatesSuccessEntry, T> g) {
        return obj -> g.apply((BatchGetAssetPropertyAggregatesSuccessEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String entryId;
        private List<AggregatedValue> aggregatedValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAssetPropertyAggregatesSuccessEntry model) {
            this.entryId(model.entryId);
            this.aggregatedValues(model.aggregatedValues);
        }

        public final String getEntryId() {
            return this.entryId;
        }

        public final void setEntryId(String entryId) {
            this.entryId = entryId;
        }

        @Override
        public final Builder entryId(String entryId) {
            this.entryId = entryId;
            return this;
        }

        public final List<AggregatedValue.Builder> getAggregatedValues() {
            List<AggregatedValue.Builder> result = AggregatedValuesCopier.copyToBuilder(this.aggregatedValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregatedValues(Collection<AggregatedValue.BuilderImpl> aggregatedValues) {
            this.aggregatedValues = AggregatedValuesCopier.copyFromBuilder(aggregatedValues);
        }

        @Override
        public final Builder aggregatedValues(Collection<AggregatedValue> aggregatedValues) {
            this.aggregatedValues = AggregatedValuesCopier.copy(aggregatedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatedValues(AggregatedValue ... aggregatedValues) {
            this.aggregatedValues(Arrays.asList(aggregatedValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatedValues(Consumer<AggregatedValue.Builder> ... aggregatedValues) {
            this.aggregatedValues(Stream.of(aggregatedValues).map(c -> (AggregatedValue)((AggregatedValue.Builder)AggregatedValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public BatchGetAssetPropertyAggregatesSuccessEntry build() {
            return new BatchGetAssetPropertyAggregatesSuccessEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchGetAssetPropertyAggregatesSuccessEntry> {
        public Builder entryId(String var1);

        public Builder aggregatedValues(Collection<AggregatedValue> var1);

        public Builder aggregatedValues(AggregatedValue ... var1);

        public Builder aggregatedValues(Consumer<AggregatedValue.Builder> ... var1);
    }
}

