/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.DatasetSource;
import software.amazon.awssdk.services.iotsitewise.model.DatasetStatus;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDatasetResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, DescribeDatasetResponse> {
    private static final SdkField<String> DATASET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetId").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::datasetId)).setter(DescribeDatasetResponse.setter(Builder::datasetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetId").build()}).build();
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetArn").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::datasetArn)).setter(DescribeDatasetResponse.setter(Builder::datasetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetArn").build()}).build();
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetName").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::datasetName)).setter(DescribeDatasetResponse.setter(Builder::datasetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetName").build()}).build();
    private static final SdkField<String> DATASET_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetDescription").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::datasetDescription)).setter(DescribeDatasetResponse.setter(Builder::datasetDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetDescription").build()}).build();
    private static final SdkField<DatasetSource> DATASET_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("datasetSource").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::datasetSource)).setter(DescribeDatasetResponse.setter(Builder::datasetSource)).constructor(DatasetSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetSource").build()}).build();
    private static final SdkField<DatasetStatus> DATASET_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("datasetStatus").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::datasetStatus)).setter(DescribeDatasetResponse.setter(Builder::datasetStatus)).constructor(DatasetStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetStatus").build()}).build();
    private static final SdkField<Instant> DATASET_CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("datasetCreationDate").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::datasetCreationDate)).setter(DescribeDatasetResponse.setter(Builder::datasetCreationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetCreationDate").build()}).build();
    private static final SdkField<Instant> DATASET_LAST_UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("datasetLastUpdateDate").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::datasetLastUpdateDate)).setter(DescribeDatasetResponse.setter(Builder::datasetLastUpdateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetLastUpdateDate").build()}).build();
    private static final SdkField<String> DATASET_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetVersion").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::datasetVersion)).setter(DescribeDatasetResponse.setter(Builder::datasetVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_ID_FIELD, DATASET_ARN_FIELD, DATASET_NAME_FIELD, DATASET_DESCRIPTION_FIELD, DATASET_SOURCE_FIELD, DATASET_STATUS_FIELD, DATASET_CREATION_DATE_FIELD, DATASET_LAST_UPDATE_DATE_FIELD, DATASET_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeDatasetResponse.memberNameToFieldInitializer();
    private final String datasetId;
    private final String datasetArn;
    private final String datasetName;
    private final String datasetDescription;
    private final DatasetSource datasetSource;
    private final DatasetStatus datasetStatus;
    private final Instant datasetCreationDate;
    private final Instant datasetLastUpdateDate;
    private final String datasetVersion;

    private DescribeDatasetResponse(BuilderImpl builder) {
        super(builder);
        this.datasetId = builder.datasetId;
        this.datasetArn = builder.datasetArn;
        this.datasetName = builder.datasetName;
        this.datasetDescription = builder.datasetDescription;
        this.datasetSource = builder.datasetSource;
        this.datasetStatus = builder.datasetStatus;
        this.datasetCreationDate = builder.datasetCreationDate;
        this.datasetLastUpdateDate = builder.datasetLastUpdateDate;
        this.datasetVersion = builder.datasetVersion;
    }

    public final String datasetId() {
        return this.datasetId;
    }

    public final String datasetArn() {
        return this.datasetArn;
    }

    public final String datasetName() {
        return this.datasetName;
    }

    public final String datasetDescription() {
        return this.datasetDescription;
    }

    public final DatasetSource datasetSource() {
        return this.datasetSource;
    }

    public final DatasetStatus datasetStatus() {
        return this.datasetStatus;
    }

    public final Instant datasetCreationDate() {
        return this.datasetCreationDate;
    }

    public final Instant datasetLastUpdateDate() {
        return this.datasetLastUpdateDate;
    }

    public final String datasetVersion() {
        return this.datasetVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetLastUpdateDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDatasetResponse)) {
            return false;
        }
        DescribeDatasetResponse other = (DescribeDatasetResponse)((Object)obj);
        return Objects.equals(this.datasetId(), other.datasetId()) && Objects.equals(this.datasetArn(), other.datasetArn()) && Objects.equals(this.datasetName(), other.datasetName()) && Objects.equals(this.datasetDescription(), other.datasetDescription()) && Objects.equals(this.datasetSource(), other.datasetSource()) && Objects.equals(this.datasetStatus(), other.datasetStatus()) && Objects.equals(this.datasetCreationDate(), other.datasetCreationDate()) && Objects.equals(this.datasetLastUpdateDate(), other.datasetLastUpdateDate()) && Objects.equals(this.datasetVersion(), other.datasetVersion());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDatasetResponse").add("DatasetId", (Object)this.datasetId()).add("DatasetArn", (Object)this.datasetArn()).add("DatasetName", (Object)this.datasetName()).add("DatasetDescription", (Object)this.datasetDescription()).add("DatasetSource", (Object)this.datasetSource()).add("DatasetStatus", (Object)this.datasetStatus()).add("DatasetCreationDate", (Object)this.datasetCreationDate()).add("DatasetLastUpdateDate", (Object)this.datasetLastUpdateDate()).add("DatasetVersion", (Object)this.datasetVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datasetId": {
                return Optional.ofNullable(clazz.cast(this.datasetId()));
            }
            case "datasetArn": {
                return Optional.ofNullable(clazz.cast(this.datasetArn()));
            }
            case "datasetName": {
                return Optional.ofNullable(clazz.cast(this.datasetName()));
            }
            case "datasetDescription": {
                return Optional.ofNullable(clazz.cast(this.datasetDescription()));
            }
            case "datasetSource": {
                return Optional.ofNullable(clazz.cast(this.datasetSource()));
            }
            case "datasetStatus": {
                return Optional.ofNullable(clazz.cast(this.datasetStatus()));
            }
            case "datasetCreationDate": {
                return Optional.ofNullable(clazz.cast(this.datasetCreationDate()));
            }
            case "datasetLastUpdateDate": {
                return Optional.ofNullable(clazz.cast(this.datasetLastUpdateDate()));
            }
            case "datasetVersion": {
                return Optional.ofNullable(clazz.cast(this.datasetVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("datasetId", DATASET_ID_FIELD);
        map.put("datasetArn", DATASET_ARN_FIELD);
        map.put("datasetName", DATASET_NAME_FIELD);
        map.put("datasetDescription", DATASET_DESCRIPTION_FIELD);
        map.put("datasetSource", DATASET_SOURCE_FIELD);
        map.put("datasetStatus", DATASET_STATUS_FIELD);
        map.put("datasetCreationDate", DATASET_CREATION_DATE_FIELD);
        map.put("datasetLastUpdateDate", DATASET_LAST_UPDATE_DATE_FIELD);
        map.put("datasetVersion", DATASET_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDatasetResponse, T> g) {
        return obj -> g.apply((DescribeDatasetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private String datasetId;
        private String datasetArn;
        private String datasetName;
        private String datasetDescription;
        private DatasetSource datasetSource;
        private DatasetStatus datasetStatus;
        private Instant datasetCreationDate;
        private Instant datasetLastUpdateDate;
        private String datasetVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDatasetResponse model) {
            super(model);
            this.datasetId(model.datasetId);
            this.datasetArn(model.datasetArn);
            this.datasetName(model.datasetName);
            this.datasetDescription(model.datasetDescription);
            this.datasetSource(model.datasetSource);
            this.datasetStatus(model.datasetStatus);
            this.datasetCreationDate(model.datasetCreationDate);
            this.datasetLastUpdateDate(model.datasetLastUpdateDate);
            this.datasetVersion(model.datasetVersion);
        }

        public final String getDatasetId() {
            return this.datasetId;
        }

        public final void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        @Override
        public final Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public final String getDatasetArn() {
            return this.datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final String getDatasetName() {
            return this.datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final String getDatasetDescription() {
            return this.datasetDescription;
        }

        public final void setDatasetDescription(String datasetDescription) {
            this.datasetDescription = datasetDescription;
        }

        @Override
        public final Builder datasetDescription(String datasetDescription) {
            this.datasetDescription = datasetDescription;
            return this;
        }

        public final DatasetSource.Builder getDatasetSource() {
            return this.datasetSource != null ? this.datasetSource.toBuilder() : null;
        }

        public final void setDatasetSource(DatasetSource.BuilderImpl datasetSource) {
            this.datasetSource = datasetSource != null ? datasetSource.build() : null;
        }

        @Override
        public final Builder datasetSource(DatasetSource datasetSource) {
            this.datasetSource = datasetSource;
            return this;
        }

        public final DatasetStatus.Builder getDatasetStatus() {
            return this.datasetStatus != null ? this.datasetStatus.toBuilder() : null;
        }

        public final void setDatasetStatus(DatasetStatus.BuilderImpl datasetStatus) {
            this.datasetStatus = datasetStatus != null ? datasetStatus.build() : null;
        }

        @Override
        public final Builder datasetStatus(DatasetStatus datasetStatus) {
            this.datasetStatus = datasetStatus;
            return this;
        }

        public final Instant getDatasetCreationDate() {
            return this.datasetCreationDate;
        }

        public final void setDatasetCreationDate(Instant datasetCreationDate) {
            this.datasetCreationDate = datasetCreationDate;
        }

        @Override
        public final Builder datasetCreationDate(Instant datasetCreationDate) {
            this.datasetCreationDate = datasetCreationDate;
            return this;
        }

        public final Instant getDatasetLastUpdateDate() {
            return this.datasetLastUpdateDate;
        }

        public final void setDatasetLastUpdateDate(Instant datasetLastUpdateDate) {
            this.datasetLastUpdateDate = datasetLastUpdateDate;
        }

        @Override
        public final Builder datasetLastUpdateDate(Instant datasetLastUpdateDate) {
            this.datasetLastUpdateDate = datasetLastUpdateDate;
            return this;
        }

        public final String getDatasetVersion() {
            return this.datasetVersion;
        }

        public final void setDatasetVersion(String datasetVersion) {
            this.datasetVersion = datasetVersion;
        }

        @Override
        public final Builder datasetVersion(String datasetVersion) {
            this.datasetVersion = datasetVersion;
            return this;
        }

        @Override
        public DescribeDatasetResponse build() {
            return new DescribeDatasetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDatasetResponse> {
        public Builder datasetId(String var1);

        public Builder datasetArn(String var1);

        public Builder datasetName(String var1);

        public Builder datasetDescription(String var1);

        public Builder datasetSource(DatasetSource var1);

        default public Builder datasetSource(Consumer<DatasetSource.Builder> datasetSource) {
            return this.datasetSource((DatasetSource)((DatasetSource.Builder)DatasetSource.builder().applyMutation(datasetSource)).build());
        }

        public Builder datasetStatus(DatasetStatus var1);

        default public Builder datasetStatus(Consumer<DatasetStatus.Builder> datasetStatus) {
            return this.datasetStatus((DatasetStatus)((DatasetStatus.Builder)DatasetStatus.builder().applyMutation(datasetStatus)).build());
        }

        public Builder datasetCreationDate(Instant var1);

        public Builder datasetLastUpdateDate(Instant var1);

        public Builder datasetVersion(String var1);
    }
}

