/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.DatasetStatus;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDatasetResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, CreateDatasetResponse> {
    private static final SdkField<String> DATASET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetId").getter(CreateDatasetResponse.getter(CreateDatasetResponse::datasetId)).setter(CreateDatasetResponse.setter(Builder::datasetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetId").build()}).build();
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetArn").getter(CreateDatasetResponse.getter(CreateDatasetResponse::datasetArn)).setter(CreateDatasetResponse.setter(Builder::datasetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetArn").build()}).build();
    private static final SdkField<DatasetStatus> DATASET_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("datasetStatus").getter(CreateDatasetResponse.getter(CreateDatasetResponse::datasetStatus)).setter(CreateDatasetResponse.setter(Builder::datasetStatus)).constructor(DatasetStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_ID_FIELD, DATASET_ARN_FIELD, DATASET_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDatasetResponse.memberNameToFieldInitializer();
    private final String datasetId;
    private final String datasetArn;
    private final DatasetStatus datasetStatus;

    private CreateDatasetResponse(BuilderImpl builder) {
        super(builder);
        this.datasetId = builder.datasetId;
        this.datasetArn = builder.datasetArn;
        this.datasetStatus = builder.datasetStatus;
    }

    public final String datasetId() {
        return this.datasetId;
    }

    public final String datasetArn() {
        return this.datasetArn;
    }

    public final DatasetStatus datasetStatus() {
        return this.datasetStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatasetResponse)) {
            return false;
        }
        CreateDatasetResponse other = (CreateDatasetResponse)((Object)obj);
        return Objects.equals(this.datasetId(), other.datasetId()) && Objects.equals(this.datasetArn(), other.datasetArn()) && Objects.equals(this.datasetStatus(), other.datasetStatus());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDatasetResponse").add("DatasetId", (Object)this.datasetId()).add("DatasetArn", (Object)this.datasetArn()).add("DatasetStatus", (Object)this.datasetStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datasetId": {
                return Optional.ofNullable(clazz.cast(this.datasetId()));
            }
            case "datasetArn": {
                return Optional.ofNullable(clazz.cast(this.datasetArn()));
            }
            case "datasetStatus": {
                return Optional.ofNullable(clazz.cast(this.datasetStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("datasetId", DATASET_ID_FIELD);
        map.put("datasetArn", DATASET_ARN_FIELD);
        map.put("datasetStatus", DATASET_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDatasetResponse, T> g) {
        return obj -> g.apply((CreateDatasetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private String datasetId;
        private String datasetArn;
        private DatasetStatus datasetStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDatasetResponse model) {
            super(model);
            this.datasetId(model.datasetId);
            this.datasetArn(model.datasetArn);
            this.datasetStatus(model.datasetStatus);
        }

        public final String getDatasetId() {
            return this.datasetId;
        }

        public final void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        @Override
        public final Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public final String getDatasetArn() {
            return this.datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final DatasetStatus.Builder getDatasetStatus() {
            return this.datasetStatus != null ? this.datasetStatus.toBuilder() : null;
        }

        public final void setDatasetStatus(DatasetStatus.BuilderImpl datasetStatus) {
            this.datasetStatus = datasetStatus != null ? datasetStatus.build() : null;
        }

        @Override
        public final Builder datasetStatus(DatasetStatus datasetStatus) {
            this.datasetStatus = datasetStatus;
            return this;
        }

        @Override
        public CreateDatasetResponse build() {
            return new CreateDatasetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDatasetResponse> {
        public Builder datasetId(String var1);

        public Builder datasetArn(String var1);

        public Builder datasetStatus(DatasetStatus var1);

        default public Builder datasetStatus(Consumer<DatasetStatus.Builder> datasetStatus) {
            return this.datasetStatus((DatasetStatus)((DatasetStatus.Builder)DatasetStatus.builder().applyMutation(datasetStatus)).build());
        }
    }
}

