/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModelDefinition;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModelDefinitionsCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelHierarchyDefinition;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelHierarchyDefinitionsCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertyDefinition;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertyDefinitionsCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelType;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.services.iotsitewise.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAssetModelRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, CreateAssetModelRequest> {
    private static final SdkField<String> ASSET_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelName").getter(CreateAssetModelRequest.getter(CreateAssetModelRequest::assetModelName)).setter(CreateAssetModelRequest.setter(Builder::assetModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelName").build()}).build();
    private static final SdkField<String> ASSET_MODEL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelType").getter(CreateAssetModelRequest.getter(CreateAssetModelRequest::assetModelTypeAsString)).setter(CreateAssetModelRequest.setter(Builder::assetModelType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelType").build()}).build();
    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelId").getter(CreateAssetModelRequest.getter(CreateAssetModelRequest::assetModelId)).setter(CreateAssetModelRequest.setter(Builder::assetModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelId").build()}).build();
    private static final SdkField<String> ASSET_MODEL_EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelExternalId").getter(CreateAssetModelRequest.getter(CreateAssetModelRequest::assetModelExternalId)).setter(CreateAssetModelRequest.setter(Builder::assetModelExternalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelExternalId").build()}).build();
    private static final SdkField<String> ASSET_MODEL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelDescription").getter(CreateAssetModelRequest.getter(CreateAssetModelRequest::assetModelDescription)).setter(CreateAssetModelRequest.setter(Builder::assetModelDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelDescription").build()}).build();
    private static final SdkField<List<AssetModelPropertyDefinition>> ASSET_MODEL_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetModelProperties").getter(CreateAssetModelRequest.getter(CreateAssetModelRequest::assetModelProperties)).setter(CreateAssetModelRequest.setter(Builder::assetModelProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetModelPropertyDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AssetModelHierarchyDefinition>> ASSET_MODEL_HIERARCHIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetModelHierarchies").getter(CreateAssetModelRequest.getter(CreateAssetModelRequest::assetModelHierarchies)).setter(CreateAssetModelRequest.setter(Builder::assetModelHierarchies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelHierarchies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetModelHierarchyDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AssetModelCompositeModelDefinition>> ASSET_MODEL_COMPOSITE_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetModelCompositeModels").getter(CreateAssetModelRequest.getter(CreateAssetModelRequest::assetModelCompositeModels)).setter(CreateAssetModelRequest.setter(Builder::assetModelCompositeModels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetModelCompositeModelDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateAssetModelRequest.getter(CreateAssetModelRequest::clientToken)).setter(CreateAssetModelRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateAssetModelRequest.getter(CreateAssetModelRequest::tags)).setter(CreateAssetModelRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_NAME_FIELD, ASSET_MODEL_TYPE_FIELD, ASSET_MODEL_ID_FIELD, ASSET_MODEL_EXTERNAL_ID_FIELD, ASSET_MODEL_DESCRIPTION_FIELD, ASSET_MODEL_PROPERTIES_FIELD, ASSET_MODEL_HIERARCHIES_FIELD, ASSET_MODEL_COMPOSITE_MODELS_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAssetModelRequest.memberNameToFieldInitializer();
    private final String assetModelName;
    private final String assetModelType;
    private final String assetModelId;
    private final String assetModelExternalId;
    private final String assetModelDescription;
    private final List<AssetModelPropertyDefinition> assetModelProperties;
    private final List<AssetModelHierarchyDefinition> assetModelHierarchies;
    private final List<AssetModelCompositeModelDefinition> assetModelCompositeModels;
    private final String clientToken;
    private final Map<String, String> tags;

    private CreateAssetModelRequest(BuilderImpl builder) {
        super(builder);
        this.assetModelName = builder.assetModelName;
        this.assetModelType = builder.assetModelType;
        this.assetModelId = builder.assetModelId;
        this.assetModelExternalId = builder.assetModelExternalId;
        this.assetModelDescription = builder.assetModelDescription;
        this.assetModelProperties = builder.assetModelProperties;
        this.assetModelHierarchies = builder.assetModelHierarchies;
        this.assetModelCompositeModels = builder.assetModelCompositeModels;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String assetModelName() {
        return this.assetModelName;
    }

    public final AssetModelType assetModelType() {
        return AssetModelType.fromValue(this.assetModelType);
    }

    public final String assetModelTypeAsString() {
        return this.assetModelType;
    }

    public final String assetModelId() {
        return this.assetModelId;
    }

    public final String assetModelExternalId() {
        return this.assetModelExternalId;
    }

    public final String assetModelDescription() {
        return this.assetModelDescription;
    }

    public final boolean hasAssetModelProperties() {
        return this.assetModelProperties != null && !(this.assetModelProperties instanceof SdkAutoConstructList);
    }

    public final List<AssetModelPropertyDefinition> assetModelProperties() {
        return this.assetModelProperties;
    }

    public final boolean hasAssetModelHierarchies() {
        return this.assetModelHierarchies != null && !(this.assetModelHierarchies instanceof SdkAutoConstructList);
    }

    public final List<AssetModelHierarchyDefinition> assetModelHierarchies() {
        return this.assetModelHierarchies;
    }

    public final boolean hasAssetModelCompositeModels() {
        return this.assetModelCompositeModels != null && !(this.assetModelCompositeModels instanceof SdkAutoConstructList);
    }

    public final List<AssetModelCompositeModelDefinition> assetModelCompositeModels() {
        return this.assetModelCompositeModels;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelExternalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetModelProperties() ? this.assetModelProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetModelHierarchies() ? this.assetModelHierarchies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetModelCompositeModels() ? this.assetModelCompositeModels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssetModelRequest)) {
            return false;
        }
        CreateAssetModelRequest other = (CreateAssetModelRequest)((Object)obj);
        return Objects.equals(this.assetModelName(), other.assetModelName()) && Objects.equals(this.assetModelTypeAsString(), other.assetModelTypeAsString()) && Objects.equals(this.assetModelId(), other.assetModelId()) && Objects.equals(this.assetModelExternalId(), other.assetModelExternalId()) && Objects.equals(this.assetModelDescription(), other.assetModelDescription()) && this.hasAssetModelProperties() == other.hasAssetModelProperties() && Objects.equals(this.assetModelProperties(), other.assetModelProperties()) && this.hasAssetModelHierarchies() == other.hasAssetModelHierarchies() && Objects.equals(this.assetModelHierarchies(), other.assetModelHierarchies()) && this.hasAssetModelCompositeModels() == other.hasAssetModelCompositeModels() && Objects.equals(this.assetModelCompositeModels(), other.assetModelCompositeModels()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAssetModelRequest").add("AssetModelName", (Object)this.assetModelName()).add("AssetModelType", (Object)this.assetModelTypeAsString()).add("AssetModelId", (Object)this.assetModelId()).add("AssetModelExternalId", (Object)this.assetModelExternalId()).add("AssetModelDescription", (Object)this.assetModelDescription()).add("AssetModelProperties", this.hasAssetModelProperties() ? this.assetModelProperties() : null).add("AssetModelHierarchies", this.hasAssetModelHierarchies() ? this.assetModelHierarchies() : null).add("AssetModelCompositeModels", this.hasAssetModelCompositeModels() ? this.assetModelCompositeModels() : null).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetModelName": {
                return Optional.ofNullable(clazz.cast(this.assetModelName()));
            }
            case "assetModelType": {
                return Optional.ofNullable(clazz.cast(this.assetModelTypeAsString()));
            }
            case "assetModelId": {
                return Optional.ofNullable(clazz.cast(this.assetModelId()));
            }
            case "assetModelExternalId": {
                return Optional.ofNullable(clazz.cast(this.assetModelExternalId()));
            }
            case "assetModelDescription": {
                return Optional.ofNullable(clazz.cast(this.assetModelDescription()));
            }
            case "assetModelProperties": {
                return Optional.ofNullable(clazz.cast(this.assetModelProperties()));
            }
            case "assetModelHierarchies": {
                return Optional.ofNullable(clazz.cast(this.assetModelHierarchies()));
            }
            case "assetModelCompositeModels": {
                return Optional.ofNullable(clazz.cast(this.assetModelCompositeModels()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assetModelName", ASSET_MODEL_NAME_FIELD);
        map.put("assetModelType", ASSET_MODEL_TYPE_FIELD);
        map.put("assetModelId", ASSET_MODEL_ID_FIELD);
        map.put("assetModelExternalId", ASSET_MODEL_EXTERNAL_ID_FIELD);
        map.put("assetModelDescription", ASSET_MODEL_DESCRIPTION_FIELD);
        map.put("assetModelProperties", ASSET_MODEL_PROPERTIES_FIELD);
        map.put("assetModelHierarchies", ASSET_MODEL_HIERARCHIES_FIELD);
        map.put("assetModelCompositeModels", ASSET_MODEL_COMPOSITE_MODELS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAssetModelRequest, T> g) {
        return obj -> g.apply((CreateAssetModelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String assetModelName;
        private String assetModelType;
        private String assetModelId;
        private String assetModelExternalId;
        private String assetModelDescription;
        private List<AssetModelPropertyDefinition> assetModelProperties = DefaultSdkAutoConstructList.getInstance();
        private List<AssetModelHierarchyDefinition> assetModelHierarchies = DefaultSdkAutoConstructList.getInstance();
        private List<AssetModelCompositeModelDefinition> assetModelCompositeModels = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssetModelRequest model) {
            super(model);
            this.assetModelName(model.assetModelName);
            this.assetModelType(model.assetModelType);
            this.assetModelId(model.assetModelId);
            this.assetModelExternalId(model.assetModelExternalId);
            this.assetModelDescription(model.assetModelDescription);
            this.assetModelProperties(model.assetModelProperties);
            this.assetModelHierarchies(model.assetModelHierarchies);
            this.assetModelCompositeModels(model.assetModelCompositeModels);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getAssetModelName() {
            return this.assetModelName;
        }

        public final void setAssetModelName(String assetModelName) {
            this.assetModelName = assetModelName;
        }

        @Override
        public final Builder assetModelName(String assetModelName) {
            this.assetModelName = assetModelName;
            return this;
        }

        public final String getAssetModelType() {
            return this.assetModelType;
        }

        public final void setAssetModelType(String assetModelType) {
            this.assetModelType = assetModelType;
        }

        @Override
        public final Builder assetModelType(String assetModelType) {
            this.assetModelType = assetModelType;
            return this;
        }

        @Override
        public final Builder assetModelType(AssetModelType assetModelType) {
            this.assetModelType(assetModelType == null ? null : assetModelType.toString());
            return this;
        }

        public final String getAssetModelId() {
            return this.assetModelId;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final String getAssetModelExternalId() {
            return this.assetModelExternalId;
        }

        public final void setAssetModelExternalId(String assetModelExternalId) {
            this.assetModelExternalId = assetModelExternalId;
        }

        @Override
        public final Builder assetModelExternalId(String assetModelExternalId) {
            this.assetModelExternalId = assetModelExternalId;
            return this;
        }

        public final String getAssetModelDescription() {
            return this.assetModelDescription;
        }

        public final void setAssetModelDescription(String assetModelDescription) {
            this.assetModelDescription = assetModelDescription;
        }

        @Override
        public final Builder assetModelDescription(String assetModelDescription) {
            this.assetModelDescription = assetModelDescription;
            return this;
        }

        public final List<AssetModelPropertyDefinition.Builder> getAssetModelProperties() {
            List<AssetModelPropertyDefinition.Builder> result = AssetModelPropertyDefinitionsCopier.copyToBuilder(this.assetModelProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetModelProperties(Collection<AssetModelPropertyDefinition.BuilderImpl> assetModelProperties) {
            this.assetModelProperties = AssetModelPropertyDefinitionsCopier.copyFromBuilder(assetModelProperties);
        }

        @Override
        public final Builder assetModelProperties(Collection<AssetModelPropertyDefinition> assetModelProperties) {
            this.assetModelProperties = AssetModelPropertyDefinitionsCopier.copy(assetModelProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelProperties(AssetModelPropertyDefinition ... assetModelProperties) {
            this.assetModelProperties(Arrays.asList(assetModelProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelProperties(Consumer<AssetModelPropertyDefinition.Builder> ... assetModelProperties) {
            this.assetModelProperties(Stream.of(assetModelProperties).map(c -> (AssetModelPropertyDefinition)((AssetModelPropertyDefinition.Builder)AssetModelPropertyDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AssetModelHierarchyDefinition.Builder> getAssetModelHierarchies() {
            List<AssetModelHierarchyDefinition.Builder> result = AssetModelHierarchyDefinitionsCopier.copyToBuilder(this.assetModelHierarchies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetModelHierarchies(Collection<AssetModelHierarchyDefinition.BuilderImpl> assetModelHierarchies) {
            this.assetModelHierarchies = AssetModelHierarchyDefinitionsCopier.copyFromBuilder(assetModelHierarchies);
        }

        @Override
        public final Builder assetModelHierarchies(Collection<AssetModelHierarchyDefinition> assetModelHierarchies) {
            this.assetModelHierarchies = AssetModelHierarchyDefinitionsCopier.copy(assetModelHierarchies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelHierarchies(AssetModelHierarchyDefinition ... assetModelHierarchies) {
            this.assetModelHierarchies(Arrays.asList(assetModelHierarchies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelHierarchies(Consumer<AssetModelHierarchyDefinition.Builder> ... assetModelHierarchies) {
            this.assetModelHierarchies(Stream.of(assetModelHierarchies).map(c -> (AssetModelHierarchyDefinition)((AssetModelHierarchyDefinition.Builder)AssetModelHierarchyDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AssetModelCompositeModelDefinition.Builder> getAssetModelCompositeModels() {
            List<AssetModelCompositeModelDefinition.Builder> result = AssetModelCompositeModelDefinitionsCopier.copyToBuilder(this.assetModelCompositeModels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetModelCompositeModels(Collection<AssetModelCompositeModelDefinition.BuilderImpl> assetModelCompositeModels) {
            this.assetModelCompositeModels = AssetModelCompositeModelDefinitionsCopier.copyFromBuilder(assetModelCompositeModels);
        }

        @Override
        public final Builder assetModelCompositeModels(Collection<AssetModelCompositeModelDefinition> assetModelCompositeModels) {
            this.assetModelCompositeModels = AssetModelCompositeModelDefinitionsCopier.copy(assetModelCompositeModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModels(AssetModelCompositeModelDefinition ... assetModelCompositeModels) {
            this.assetModelCompositeModels(Arrays.asList(assetModelCompositeModels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModels(Consumer<AssetModelCompositeModelDefinition.Builder> ... assetModelCompositeModels) {
            this.assetModelCompositeModels(Stream.of(assetModelCompositeModels).map(c -> (AssetModelCompositeModelDefinition)((AssetModelCompositeModelDefinition.Builder)AssetModelCompositeModelDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAssetModelRequest build() {
            return new CreateAssetModelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAssetModelRequest> {
        public Builder assetModelName(String var1);

        public Builder assetModelType(String var1);

        public Builder assetModelType(AssetModelType var1);

        public Builder assetModelId(String var1);

        public Builder assetModelExternalId(String var1);

        public Builder assetModelDescription(String var1);

        public Builder assetModelProperties(Collection<AssetModelPropertyDefinition> var1);

        public Builder assetModelProperties(AssetModelPropertyDefinition ... var1);

        public Builder assetModelProperties(Consumer<AssetModelPropertyDefinition.Builder> ... var1);

        public Builder assetModelHierarchies(Collection<AssetModelHierarchyDefinition> var1);

        public Builder assetModelHierarchies(AssetModelHierarchyDefinition ... var1);

        public Builder assetModelHierarchies(Consumer<AssetModelHierarchyDefinition.Builder> ... var1);

        public Builder assetModelCompositeModels(Collection<AssetModelCompositeModelDefinition> var1);

        public Builder assetModelCompositeModels(AssetModelCompositeModelDefinition ... var1);

        public Builder assetModelCompositeModels(Consumer<AssetModelCompositeModelDefinition.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

