/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.IDsCopier;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDisassociateProjectAssetsRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, BatchDisassociateProjectAssetsRequest> {
    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectId").getter(BatchDisassociateProjectAssetsRequest.getter(BatchDisassociateProjectAssetsRequest::projectId)).setter(BatchDisassociateProjectAssetsRequest.setter(Builder::projectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("projectId").build()}).build();
    private static final SdkField<List<String>> ASSET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetIds").getter(BatchDisassociateProjectAssetsRequest.getter(BatchDisassociateProjectAssetsRequest::assetIds)).setter(BatchDisassociateProjectAssetsRequest.setter(Builder::assetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(BatchDisassociateProjectAssetsRequest.getter(BatchDisassociateProjectAssetsRequest::clientToken)).setter(BatchDisassociateProjectAssetsRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ID_FIELD, ASSET_IDS_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchDisassociateProjectAssetsRequest.memberNameToFieldInitializer();
    private final String projectId;
    private final List<String> assetIds;
    private final String clientToken;

    private BatchDisassociateProjectAssetsRequest(BuilderImpl builder) {
        super(builder);
        this.projectId = builder.projectId;
        this.assetIds = builder.assetIds;
        this.clientToken = builder.clientToken;
    }

    public final String projectId() {
        return this.projectId;
    }

    public final boolean hasAssetIds() {
        return this.assetIds != null && !(this.assetIds instanceof SdkAutoConstructList);
    }

    public final List<String> assetIds() {
        return this.assetIds;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.projectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetIds() ? this.assetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDisassociateProjectAssetsRequest)) {
            return false;
        }
        BatchDisassociateProjectAssetsRequest other = (BatchDisassociateProjectAssetsRequest)((Object)obj);
        return Objects.equals(this.projectId(), other.projectId()) && this.hasAssetIds() == other.hasAssetIds() && Objects.equals(this.assetIds(), other.assetIds()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDisassociateProjectAssetsRequest").add("ProjectId", (Object)this.projectId()).add("AssetIds", this.hasAssetIds() ? this.assetIds() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectId": {
                return Optional.ofNullable(clazz.cast(this.projectId()));
            }
            case "assetIds": {
                return Optional.ofNullable(clazz.cast(this.assetIds()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectId", PROJECT_ID_FIELD);
        map.put("assetIds", ASSET_IDS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDisassociateProjectAssetsRequest, T> g) {
        return obj -> g.apply((BatchDisassociateProjectAssetsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String projectId;
        private List<String> assetIds = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDisassociateProjectAssetsRequest model) {
            super(model);
            this.projectId(model.projectId);
            this.assetIds(model.assetIds);
            this.clientToken(model.clientToken);
        }

        public final String getProjectId() {
            return this.projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final Collection<String> getAssetIds() {
            if (this.assetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.assetIds;
        }

        public final void setAssetIds(Collection<String> assetIds) {
            this.assetIds = IDsCopier.copy(assetIds);
        }

        @Override
        public final Builder assetIds(Collection<String> assetIds) {
            this.assetIds = IDsCopier.copy(assetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetIds(String ... assetIds) {
            this.assetIds(Arrays.asList(assetIds));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDisassociateProjectAssetsRequest build() {
            return new BatchDisassociateProjectAssetsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDisassociateProjectAssetsRequest> {
        public Builder projectId(String var1);

        public Builder assetIds(Collection<String> var1);

        public Builder assetIds(String ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

