/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DatasetSourceType {
    KENDRA("KENDRA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DatasetSourceType> VALUE_MAP;
    private final String value;

    private DatasetSourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DatasetSourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DatasetSourceType> knownValues() {
        EnumSet<DatasetSourceType> knownValues = EnumSet.allOf(DatasetSourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DatasetSourceType.class, DatasetSourceType::toString);
    }
}

