/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelType;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsTypeFilterCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssetModelsRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, ListAssetModelsRequest> {
    private static final SdkField<List<String>> ASSET_MODEL_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetModelTypes").getter(ListAssetModelsRequest.getter(ListAssetModelsRequest::assetModelTypesAsStrings)).setter(ListAssetModelsRequest.setter(Builder::assetModelTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("assetModelTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAssetModelsRequest.getter(ListAssetModelsRequest::nextToken)).setter(ListAssetModelsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListAssetModelsRequest.getter(ListAssetModelsRequest::maxResults)).setter(ListAssetModelsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> ASSET_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelVersion").getter(ListAssetModelsRequest.getter(ListAssetModelsRequest::assetModelVersion)).setter(ListAssetModelsRequest.setter(Builder::assetModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("assetModelVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_TYPES_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, ASSET_MODEL_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAssetModelsRequest.memberNameToFieldInitializer();
    private final List<String> assetModelTypes;
    private final String nextToken;
    private final Integer maxResults;
    private final String assetModelVersion;

    private ListAssetModelsRequest(BuilderImpl builder) {
        super(builder);
        this.assetModelTypes = builder.assetModelTypes;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.assetModelVersion = builder.assetModelVersion;
    }

    public final List<AssetModelType> assetModelTypes() {
        return ListAssetModelsTypeFilterCopier.copyStringToEnum(this.assetModelTypes);
    }

    public final boolean hasAssetModelTypes() {
        return this.assetModelTypes != null && !(this.assetModelTypes instanceof SdkAutoConstructList);
    }

    public final List<String> assetModelTypesAsStrings() {
        return this.assetModelTypes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String assetModelVersion() {
        return this.assetModelVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetModelTypes() ? this.assetModelTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssetModelsRequest)) {
            return false;
        }
        ListAssetModelsRequest other = (ListAssetModelsRequest)((Object)obj);
        return this.hasAssetModelTypes() == other.hasAssetModelTypes() && Objects.equals(this.assetModelTypesAsStrings(), other.assetModelTypesAsStrings()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.assetModelVersion(), other.assetModelVersion());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssetModelsRequest").add("AssetModelTypes", this.hasAssetModelTypes() ? this.assetModelTypesAsStrings() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("AssetModelVersion", (Object)this.assetModelVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetModelTypes": {
                return Optional.ofNullable(clazz.cast(this.assetModelTypesAsStrings()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "assetModelVersion": {
                return Optional.ofNullable(clazz.cast(this.assetModelVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assetModelTypes", ASSET_MODEL_TYPES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("assetModelVersion", ASSET_MODEL_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAssetModelsRequest, T> g) {
        return obj -> g.apply((ListAssetModelsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private List<String> assetModelTypes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;
        private String assetModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssetModelsRequest model) {
            super(model);
            this.assetModelTypesWithStrings(model.assetModelTypes);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.assetModelVersion(model.assetModelVersion);
        }

        public final Collection<String> getAssetModelTypes() {
            if (this.assetModelTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.assetModelTypes;
        }

        public final void setAssetModelTypes(Collection<String> assetModelTypes) {
            this.assetModelTypes = ListAssetModelsTypeFilterCopier.copy(assetModelTypes);
        }

        @Override
        public final Builder assetModelTypesWithStrings(Collection<String> assetModelTypes) {
            this.assetModelTypes = ListAssetModelsTypeFilterCopier.copy(assetModelTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelTypesWithStrings(String ... assetModelTypes) {
            this.assetModelTypesWithStrings(Arrays.asList(assetModelTypes));
            return this;
        }

        @Override
        public final Builder assetModelTypes(Collection<AssetModelType> assetModelTypes) {
            this.assetModelTypes = ListAssetModelsTypeFilterCopier.copyEnumToString(assetModelTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelTypes(AssetModelType ... assetModelTypes) {
            this.assetModelTypes(Arrays.asList(assetModelTypes));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getAssetModelVersion() {
            return this.assetModelVersion;
        }

        public final void setAssetModelVersion(String assetModelVersion) {
            this.assetModelVersion = assetModelVersion;
        }

        @Override
        public final Builder assetModelVersion(String assetModelVersion) {
            this.assetModelVersion = assetModelVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAssetModelsRequest build() {
            return new ListAssetModelsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssetModelsRequest> {
        public Builder assetModelTypesWithStrings(Collection<String> var1);

        public Builder assetModelTypesWithStrings(String ... var1);

        public Builder assetModelTypes(Collection<AssetModelType> var1);

        public Builder assetModelTypes(AssetModelType ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder assetModelVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

