/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.AssetPropertyValue;
import software.amazon.awssdk.services.iotsitewise.model.AssetPropertyValueHistoryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetAssetPropertyValueHistorySuccessEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchGetAssetPropertyValueHistorySuccessEntry> {
    private static final SdkField<String> ENTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entryId").getter(BatchGetAssetPropertyValueHistorySuccessEntry.getter(BatchGetAssetPropertyValueHistorySuccessEntry::entryId)).setter(BatchGetAssetPropertyValueHistorySuccessEntry.setter(Builder::entryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryId").build()}).build();
    private static final SdkField<List<AssetPropertyValue>> ASSET_PROPERTY_VALUE_HISTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetPropertyValueHistory").getter(BatchGetAssetPropertyValueHistorySuccessEntry.getter(BatchGetAssetPropertyValueHistorySuccessEntry::assetPropertyValueHistory)).setter(BatchGetAssetPropertyValueHistorySuccessEntry.setter(Builder::assetPropertyValueHistory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetPropertyValueHistory").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetPropertyValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_ID_FIELD, ASSET_PROPERTY_VALUE_HISTORY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetAssetPropertyValueHistorySuccessEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String entryId;
    private final List<AssetPropertyValue> assetPropertyValueHistory;

    private BatchGetAssetPropertyValueHistorySuccessEntry(BuilderImpl builder) {
        this.entryId = builder.entryId;
        this.assetPropertyValueHistory = builder.assetPropertyValueHistory;
    }

    public final String entryId() {
        return this.entryId;
    }

    public final boolean hasAssetPropertyValueHistory() {
        return this.assetPropertyValueHistory != null && !(this.assetPropertyValueHistory instanceof SdkAutoConstructList);
    }

    public final List<AssetPropertyValue> assetPropertyValueHistory() {
        return this.assetPropertyValueHistory;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetPropertyValueHistory() ? this.assetPropertyValueHistory() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAssetPropertyValueHistorySuccessEntry)) {
            return false;
        }
        BatchGetAssetPropertyValueHistorySuccessEntry other = (BatchGetAssetPropertyValueHistorySuccessEntry)obj;
        return Objects.equals(this.entryId(), other.entryId()) && this.hasAssetPropertyValueHistory() == other.hasAssetPropertyValueHistory() && Objects.equals(this.assetPropertyValueHistory(), other.assetPropertyValueHistory());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetAssetPropertyValueHistorySuccessEntry").add("EntryId", (Object)this.entryId()).add("AssetPropertyValueHistory", this.hasAssetPropertyValueHistory() ? this.assetPropertyValueHistory() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entryId": {
                return Optional.ofNullable(clazz.cast(this.entryId()));
            }
            case "assetPropertyValueHistory": {
                return Optional.ofNullable(clazz.cast(this.assetPropertyValueHistory()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("entryId", ENTRY_ID_FIELD);
        map.put("assetPropertyValueHistory", ASSET_PROPERTY_VALUE_HISTORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAssetPropertyValueHistorySuccessEntry, T> g) {
        return obj -> g.apply((BatchGetAssetPropertyValueHistorySuccessEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String entryId;
        private List<AssetPropertyValue> assetPropertyValueHistory = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAssetPropertyValueHistorySuccessEntry model) {
            this.entryId(model.entryId);
            this.assetPropertyValueHistory(model.assetPropertyValueHistory);
        }

        public final String getEntryId() {
            return this.entryId;
        }

        public final void setEntryId(String entryId) {
            this.entryId = entryId;
        }

        @Override
        public final Builder entryId(String entryId) {
            this.entryId = entryId;
            return this;
        }

        public final List<AssetPropertyValue.Builder> getAssetPropertyValueHistory() {
            List<AssetPropertyValue.Builder> result = AssetPropertyValueHistoryCopier.copyToBuilder(this.assetPropertyValueHistory);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetPropertyValueHistory(Collection<AssetPropertyValue.BuilderImpl> assetPropertyValueHistory) {
            this.assetPropertyValueHistory = AssetPropertyValueHistoryCopier.copyFromBuilder(assetPropertyValueHistory);
        }

        @Override
        public final Builder assetPropertyValueHistory(Collection<AssetPropertyValue> assetPropertyValueHistory) {
            this.assetPropertyValueHistory = AssetPropertyValueHistoryCopier.copy(assetPropertyValueHistory);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetPropertyValueHistory(AssetPropertyValue ... assetPropertyValueHistory) {
            this.assetPropertyValueHistory(Arrays.asList(assetPropertyValueHistory));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetPropertyValueHistory(Consumer<AssetPropertyValue.Builder> ... assetPropertyValueHistory) {
            this.assetPropertyValueHistory(Stream.of(assetPropertyValueHistory).map(c -> (AssetPropertyValue)((AssetPropertyValue.Builder)AssetPropertyValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public BatchGetAssetPropertyValueHistorySuccessEntry build() {
            return new BatchGetAssetPropertyValueHistorySuccessEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchGetAssetPropertyValueHistorySuccessEntry> {
        public Builder entryId(String var1);

        public Builder assetPropertyValueHistory(Collection<AssetPropertyValue> var1);

        public Builder assetPropertyValueHistory(AssetPropertyValue ... var1);

        public Builder assetPropertyValueHistory(Consumer<AssetPropertyValue.Builder> ... var1);
    }
}

