/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.ColumnInfo;
import software.amazon.awssdk.services.iotsitewise.model.ColumnsListCopier;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.services.iotsitewise.model.Row;
import software.amazon.awssdk.services.iotsitewise.model.RowsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecuteQueryResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, ExecuteQueryResponse> {
    private static final SdkField<List<ColumnInfo>> COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("columns").getter(ExecuteQueryResponse.getter(ExecuteQueryResponse::columns)).setter(ExecuteQueryResponse.setter(Builder::columns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Row>> ROWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rows").getter(ExecuteQueryResponse.getter(ExecuteQueryResponse::rows)).setter(ExecuteQueryResponse.setter(Builder::rows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Row::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ExecuteQueryResponse.getter(ExecuteQueryResponse::nextToken)).setter(ExecuteQueryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMNS_FIELD, ROWS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExecuteQueryResponse.memberNameToFieldInitializer();
    private final List<ColumnInfo> columns;
    private final List<Row> rows;
    private final String nextToken;

    private ExecuteQueryResponse(BuilderImpl builder) {
        super(builder);
        this.columns = builder.columns;
        this.rows = builder.rows;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasColumns() {
        return this.columns != null && !(this.columns instanceof SdkAutoConstructList);
    }

    public final List<ColumnInfo> columns() {
        return this.columns;
    }

    public final boolean hasRows() {
        return this.rows != null && !(this.rows instanceof SdkAutoConstructList);
    }

    public final List<Row> rows() {
        return this.rows;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumns() ? this.columns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRows() ? this.rows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteQueryResponse)) {
            return false;
        }
        ExecuteQueryResponse other = (ExecuteQueryResponse)((Object)obj);
        return this.hasColumns() == other.hasColumns() && Objects.equals(this.columns(), other.columns()) && this.hasRows() == other.hasRows() && Objects.equals(this.rows(), other.rows()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ExecuteQueryResponse").add("Columns", this.hasColumns() ? this.columns() : null).add("Rows", this.hasRows() ? this.rows() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "columns": {
                return Optional.ofNullable(clazz.cast(this.columns()));
            }
            case "rows": {
                return Optional.ofNullable(clazz.cast(this.rows()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("columns", COLUMNS_FIELD);
        map.put("rows", ROWS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecuteQueryResponse, T> g) {
        return obj -> g.apply((ExecuteQueryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private List<ColumnInfo> columns = DefaultSdkAutoConstructList.getInstance();
        private List<Row> rows = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteQueryResponse model) {
            super(model);
            this.columns(model.columns);
            this.rows(model.rows);
            this.nextToken(model.nextToken);
        }

        public final List<ColumnInfo.Builder> getColumns() {
            List<ColumnInfo.Builder> result = ColumnsListCopier.copyToBuilder(this.columns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumns(Collection<ColumnInfo.BuilderImpl> columns) {
            this.columns = ColumnsListCopier.copyFromBuilder(columns);
        }

        @Override
        public final Builder columns(Collection<ColumnInfo> columns) {
            this.columns = ColumnsListCopier.copy(columns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(ColumnInfo ... columns) {
            this.columns(Arrays.asList(columns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(Consumer<ColumnInfo.Builder> ... columns) {
            this.columns(Stream.of(columns).map(c -> (ColumnInfo)((ColumnInfo.Builder)ColumnInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Row.Builder> getRows() {
            List<Row.Builder> result = RowsCopier.copyToBuilder(this.rows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRows(Collection<Row.BuilderImpl> rows) {
            this.rows = RowsCopier.copyFromBuilder(rows);
        }

        @Override
        public final Builder rows(Collection<Row> rows) {
            this.rows = RowsCopier.copy(rows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(Row ... rows) {
            this.rows(Arrays.asList(rows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(Consumer<Row.Builder> ... rows) {
            this.rows(Stream.of(rows).map(c -> (Row)((Row.Builder)Row.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ExecuteQueryResponse build() {
            return new ExecuteQueryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExecuteQueryResponse> {
        public Builder columns(Collection<ColumnInfo> var1);

        public Builder columns(ColumnInfo ... var1);

        public Builder columns(Consumer<ColumnInfo.Builder> ... var1);

        public Builder rows(Collection<Row> var1);

        public Builder rows(Row ... var1);

        public Builder rows(Consumer<Row.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

