/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.DatasetSourceFormat;
import software.amazon.awssdk.services.iotsitewise.model.DatasetSourceType;
import software.amazon.awssdk.services.iotsitewise.model.SourceDetail;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatasetSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatasetSource> {
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceType").getter(DatasetSource.getter(DatasetSource::sourceTypeAsString)).setter(DatasetSource.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceType").build()}).build();
    private static final SdkField<String> SOURCE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceFormat").getter(DatasetSource.getter(DatasetSource::sourceFormatAsString)).setter(DatasetSource.setter(Builder::sourceFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFormat").build()}).build();
    private static final SdkField<SourceDetail> SOURCE_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceDetail").getter(DatasetSource.getter(DatasetSource::sourceDetail)).setter(DatasetSource.setter(Builder::sourceDetail)).constructor(SourceDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceDetail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TYPE_FIELD, SOURCE_FORMAT_FIELD, SOURCE_DETAIL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DatasetSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sourceType;
    private final String sourceFormat;
    private final SourceDetail sourceDetail;

    private DatasetSource(BuilderImpl builder) {
        this.sourceType = builder.sourceType;
        this.sourceFormat = builder.sourceFormat;
        this.sourceDetail = builder.sourceDetail;
    }

    public final DatasetSourceType sourceType() {
        return DatasetSourceType.fromValue(this.sourceType);
    }

    public final String sourceTypeAsString() {
        return this.sourceType;
    }

    public final DatasetSourceFormat sourceFormat() {
        return DatasetSourceFormat.fromValue(this.sourceFormat);
    }

    public final String sourceFormatAsString() {
        return this.sourceFormat;
    }

    public final SourceDetail sourceDetail() {
        return this.sourceDetail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDetail());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetSource)) {
            return false;
        }
        DatasetSource other = (DatasetSource)obj;
        return Objects.equals(this.sourceTypeAsString(), other.sourceTypeAsString()) && Objects.equals(this.sourceFormatAsString(), other.sourceFormatAsString()) && Objects.equals(this.sourceDetail(), other.sourceDetail());
    }

    public final String toString() {
        return ToString.builder((String)"DatasetSource").add("SourceType", (Object)this.sourceTypeAsString()).add("SourceFormat", (Object)this.sourceFormatAsString()).add("SourceDetail", (Object)this.sourceDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeAsString()));
            }
            case "sourceFormat": {
                return Optional.ofNullable(clazz.cast(this.sourceFormatAsString()));
            }
            case "sourceDetail": {
                return Optional.ofNullable(clazz.cast(this.sourceDetail()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceType", SOURCE_TYPE_FIELD);
        map.put("sourceFormat", SOURCE_FORMAT_FIELD);
        map.put("sourceDetail", SOURCE_DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatasetSource, T> g) {
        return obj -> g.apply((DatasetSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceType;
        private String sourceFormat;
        private SourceDetail sourceDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetSource model) {
            this.sourceType(model.sourceType);
            this.sourceFormat(model.sourceFormat);
            this.sourceDetail(model.sourceDetail);
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(DatasetSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final String getSourceFormat() {
            return this.sourceFormat;
        }

        public final void setSourceFormat(String sourceFormat) {
            this.sourceFormat = sourceFormat;
        }

        @Override
        public final Builder sourceFormat(String sourceFormat) {
            this.sourceFormat = sourceFormat;
            return this;
        }

        @Override
        public final Builder sourceFormat(DatasetSourceFormat sourceFormat) {
            this.sourceFormat(sourceFormat == null ? null : sourceFormat.toString());
            return this;
        }

        public final SourceDetail.Builder getSourceDetail() {
            return this.sourceDetail != null ? this.sourceDetail.toBuilder() : null;
        }

        public final void setSourceDetail(SourceDetail.BuilderImpl sourceDetail) {
            this.sourceDetail = sourceDetail != null ? sourceDetail.build() : null;
        }

        @Override
        public final Builder sourceDetail(SourceDetail sourceDetail) {
            this.sourceDetail = sourceDetail;
            return this;
        }

        public DatasetSource build() {
            return new DatasetSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatasetSource> {
        public Builder sourceType(String var1);

        public Builder sourceType(DatasetSourceType var1);

        public Builder sourceFormat(String var1);

        public Builder sourceFormat(DatasetSourceFormat var1);

        public Builder sourceDetail(SourceDetail var1);

        default public Builder sourceDetail(Consumer<SourceDetail.Builder> sourceDetail) {
            return this.sourceDetail((SourceDetail)((SourceDetail.Builder)SourceDetail.builder().applyMutation(sourceDetail)).build());
        }
    }
}

