/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.GatewayCapabilitySummariesCopier;
import software.amazon.awssdk.services.iotsitewise.model.GatewayCapabilitySummary;
import software.amazon.awssdk.services.iotsitewise.model.GatewayPlatform;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeGatewayResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, DescribeGatewayResponse> {
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("gatewayId").getter(DescribeGatewayResponse.getter(DescribeGatewayResponse::gatewayId)).setter(DescribeGatewayResponse.setter(Builder::gatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayId").build()}).build();
    private static final SdkField<String> GATEWAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("gatewayName").getter(DescribeGatewayResponse.getter(DescribeGatewayResponse::gatewayName)).setter(DescribeGatewayResponse.setter(Builder::gatewayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayName").build()}).build();
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("gatewayArn").getter(DescribeGatewayResponse.getter(DescribeGatewayResponse::gatewayArn)).setter(DescribeGatewayResponse.setter(Builder::gatewayArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayArn").build()}).build();
    private static final SdkField<GatewayPlatform> GATEWAY_PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("gatewayPlatform").getter(DescribeGatewayResponse.getter(DescribeGatewayResponse::gatewayPlatform)).setter(DescribeGatewayResponse.setter(Builder::gatewayPlatform)).constructor(GatewayPlatform::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayPlatform").build()}).build();
    private static final SdkField<List<GatewayCapabilitySummary>> GATEWAY_CAPABILITY_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("gatewayCapabilitySummaries").getter(DescribeGatewayResponse.getter(DescribeGatewayResponse::gatewayCapabilitySummaries)).setter(DescribeGatewayResponse.setter(Builder::gatewayCapabilitySummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayCapabilitySummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GatewayCapabilitySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(DescribeGatewayResponse.getter(DescribeGatewayResponse::creationDate)).setter(DescribeGatewayResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdateDate").getter(DescribeGatewayResponse.getter(DescribeGatewayResponse::lastUpdateDate)).setter(DescribeGatewayResponse.setter(Builder::lastUpdateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ID_FIELD, GATEWAY_NAME_FIELD, GATEWAY_ARN_FIELD, GATEWAY_PLATFORM_FIELD, GATEWAY_CAPABILITY_SUMMARIES_FIELD, CREATION_DATE_FIELD, LAST_UPDATE_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeGatewayResponse.memberNameToFieldInitializer();
    private final String gatewayId;
    private final String gatewayName;
    private final String gatewayArn;
    private final GatewayPlatform gatewayPlatform;
    private final List<GatewayCapabilitySummary> gatewayCapabilitySummaries;
    private final Instant creationDate;
    private final Instant lastUpdateDate;

    private DescribeGatewayResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayId = builder.gatewayId;
        this.gatewayName = builder.gatewayName;
        this.gatewayArn = builder.gatewayArn;
        this.gatewayPlatform = builder.gatewayPlatform;
        this.gatewayCapabilitySummaries = builder.gatewayCapabilitySummaries;
        this.creationDate = builder.creationDate;
        this.lastUpdateDate = builder.lastUpdateDate;
    }

    public final String gatewayId() {
        return this.gatewayId;
    }

    public final String gatewayName() {
        return this.gatewayName;
    }

    public final String gatewayArn() {
        return this.gatewayArn;
    }

    public final GatewayPlatform gatewayPlatform() {
        return this.gatewayPlatform;
    }

    public final boolean hasGatewayCapabilitySummaries() {
        return this.gatewayCapabilitySummaries != null && !(this.gatewayCapabilitySummaries instanceof SdkAutoConstructList);
    }

    public final List<GatewayCapabilitySummary> gatewayCapabilitySummaries() {
        return this.gatewayCapabilitySummaries;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant lastUpdateDate() {
        return this.lastUpdateDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayPlatform());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGatewayCapabilitySummaries() ? this.gatewayCapabilitySummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGatewayResponse)) {
            return false;
        }
        DescribeGatewayResponse other = (DescribeGatewayResponse)((Object)obj);
        return Objects.equals(this.gatewayId(), other.gatewayId()) && Objects.equals(this.gatewayName(), other.gatewayName()) && Objects.equals(this.gatewayArn(), other.gatewayArn()) && Objects.equals(this.gatewayPlatform(), other.gatewayPlatform()) && this.hasGatewayCapabilitySummaries() == other.hasGatewayCapabilitySummaries() && Objects.equals(this.gatewayCapabilitySummaries(), other.gatewayCapabilitySummaries()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastUpdateDate(), other.lastUpdateDate());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeGatewayResponse").add("GatewayId", (Object)this.gatewayId()).add("GatewayName", (Object)this.gatewayName()).add("GatewayArn", (Object)this.gatewayArn()).add("GatewayPlatform", (Object)this.gatewayPlatform()).add("GatewayCapabilitySummaries", this.hasGatewayCapabilitySummaries() ? this.gatewayCapabilitySummaries() : null).add("CreationDate", (Object)this.creationDate()).add("LastUpdateDate", (Object)this.lastUpdateDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "gatewayId": {
                return Optional.ofNullable(clazz.cast(this.gatewayId()));
            }
            case "gatewayName": {
                return Optional.ofNullable(clazz.cast(this.gatewayName()));
            }
            case "gatewayArn": {
                return Optional.ofNullable(clazz.cast(this.gatewayArn()));
            }
            case "gatewayPlatform": {
                return Optional.ofNullable(clazz.cast(this.gatewayPlatform()));
            }
            case "gatewayCapabilitySummaries": {
                return Optional.ofNullable(clazz.cast(this.gatewayCapabilitySummaries()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "lastUpdateDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("gatewayId", GATEWAY_ID_FIELD);
        map.put("gatewayName", GATEWAY_NAME_FIELD);
        map.put("gatewayArn", GATEWAY_ARN_FIELD);
        map.put("gatewayPlatform", GATEWAY_PLATFORM_FIELD);
        map.put("gatewayCapabilitySummaries", GATEWAY_CAPABILITY_SUMMARIES_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        map.put("lastUpdateDate", LAST_UPDATE_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeGatewayResponse, T> g) {
        return obj -> g.apply((DescribeGatewayResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private String gatewayId;
        private String gatewayName;
        private String gatewayArn;
        private GatewayPlatform gatewayPlatform;
        private List<GatewayCapabilitySummary> gatewayCapabilitySummaries = DefaultSdkAutoConstructList.getInstance();
        private Instant creationDate;
        private Instant lastUpdateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGatewayResponse model) {
            super(model);
            this.gatewayId(model.gatewayId);
            this.gatewayName(model.gatewayName);
            this.gatewayArn(model.gatewayArn);
            this.gatewayPlatform(model.gatewayPlatform);
            this.gatewayCapabilitySummaries(model.gatewayCapabilitySummaries);
            this.creationDate(model.creationDate);
            this.lastUpdateDate(model.lastUpdateDate);
        }

        public final String getGatewayId() {
            return this.gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final String getGatewayName() {
            return this.gatewayName;
        }

        public final void setGatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
        }

        @Override
        public final Builder gatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
            return this;
        }

        public final String getGatewayArn() {
            return this.gatewayArn;
        }

        public final void setGatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
        }

        @Override
        public final Builder gatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
            return this;
        }

        public final GatewayPlatform.Builder getGatewayPlatform() {
            return this.gatewayPlatform != null ? this.gatewayPlatform.toBuilder() : null;
        }

        public final void setGatewayPlatform(GatewayPlatform.BuilderImpl gatewayPlatform) {
            this.gatewayPlatform = gatewayPlatform != null ? gatewayPlatform.build() : null;
        }

        @Override
        public final Builder gatewayPlatform(GatewayPlatform gatewayPlatform) {
            this.gatewayPlatform = gatewayPlatform;
            return this;
        }

        public final List<GatewayCapabilitySummary.Builder> getGatewayCapabilitySummaries() {
            List<GatewayCapabilitySummary.Builder> result = GatewayCapabilitySummariesCopier.copyToBuilder(this.gatewayCapabilitySummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGatewayCapabilitySummaries(Collection<GatewayCapabilitySummary.BuilderImpl> gatewayCapabilitySummaries) {
            this.gatewayCapabilitySummaries = GatewayCapabilitySummariesCopier.copyFromBuilder(gatewayCapabilitySummaries);
        }

        @Override
        public final Builder gatewayCapabilitySummaries(Collection<GatewayCapabilitySummary> gatewayCapabilitySummaries) {
            this.gatewayCapabilitySummaries = GatewayCapabilitySummariesCopier.copy(gatewayCapabilitySummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayCapabilitySummaries(GatewayCapabilitySummary ... gatewayCapabilitySummaries) {
            this.gatewayCapabilitySummaries(Arrays.asList(gatewayCapabilitySummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayCapabilitySummaries(Consumer<GatewayCapabilitySummary.Builder> ... gatewayCapabilitySummaries) {
            this.gatewayCapabilitySummaries(Stream.of(gatewayCapabilitySummaries).map(c -> (GatewayCapabilitySummary)((GatewayCapabilitySummary.Builder)GatewayCapabilitySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastUpdateDate() {
            return this.lastUpdateDate;
        }

        public final void setLastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
        }

        @Override
        public final Builder lastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
            return this;
        }

        @Override
        public DescribeGatewayResponse build() {
            return new DescribeGatewayResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeGatewayResponse> {
        public Builder gatewayId(String var1);

        public Builder gatewayName(String var1);

        public Builder gatewayArn(String var1);

        public Builder gatewayPlatform(GatewayPlatform var1);

        default public Builder gatewayPlatform(Consumer<GatewayPlatform.Builder> gatewayPlatform) {
            return this.gatewayPlatform((GatewayPlatform)((GatewayPlatform.Builder)GatewayPlatform.builder().applyMutation(gatewayPlatform)).build());
        }

        public Builder gatewayCapabilitySummaries(Collection<GatewayCapabilitySummary> var1);

        public Builder gatewayCapabilitySummaries(GatewayCapabilitySummary ... var1);

        public Builder gatewayCapabilitySummaries(Consumer<GatewayCapabilitySummary.Builder> ... var1);

        public Builder creationDate(Instant var1);

        public Builder lastUpdateDate(Instant var1);
    }
}

