/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.PortalResource;
import software.amazon.awssdk.services.iotsitewise.model.ProjectResource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Resource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Resource> {
    private static final SdkField<PortalResource> PORTAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("portal").getter(Resource.getter(Resource::portal)).setter(Resource.setter(Builder::portal)).constructor(PortalResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portal").build()}).build();
    private static final SdkField<ProjectResource> PROJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("project").getter(Resource.getter(Resource::project)).setter(Resource.setter(Builder::project)).constructor(ProjectResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("project").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTAL_FIELD, PROJECT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Resource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final PortalResource portal;
    private final ProjectResource project;

    private Resource(BuilderImpl builder) {
        this.portal = builder.portal;
        this.project = builder.project;
    }

    public final PortalResource portal() {
        return this.portal;
    }

    public final ProjectResource project() {
        return this.project;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.portal());
        hashCode = 31 * hashCode + Objects.hashCode(this.project());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        return Objects.equals(this.portal(), other.portal()) && Objects.equals(this.project(), other.project());
    }

    public final String toString() {
        return ToString.builder((String)"Resource").add("Portal", (Object)this.portal()).add("Project", (Object)this.project()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "portal": {
                return Optional.ofNullable(clazz.cast(this.portal()));
            }
            case "project": {
                return Optional.ofNullable(clazz.cast(this.project()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("portal", PORTAL_FIELD);
        map.put("project", PROJECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Resource, T> g) {
        return obj -> g.apply((Resource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private PortalResource portal;
        private ProjectResource project;

        private BuilderImpl() {
        }

        private BuilderImpl(Resource model) {
            this.portal(model.portal);
            this.project(model.project);
        }

        public final PortalResource.Builder getPortal() {
            return this.portal != null ? this.portal.toBuilder() : null;
        }

        public final void setPortal(PortalResource.BuilderImpl portal) {
            this.portal = portal != null ? portal.build() : null;
        }

        @Override
        public final Builder portal(PortalResource portal) {
            this.portal = portal;
            return this;
        }

        public final ProjectResource.Builder getProject() {
            return this.project != null ? this.project.toBuilder() : null;
        }

        public final void setProject(ProjectResource.BuilderImpl project) {
            this.project = project != null ? project.build() : null;
        }

        @Override
        public final Builder project(ProjectResource project) {
            this.project = project;
            return this;
        }

        public Resource build() {
            return new Resource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Resource> {
        public Builder portal(PortalResource var1);

        default public Builder portal(Consumer<PortalResource.Builder> portal) {
            return this.portal((PortalResource)((PortalResource.Builder)PortalResource.builder().applyMutation(portal)).build());
        }

        public Builder project(ProjectResource var1);

        default public Builder project(Consumer<ProjectResource.Builder> project) {
            return this.project((ProjectResource)((ProjectResource.Builder)ProjectResource.builder().applyMutation(project)).build());
        }
    }
}

