/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.AssetPropertySummariesCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetPropertySummary;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssetPropertiesResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, ListAssetPropertiesResponse> {
    private static final SdkField<List<AssetPropertySummary>> ASSET_PROPERTY_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetPropertySummaries").getter(ListAssetPropertiesResponse.getter(ListAssetPropertiesResponse::assetPropertySummaries)).setter(ListAssetPropertiesResponse.setter(Builder::assetPropertySummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetPropertySummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetPropertySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAssetPropertiesResponse.getter(ListAssetPropertiesResponse::nextToken)).setter(ListAssetPropertiesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_PROPERTY_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAssetPropertiesResponse.memberNameToFieldInitializer();
    private final List<AssetPropertySummary> assetPropertySummaries;
    private final String nextToken;

    private ListAssetPropertiesResponse(BuilderImpl builder) {
        super(builder);
        this.assetPropertySummaries = builder.assetPropertySummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAssetPropertySummaries() {
        return this.assetPropertySummaries != null && !(this.assetPropertySummaries instanceof SdkAutoConstructList);
    }

    public final List<AssetPropertySummary> assetPropertySummaries() {
        return this.assetPropertySummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetPropertySummaries() ? this.assetPropertySummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssetPropertiesResponse)) {
            return false;
        }
        ListAssetPropertiesResponse other = (ListAssetPropertiesResponse)((Object)obj);
        return this.hasAssetPropertySummaries() == other.hasAssetPropertySummaries() && Objects.equals(this.assetPropertySummaries(), other.assetPropertySummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssetPropertiesResponse").add("AssetPropertySummaries", this.hasAssetPropertySummaries() ? this.assetPropertySummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetPropertySummaries": {
                return Optional.ofNullable(clazz.cast(this.assetPropertySummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assetPropertySummaries", ASSET_PROPERTY_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAssetPropertiesResponse, T> g) {
        return obj -> g.apply((ListAssetPropertiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private List<AssetPropertySummary> assetPropertySummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssetPropertiesResponse model) {
            super(model);
            this.assetPropertySummaries(model.assetPropertySummaries);
            this.nextToken(model.nextToken);
        }

        public final List<AssetPropertySummary.Builder> getAssetPropertySummaries() {
            List<AssetPropertySummary.Builder> result = AssetPropertySummariesCopier.copyToBuilder(this.assetPropertySummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetPropertySummaries(Collection<AssetPropertySummary.BuilderImpl> assetPropertySummaries) {
            this.assetPropertySummaries = AssetPropertySummariesCopier.copyFromBuilder(assetPropertySummaries);
        }

        @Override
        public final Builder assetPropertySummaries(Collection<AssetPropertySummary> assetPropertySummaries) {
            this.assetPropertySummaries = AssetPropertySummariesCopier.copy(assetPropertySummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetPropertySummaries(AssetPropertySummary ... assetPropertySummaries) {
            this.assetPropertySummaries(Arrays.asList(assetPropertySummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetPropertySummaries(Consumer<AssetPropertySummary.Builder> ... assetPropertySummaries) {
            this.assetPropertySummaries(Stream.of(assetPropertySummaries).map(c -> (AssetPropertySummary)((AssetPropertySummary.Builder)AssetPropertySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAssetPropertiesResponse build() {
            return new ListAssetPropertiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssetPropertiesResponse> {
        public Builder assetPropertySummaries(Collection<AssetPropertySummary> var1);

        public Builder assetPropertySummaries(AssetPropertySummary ... var1);

        public Builder assetPropertySummaries(Consumer<AssetPropertySummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

